/*
 * Decompiled with CFR 0.152.
 */
package org.cloudsimplus.resources;

import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.cloudsimplus.distributions.ContinuousDistribution;
import org.cloudsimplus.resources.FileStorage;
import org.cloudsimplus.resources.SimpleStorage;
import org.cloudsimplus.util.BytesConversion;
import org.cloudsimplus.util.MathUtil;

public class HarddriveStorage
implements FileStorage {
    private final SimpleStorage storage;
    private final String name;
    @NonNull
    private ContinuousDistribution prng;
    private double maxTransferRate;
    private double latency;
    private double avgSeekTime;

    public HarddriveStorage(@NonNull String name, long capacity) throws IllegalArgumentException {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (StringUtils.isBlank((CharSequence)name)) {
            throw new IllegalArgumentException("Storage name cannot be empty.");
        }
        this.name = name;
        this.storage = new SimpleStorage(capacity);
        this.prng = ContinuousDistribution.NULL;
        this.init();
    }

    public HarddriveStorage(long capacity) throws IllegalArgumentException {
        this("HarddriveStorage", capacity);
    }

    private void init() {
        this.setLatency(0.00417);
        this.setAvgSeekTime(0.009);
        this.setMaxTransferRate(1064.0);
    }

    @Override
    public FileStorage setLatency(double latency) {
        if (latency < 0.0) {
            throw new IllegalArgumentException("Latency must be greater than zero.");
        }
        this.latency = latency;
        return this;
    }

    @Override
    public FileStorage setMaxTransferRate(double maxTransferRate) {
        if (maxTransferRate <= 0.0) {
            throw new IllegalArgumentException("Max transfer rate must be greater than zero.");
        }
        this.maxTransferRate = maxTransferRate;
        return this;
    }

    public HarddriveStorage setAvgSeekTime(double seekTime) {
        this.avgSeekTime = MathUtil.nonNegative(seekTime, "seekTime");
        return this;
    }

    public double getSeekTime(int fileSize) {
        if (fileSize > 0 && this.storage.getCapacity() != 0L) {
            return this.prng.sample() + (double)fileSize / (double)this.storage.getCapacity();
        }
        return 0.0;
    }

    @Override
    public double getTransferTime(int fileSize) {
        return this.getTransferTime(fileSize, this.getMaxTransferRate()) + this.getLatency();
    }

    protected final double getTransferTime(int fileSize, double speed) {
        return BytesConversion.bytesToBits(fileSize) / speed;
    }

    @Override
    public long getCapacity() {
        return this.storage.getCapacity();
    }

    @Override
    public long getAvailableResource() {
        return this.storage.getAvailableResource();
    }

    @Override
    public long getAllocatedResource() {
        return this.storage.getAllocatedResource();
    }

    @Override
    public boolean isAmountAvailable(long amountToCheck) {
        return this.storage.isAmountAvailable(amountToCheck);
    }

    @Override
    public boolean isAmountAvailable(double amountToCheck) {
        return this.isAmountAvailable((long)amountToCheck);
    }

    @Override
    public boolean isFull() {
        return this.storage.isFull();
    }

    @Override
    public String getUnit() {
        return this.storage.getUnit();
    }

    public final HarddriveStorage setPrng(@NonNull ContinuousDistribution prng) {
        if (prng == null) {
            throw new NullPointerException("prng is marked non-null but is null");
        }
        this.prng = prng;
        return this;
    }

    public final SimpleStorage getStorage() {
        return this.storage;
    }

    public final String getName() {
        return this.name;
    }

    @Override
    public final double getMaxTransferRate() {
        return this.maxTransferRate;
    }

    @Override
    public final double getLatency() {
        return this.latency;
    }

    public final double getAvgSeekTime() {
        return this.avgSeekTime;
    }
}

