/*
 * Decompiled with CFR 0.152.
 */
package org.cloudsimplus.resources;

import org.cloudsimplus.resources.ResourceManageableAbstract;
import org.cloudsimplus.util.MathUtil;
import org.cloudsimplus.vms.Vm;

public final class Processor
extends ResourceManageableAbstract {
    public static final Processor NULL = new Processor(Vm.NULL, 0L);
    private final Vm vm;
    private double mips;

    public Processor(Vm vm, long pesNumber, double pesMips) {
        this(vm, pesNumber);
        this.setMips(pesMips);
    }

    private Processor(Vm vm, long pesNumber) {
        super(pesNumber, "Unit");
        this.vm = vm;
    }

    public double getTotalMips() {
        return this.getMips() * (double)this.getCapacity();
    }

    public void setMips(double newMips) {
        this.mips = MathUtil.nonNegative(newMips, "MIPS");
    }

    @Override
    public long getCapacity() {
        return super.getCapacity();
    }

    @Override
    public boolean setCapacity(long pesNumber) {
        if (pesNumber <= 0L) {
            throw new IllegalArgumentException("The Processor's number of PEs must be greater than 0.");
        }
        return super.setCapacity(pesNumber);
    }

    @Override
    public long getAvailableResource() {
        return super.getAvailableResource();
    }

    @Override
    public long getAllocatedResource() {
        return super.getAllocatedResource();
    }

    public final Vm getVm() {
        return this.vm;
    }

    public final double getMips() {
        return this.mips;
    }
}

