/*
 * Decompiled with CFR 0.152.
 */
package org.cloudsimplus.resources;

import org.cloudsimplus.resources.ResourceAbstract;
import org.cloudsimplus.resources.ResourceManageable;
import org.cloudsimplus.util.MathUtil;

public abstract class ResourceManageableAbstract
extends ResourceAbstract
implements ResourceManageable {
    private long availableResource;

    public ResourceManageableAbstract(long capacity, String unit) {
        super(capacity, unit);
        this.availableResource = capacity;
    }

    @Override
    public boolean setCapacity(long newCapacity) {
        if (newCapacity < 0L || this.getAllocatedResource() > newCapacity) {
            return false;
        }
        long oldCapacity = this.capacity;
        this.capacity = newCapacity;
        this.sumAvailableResource(newCapacity - oldCapacity);
        return true;
    }

    @Override
    public boolean sumCapacity(long amountToSum) {
        if (amountToSum < 0L) {
            return this.removeCapacity(-1L * amountToSum);
        }
        return this.addCapacity(amountToSum);
    }

    @Override
    public boolean addCapacity(long capacityToAdd) {
        MathUtil.nonNegative(capacityToAdd, "Number of PEs to add");
        return this.setCapacity(this.getCapacity() + capacityToAdd);
    }

    @Override
    public boolean removeCapacity(long capacityToRemove) {
        MathUtil.nonNegative(capacityToRemove, "Number of PEs to remove");
        if (capacityToRemove > this.getCapacity()) {
            throw new IllegalStateException("The number of PEs to remove cannot be higher than the number of existing PEs. Requested to remove: " + capacityToRemove + " PEs. Existing: " + this.getCapacity() + " PEs.");
        }
        return this.setCapacity(this.getCapacity() - capacityToRemove);
    }

    protected boolean sumAvailableResource(long amountToSum) {
        long newTotalAvailableResource = this.getAvailableResource() + amountToSum;
        return this.setAvailableResource(newTotalAvailableResource);
    }

    protected final boolean setAvailableResource(long newAvailableResource) {
        if (newAvailableResource < 0L || newAvailableResource > this.getCapacity()) {
            return false;
        }
        this.availableResource = newAvailableResource;
        return true;
    }

    @Override
    public long getAvailableResource() {
        return this.availableResource;
    }

    @Override
    public boolean allocateResource(long amountToAllocate) {
        if (amountToAllocate <= 0L || !this.isAmountAvailable(amountToAllocate)) {
            return false;
        }
        long newAvailableResource = this.getAvailableResource() - amountToAllocate;
        return this.setAvailableResource(newAvailableResource);
    }

    @Override
    public boolean setAllocatedResource(long newTotalAllocatedResource) {
        if (newTotalAllocatedResource < 0L || !this.isSuitable(newTotalAllocatedResource)) {
            return false;
        }
        this.deallocateAllResources();
        return this.allocateResource(newTotalAllocatedResource);
    }

    @Override
    public boolean deallocateAndRemoveResource(long amountToDeallocate) {
        if (!this.deallocateResource(this.getActualAmountToDeallocate(amountToDeallocate))) {
            return false;
        }
        return this.removeCapacity(amountToDeallocate);
    }

    private long getActualAmountToDeallocate(long amountToDeallocate) {
        return Math.min(amountToDeallocate, this.getAllocatedResource());
    }

    @Override
    public boolean deallocateResource(long amountToDeallocate) {
        if (amountToDeallocate <= 0L || !this.isResourceAmountBeingUsed(amountToDeallocate)) {
            return false;
        }
        long newAvailableResource = this.getAvailableResource() + amountToDeallocate;
        return this.setAvailableResource(newAvailableResource);
    }

    @Override
    public long deallocateAllResources() {
        long previousAllocated = this.getAllocatedResource();
        this.setAvailableResource(this.getCapacity());
        return previousAllocated;
    }

    public String toString() {
        return "%s: used %d of %d".formatted(this.getClass().getSimpleName(), this.getAllocatedResource(), this.getCapacity());
    }
}

