/*
 * Decompiled with CFR 0.152.
 */
package org.cloudsimplus.schedulers.vm;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.NonNull;
import org.cloudsimplus.hosts.Host;
import org.cloudsimplus.hosts.HostSimple;
import org.cloudsimplus.resources.Pe;
import org.cloudsimplus.schedulers.MipsShare;
import org.cloudsimplus.schedulers.vm.VmScheduler;
import org.cloudsimplus.vms.Vm;
import org.cloudsimplus.vms.VmSimple;

public abstract class VmSchedulerAbstract
implements VmScheduler {
    private Host host;
    private final double vmMigrationCpuOverhead;

    public VmSchedulerAbstract(double vmMigrationCpuOverhead) {
        if (vmMigrationCpuOverhead < 0.0 || vmMigrationCpuOverhead >= 1.0) {
            throw new IllegalArgumentException("vmMigrationCpuOverhead must be a percentage value between [0 and 1[");
        }
        this.setHost(Host.NULL);
        this.vmMigrationCpuOverhead = vmMigrationCpuOverhead;
    }

    @Override
    public final boolean isSuitableForVm(Vm vm) {
        return this.isSuitableForVm(vm, vm.getCurrentRequestedMips());
    }

    @Override
    public final boolean isSuitableForVm(@NonNull Vm vm, @NonNull MipsShare requestedMips) {
        if (vm == null) {
            throw new NullPointerException("vm is marked non-null but is null");
        }
        if (requestedMips == null) {
            throw new NullPointerException("requestedMips is marked non-null but is null");
        }
        if (requestedMips.isEmpty()) {
            LOGGER.warn("{}: {}: It was requested an empty list of PEs for {} in {}", new Object[]{this.host.getSimulation().clockStr(), this.getClass().getSimpleName(), vm, this.host});
            return false;
        }
        if (this.host.isFailed()) {
            return false;
        }
        return this.isSuitableForVmInternal(vm, requestedMips);
    }

    protected abstract boolean isSuitableForVmInternal(Vm var1, MipsShare var2);

    @Override
    public final boolean allocatePesForVm(Vm vm) {
        return this.allocatePesForVm(vm, new MipsShare(vm.getProcessor()));
    }

    @Override
    public final boolean allocatePesForVm(@NonNull Vm vm, @NonNull MipsShare requestedMips) {
        if (vm == null) {
            throw new NullPointerException("vm is marked non-null but is null");
        }
        if (requestedMips == null) {
            throw new NullPointerException("requestedMips is marked non-null but is null");
        }
        if (!vm.isInMigration() && this.host.getVmsMigratingOut().contains(vm)) {
            this.host.removeVmMigratingOut(vm);
        }
        ((VmSimple)vm).setRequestedMips(new MipsShare(requestedMips));
        if (this.allocatePesForVmInternal(vm, requestedMips)) {
            this.updateHostPesStatusToBusy(vm);
            return true;
        }
        return false;
    }

    private void updateHostPesStatusToBusy(Vm vm) {
        this.updateHostPesStatus(this.host.getFreePeList(), vm.getPesNumber(), Pe.Status.BUSY);
    }

    private void updateHostPesStatus(List<Pe> peList, long vPesNumber, Pe.Status newStatus) {
        if (vPesNumber <= 0L) {
            return;
        }
        List<Pe> selectedPesList = peList.stream().limit(vPesNumber).collect(Collectors.toList());
        ((HostSimple)this.host).setPeStatus(selectedPesList, newStatus);
    }

    protected abstract boolean allocatePesForVmInternal(Vm var1, MipsShare var2);

    @Override
    public void deallocatePesFromVm(Vm vm) {
        this.deallocatePesFromVm(vm, (int)vm.getPesNumber());
    }

    @Override
    public void deallocatePesFromVm(Vm vm, int pesToRemove) {
        if (pesToRemove <= 0 || vm.getPesNumber() == 0L) {
            return;
        }
        long removedPes = this.deallocatePesFromVmInternal(vm, pesToRemove);
        this.updateHostUsedPesToFree(removedPes);
    }

    private void updateHostUsedPesToFree(long removedPes) {
        this.updateHostPesStatus(this.host.getBusyPeList(), removedPes, Pe.Status.FREE);
    }

    protected final long removePesFromVm(Vm vm, MipsShare mipsShare, long pesToRemove) {
        return mipsShare.remove(Math.min(vm.getPesNumber(), pesToRemove));
    }

    protected abstract long deallocatePesFromVmInternal(Vm var1, int var2);

    @Override
    public MipsShare getAllocatedMips(@NonNull Vm vm) {
        if (vm == null) {
            throw new NullPointerException("vm is marked non-null but is null");
        }
        MipsShare mipsShare = ((VmSimple)vm).getAllocatedMips();
        return this.host.getVmsMigratingOut().contains(vm) ? this.getMipsShareRequestedReduced(vm, mipsShare) : mipsShare;
    }

    protected MipsShare getMipsShareRequestedReduced(Vm vm, MipsShare mipsShareRequested) {
        double peMips = this.getPeCapacity();
        long requestedPes = mipsShareRequested.pes();
        double requestedMips = mipsShareRequested.mips();
        return new MipsShare(requestedPes, Math.min(requestedMips, peMips) * this.mipsPercentToRequest(vm));
    }

    @Override
    public double getTotalAllocatedMipsForVm(Vm vm) {
        return this.getAllocatedMips(vm).totalMips();
    }

    public long getPeCapacity() {
        return this.getWorkingPeList().isEmpty() ? 0L : this.getWorkingPeList().get(0).getCapacity();
    }

    public final List<Pe> getWorkingPeList() {
        return this.host.getWorkingPeList();
    }

    @Override
    public MipsShare getRequestedMips(Vm vm) {
        return ((VmSimple)vm).getRequestedMips();
    }

    @Override
    public double getTotalAvailableMips() {
        Stream vmStream = Stream.concat(this.host.getVmList().stream(), this.host.getVmsMigratingIn().stream());
        double allocatedMips = vmStream.map(vm -> (VmSimple)vm).mapToDouble(this::actualVmTotalRequestedMips).sum();
        return this.host.getTotalMipsCapacity() - allocatedMips;
    }

    private double actualVmTotalRequestedMips(VmSimple vm) {
        double totalVmRequestedMips = vm.getAllocatedMips().totalMips();
        return totalVmRequestedMips / this.mipsPercentToRequest(vm);
    }

    protected double mipsPercentToRequest(Vm vm) {
        if (this.host.getVmsMigratingIn().contains(vm)) {
            return this.vmMigrationCpuOverhead;
        }
        if (this.host.getVmsMigratingOut().contains(vm)) {
            return this.getMaxCpuUsagePercentDuringOutMigration();
        }
        return 1.0;
    }

    @Override
    public double getMaxCpuUsagePercentDuringOutMigration() {
        return 1.0 - this.vmMigrationCpuOverhead;
    }

    @Override
    public final VmScheduler setHost(@NonNull Host host) {
        if (host == null) {
            throw new NullPointerException("host is marked non-null but is null");
        }
        if (this.isOtherHostAssigned(host)) {
            throw new IllegalStateException("VmScheduler already has a Host assigned to it. Each Host must have its own VmScheduler instance.");
        }
        this.host = host;
        return this;
    }

    private boolean isOtherHostAssigned(@NonNull Host host) {
        if (host == null) {
            throw new NullPointerException("host is marked non-null but is null");
        }
        return this.host != null && this.host != Host.NULL && host != this.host;
    }

    @Override
    public final Host getHost() {
        return this.host;
    }

    @Override
    public final double getVmMigrationCpuOverhead() {
        return this.vmMigrationCpuOverhead;
    }
}

