/*
 * Decompiled with CFR 0.152.
 */
package org.cloudsimplus.schedulers.vm;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.cloudsimplus.resources.Pe;
import org.cloudsimplus.schedulers.MipsShare;
import org.cloudsimplus.schedulers.vm.VmSchedulerAbstract;
import org.cloudsimplus.vms.Vm;
import org.cloudsimplus.vms.VmSimple;

public class VmSchedulerSpaceShared
extends VmSchedulerAbstract {
    public VmSchedulerSpaceShared() {
        this(0.1);
    }

    public VmSchedulerSpaceShared(double vmMigrationCpuOverhead) {
        super(vmMigrationCpuOverhead);
    }

    @Override
    protected boolean isSuitableForVmInternal(Vm vm, MipsShare requestedMips) {
        List<Pe> selectedPesList = this.getTotalCapacityToBeAllocatedToVm(requestedMips);
        return (long)selectedPesList.size() >= requestedMips.pes();
    }

    private List<Pe> getTotalCapacityToBeAllocatedToVm(MipsShare requestedMips) {
        if ((long)this.getHost().getWorkingPesNumber() < requestedMips.pes()) {
            return this.getHost().getWorkingPeList();
        }
        List<Pe> freePeList = this.getHost().getFreePeList();
        ArrayList<Pe> selectedPesList = new ArrayList<Pe>();
        if (freePeList.isEmpty()) {
            return selectedPesList;
        }
        Iterator<Pe> peIterator = freePeList.iterator();
        Pe pe = peIterator.next();
        int i = 0;
        while ((long)i < requestedMips.pes()) {
            if (requestedMips.mips() <= (double)pe.getCapacity()) {
                selectedPesList.add(pe);
                if (!peIterator.hasNext()) break;
                pe = peIterator.next();
            }
            ++i;
        }
        return selectedPesList;
    }

    @Override
    public boolean allocatePesForVmInternal(Vm vm, MipsShare requestedMips) {
        List<Pe> selectedPesList = this.getTotalCapacityToBeAllocatedToVm(requestedMips);
        if ((long)selectedPesList.size() < requestedMips.pes()) {
            return false;
        }
        ((VmSimple)vm).setAllocatedMips(requestedMips);
        return true;
    }

    @Override
    protected long deallocatePesFromVmInternal(Vm vm, int pesToRemove) {
        return this.removePesFromVm(vm, ((VmSimple)vm).getAllocatedMips(), pesToRemove);
    }
}

