/*
 * Decompiled with CFR 0.152.
 */
package org.cloudsimplus.schedulers.vm;

import java.util.Iterator;
import org.cloudsimplus.resources.Pe;
import org.cloudsimplus.schedulers.MipsShare;
import org.cloudsimplus.schedulers.vm.VmSchedulerAbstract;
import org.cloudsimplus.vms.Vm;
import org.cloudsimplus.vms.VmSimple;

public class VmSchedulerTimeShared
extends VmSchedulerAbstract {
    public VmSchedulerTimeShared() {
        this(0.1);
    }

    public VmSchedulerTimeShared(double vmMigrationCpuOverhead) {
        super(vmMigrationCpuOverhead);
    }

    @Override
    public boolean allocatePesForVmInternal(Vm vm, MipsShare requestedMips) {
        return this.allocateMipsShareForVmInternal(vm, requestedMips);
    }

    private boolean allocateMipsShareForVmInternal(Vm vm, MipsShare requestedMips) {
        if (!this.isSuitableForVm(vm, requestedMips)) {
            return false;
        }
        this.allocateMipsShareForVm(vm, requestedMips);
        return true;
    }

    protected void allocateMipsShareForVm(Vm vm, MipsShare requestedMipsReduced) {
        MipsShare mipsShare = this.getMipsShareToAllocate(vm, requestedMipsReduced);
        ((VmSimple)vm).setAllocatedMips(mipsShare);
    }

    private void allocatePesListForVm(Vm vm, MipsShare mipsShare) {
        Iterator<Pe> hostPesIterator = this.getWorkingPeList().iterator();
        int i = 0;
        while ((long)i < mipsShare.pes()) {
            double allocatedPeMips = this.allocateMipsFromHostPesToGivenVirtualPe(vm, mipsShare.mips(), hostPesIterator);
            if (mipsShare.mips() > 0.1 && allocatedPeMips <= 0.1) {
                this.logMipsUnavailable(vm, mipsShare.mips(), allocatedPeMips);
            }
            ++i;
        }
    }

    private void logMipsUnavailable(Vm vm, double requestedMipsForVmPe, double allocatedMipsForVmPe) {
        String msg = allocatedMipsForVmPe > 0.0 ? "Only %.0f MIPS were allocated.".formatted(allocatedMipsForVmPe) : "No MIPS were allocated.";
        LOGGER.warn("{}: {}: {} is requiring a total of {} MIPS but the PEs of {} currently don't have such an available MIPS amount. {}", new Object[]{this.getHost().getSimulation().clockStr(), this.getClass().getSimpleName(), vm, (long)requestedMipsForVmPe, this.getHost(), msg});
    }

    private double allocateMipsFromHostPesToGivenVirtualPe(Vm vm, double requestedMipsForVmPe, Iterator<Pe> hostPesIterator) {
        if (requestedMipsForVmPe <= 0.0) {
            return 0.0;
        }
        double allocatedMipsForVmPe = 0.0;
        while (allocatedMipsForVmPe <= 0.0 && hostPesIterator.hasNext()) {
            Pe selectedHostPe = hostPesIterator.next();
            if (this.allocateAllVmPeRequestedMipsFromHostPe(vm, selectedHostPe, requestedMipsForVmPe)) {
                allocatedMipsForVmPe = requestedMipsForVmPe;
                continue;
            }
            allocatedMipsForVmPe += this.allocatedMipsFromHostPeToVirtualPe(vm, selectedHostPe);
        }
        return allocatedMipsForVmPe;
    }

    private double allocatedMipsFromHostPeToVirtualPe(Vm vm, Pe hostPe) {
        double availableMips = this.getAvailableMipsFromHostPe(hostPe);
        if (availableMips <= 0.0) {
            return 0.0;
        }
        this.allocateMipsFromHostPeForVm(vm, hostPe, availableMips);
        return availableMips;
    }

    private boolean allocateAllVmPeRequestedMipsFromHostPe(Vm vm, Pe hostPe, double requestedMipsForVmPe) {
        if ((double)this.getAvailableMipsFromHostPe(hostPe) >= requestedMipsForVmPe) {
            this.allocateMipsFromHostPeForVm(vm, hostPe, requestedMipsForVmPe);
            return true;
        }
        return false;
    }

    private long getAvailableMipsFromHostPe(Pe hostPe) {
        return hostPe.getPeProvisioner().getAvailableResource();
    }

    @Override
    protected boolean isSuitableForVmInternal(Vm vm, MipsShare requestedMips) {
        double totalRequestedMips = requestedMips.totalMips();
        return (long)this.getHost().getWorkingPesNumber() >= requestedMips.pes() && this.getTotalAvailableMips() >= totalRequestedMips;
    }

    private void allocateMipsFromHostPeForVm(Vm vm, Pe pe, double mipsToAllocate) {
        pe.getPeProvisioner().allocateResourceForVm(vm, (long)mipsToAllocate);
    }

    protected MipsShare getMipsShareToAllocate(Vm vm, MipsShare requestedMips) {
        return this.getMipsShareToAllocate(requestedMips, this.mipsPercentToRequest(vm));
    }

    protected MipsShare getMipsShareToAllocate(MipsShare requestedMips, double scalingFactor) {
        if (scalingFactor == 1.0) {
            return requestedMips;
        }
        return new MipsShare(requestedMips.pes(), requestedMips.mips() * scalingFactor);
    }

    @Override
    protected long deallocatePesFromVmInternal(Vm vm, int pesToRemove) {
        return Math.max(this.removePesFromVm(vm, ((VmSimple)vm).getRequestedMips(), pesToRemove), this.removePesFromVm(vm, ((VmSimple)vm).getAllocatedMips(), pesToRemove));
    }
}

