/*
 * Decompiled with CFR 0.152.
 */
package org.cloudsimplus.selectionpolicies;

import java.util.List;
import java.util.Optional;
import lombok.NonNull;
import org.cloudsimplus.distributions.ContinuousDistribution;
import org.cloudsimplus.distributions.UniformDistr;
import org.cloudsimplus.hosts.Host;
import org.cloudsimplus.selectionpolicies.VmSelectionPolicy;
import org.cloudsimplus.vms.Vm;

public class VmSelectionPolicyRandomSelection
implements VmSelectionPolicy {
    private final ContinuousDistribution rand;

    public VmSelectionPolicyRandomSelection() {
        this(new UniformDistr());
    }

    public VmSelectionPolicyRandomSelection(@NonNull ContinuousDistribution rand) {
        if (rand == null) {
            throw new NullPointerException("rand is marked non-null but is null");
        }
        this.rand = rand;
    }

    @Override
    public Optional<Vm> getVmToMigrate(Host host) {
        List<Vm> migratableVmList = host.getMigratableVms();
        if (migratableVmList.isEmpty()) {
            return Optional.empty();
        }
        int index = (int)(this.rand.sample() * (double)migratableVmList.size());
        return Optional.of(migratableVmList.get(index));
    }
}

