/*
 * Decompiled with CFR 0.152.
 */
package org.cloudsimplus.testbeds;

import java.util.Optional;
import lombok.NonNull;
import org.apache.commons.math3.distribution.TDistribution;
import org.apache.commons.math3.exception.MathIllegalArgumentException;
import org.apache.commons.math3.stat.descriptive.SummaryStatistics;

public final class ConfidenceInterval {
    public static final double CONFIDENCE_LEVEL = 0.95;
    private final String metricName;
    private final double value;
    private final double stdDev;
    private final long samples;
    private final double criticalValue;
    private final double errorMargin;
    private final double lowerLimit;
    private final double upperLimit;

    public ConfidenceInterval(SummaryStatistics stats, @NonNull String metricName) {
        if (metricName == null) {
            throw new NullPointerException("metricName is marked non-null but is null");
        }
        this.metricName = metricName;
        Optional<Double> optionalErrorMargin = ConfidenceInterval.errorMargin(stats);
        this.stdDev = stats.getStandardDeviation();
        this.samples = stats.getN();
        this.value = stats.getMean();
        if (optionalErrorMargin.isPresent()) {
            this.criticalValue = ConfidenceInterval.computeCriticalValue(this.samples);
            this.errorMargin = optionalErrorMargin.get();
            this.lowerLimit = stats.getMean() - this.errorMargin;
            this.upperLimit = stats.getMean() + this.errorMargin;
            return;
        }
        this.criticalValue = 0.0;
        this.errorMargin = 0.0;
        this.lowerLimit = 0.0;
        this.upperLimit = 0.0;
    }

    public static Optional<Double> errorMargin(@NonNull SummaryStatistics stats) {
        if (stats == null) {
            throw new NullPointerException("stats is marked non-null but is null");
        }
        long samples = stats.getN();
        if (samples <= 1L) {
            return Optional.empty();
        }
        try {
            double criticalValue = ConfidenceInterval.computeCriticalValue(samples);
            return Optional.of(criticalValue * stats.getStandardDeviation() / Math.sqrt(samples));
        }
        catch (MathIllegalArgumentException e) {
            return Optional.empty();
        }
    }

    private static double computeCriticalValue(long samples) {
        double freedomDegrees = samples - 1L;
        TDistribution tDist = new TDistribution(freedomDegrees);
        double significance = 0.050000000000000044;
        return tDist.inverseCumulativeProbability(0.975);
    }

    public boolean isComputed() {
        return this.samples > 1L;
    }

    public final String getMetricName() {
        return this.metricName;
    }

    public final double getValue() {
        return this.value;
    }

    public final double getStdDev() {
        return this.stdDev;
    }

    public final long getSamples() {
        return this.samples;
    }

    public final double getCriticalValue() {
        return this.criticalValue;
    }

    public final double getErrorMargin() {
        return this.errorMargin;
    }

    public final double getLowerLimit() {
        return this.lowerLimit;
    }

    public final double getUpperLimit() {
        return this.upperLimit;
    }
}

