/*
 * Decompiled with CFR 0.152.
 */
package org.cloudsimplus.testbeds;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import lombok.NonNull;
import org.cloudsimplus.allocationpolicies.VmAllocationPolicy;
import org.cloudsimplus.allocationpolicies.VmAllocationPolicySimple;
import org.cloudsimplus.brokers.DatacenterBroker;
import org.cloudsimplus.cloudlets.Cloudlet;
import org.cloudsimplus.core.CloudSimPlus;
import org.cloudsimplus.datacenters.Datacenter;
import org.cloudsimplus.datacenters.DatacenterSimple;
import org.cloudsimplus.hosts.Host;
import org.cloudsimplus.testbeds.AbstractRunnable;
import org.cloudsimplus.testbeds.ExperimentRunner;
import org.cloudsimplus.vms.Vm;

public abstract class Experiment<T extends Experiment<T>>
extends AbstractRunnable {
    private final ExperimentRunner<?> runner;
    protected int hostsNumber;
    private int datacentersNumber;
    private int brokersNumber;
    private final CloudSimPlus simulation;
    private final List<Datacenter> datacenterList;
    private final List<DatacenterBroker> brokerList;
    private final List<Vm> vmList;
    private final List<Cloudlet> cloudletList;
    private final long seed;
    private final int index;
    private int lastVmId;
    private int lastCloudletId;
    @NonNull
    private Consumer<T> beforeExperimentRun;
    @NonNull
    private Consumer<T> afterExperimentFinish;
    @NonNull
    private Consumer<? extends Experiment> beforeExperimentBuild;
    @NonNull
    private Consumer<? extends Experiment> afterExperimentBuild;
    @NonNull
    private Function<DatacenterBroker, Integer> vmsByBrokerFunction;
    private Supplier<VmAllocationPolicy> vmAllocationPolicySupplier;

    public Experiment(long seed) {
        this(0, null, seed);
    }

    public Experiment(int index, ExperimentRunner<?> runner) {
        this(index, runner, -1L);
    }

    protected Experiment(int index, ExperimentRunner<?> runner, long seed) {
        if (seed == -1L) {
            Objects.requireNonNull(runner);
        }
        this.brokersNumber = 1;
        this.datacentersNumber = 1;
        this.simulation = new CloudSimPlus();
        this.vmList = new ArrayList<Vm>();
        this.index = index;
        this.datacenterList = new ArrayList<Datacenter>();
        this.brokerList = new ArrayList<DatacenterBroker>();
        this.cloudletList = new ArrayList<Cloudlet>();
        this.runner = runner;
        this.afterExperimentFinish = exp -> {};
        this.beforeExperimentBuild = exp -> {};
        this.afterExperimentBuild = exp -> {};
        this.beforeExperimentRun = exp -> {};
        this.seed = this.validateSeed(seed);
    }

    @Override
    public final void run() {
        Objects.requireNonNull(this.vmsByBrokerFunction, "You need to set the function that indicates the number of VMs to create for each broker.");
        this.build();
        this.beforeExperimentRun(this);
        this.simulation.start();
        this.afterExperimentFinish(this);
        this.printResultsInternal();
        if (this.runner != null) {
            this.runner.printProgress(this.runner.incFinishedRuns());
        }
    }

    public boolean isFirstExperimentCreated() {
        return this.index == this.runner.getFirstExperimentCreated();
    }

    public abstract void printResults();

    protected final void build() {
        this.beforeExperimentBuild(this);
        this.createDatacenters();
        this.createBrokers();
        this.brokerList.stream().sorted().forEach(b -> {
            this.createAndSubmitVmsInternal((DatacenterBroker)b);
            this.createAndSubmitCloudletsInternal((DatacenterBroker)b);
        });
        this.afterExperimentBuild(this);
    }

    protected void createBrokers() {
        if (this.brokersNumber <= 0) {
            throw new IllegalStateException("The number of brokers to create was not set");
        }
        for (int i = 0; i < this.brokersNumber; ++i) {
            this.createBrokerAndAddToList();
        }
    }

    protected abstract DatacenterBroker createBroker();

    private DatacenterBroker createBrokerAndAddToList() {
        DatacenterBroker broker = this.createBroker();
        this.brokerList.add(broker);
        return broker;
    }

    private void createDatacenters() {
        if (this.datacentersNumber <= 0) {
            throw new IllegalStateException("The number of Datacenters to create was not set");
        }
        for (int i = 0; i < this.datacentersNumber; ++i) {
            this.datacenterList.add(this.createDatacenter(i));
        }
    }

    protected Datacenter createDatacenter(int index) {
        return new DatacenterSimple(this.simulation, this.createHosts(), this.newVmAllocationPolicy());
    }

    private long validateSeed(long seed) {
        if (this.runner == null) {
            return seed;
        }
        if (this.runner.isToReuseSeedFromFirstHalfOfExperiments(this.index)) {
            int previousExperiment = this.index - this.runner.halfSimulationRuns();
            seed = this.runner.getSeed(previousExperiment);
        } else {
            seed = this.runner.getBaseSeed() + (long)this.index;
        }
        this.runner.addSeed(seed);
        return seed;
    }

    private void printResultsInternal() {
        if (this.runner == null || this.runner.isVerbose()) {
            this.printResults();
        }
    }

    protected abstract List<Cloudlet> createCloudlets(DatacenterBroker var1);

    protected abstract Cloudlet createCloudlet(DatacenterBroker var1);

    protected List<Vm> createVms(DatacenterBroker broker) {
        int numVms = this.vmsByBrokerFunction.apply(broker);
        ArrayList<Vm> newList = new ArrayList<Vm>(numVms);
        for (int id = this.vmList.size(); id < this.vmList.size() + numVms; ++id) {
            Vm vm = this.createVm(broker, this.nextVmId());
            newList.add(vm);
        }
        return newList;
    }

    protected abstract Vm createVm(DatacenterBroker var1, int var2);

    protected final int nextVmId() {
        return ++this.lastVmId;
    }

    protected final int nextCloudletId() {
        return ++this.lastCloudletId;
    }

    protected void createAndSubmitCloudletsInternal(DatacenterBroker broker) {
        List<Cloudlet> newCloudletList = this.createCloudlets(broker);
        this.cloudletList.addAll(newCloudletList);
        broker.submitCloudletList(newCloudletList);
    }

    private void createAndSubmitVmsInternal(DatacenterBroker broker) {
        List<Vm> newVmList = this.createVms(broker);
        this.vmList.addAll(newVmList);
        broker.submitVmList(newVmList);
    }

    protected final List<Host> createHosts() {
        if (this.hostsNumber <= 0) {
            throw new IllegalStateException("The number of hosts to create was not set");
        }
        ArrayList<Host> hostList = new ArrayList<Host>(this.hostsNumber);
        for (int i = 0; i < this.hostsNumber; ++i) {
            hostList.add(this.createHost(i));
        }
        return hostList;
    }

    protected abstract Host createHost(int var1);

    private <T extends Experiment> void beforeExperimentBuild(T experiment) {
        this.beforeExperimentBuild.accept(experiment);
    }

    private <T extends Experiment> void afterExperimentBuild(T experiment) {
        this.afterExperimentBuild.accept(experiment);
    }

    private <T extends Experiment> void beforeExperimentRun(T experiment) {
        this.beforeExperimentRun.accept(experiment);
    }

    private <T extends Experiment> void afterExperimentFinish(T experiment) {
        this.afterExperimentFinish.accept(experiment);
    }

    public Experiment setBrokersNumber(int brokersNumber) {
        if (brokersNumber <= 0) {
            throw new IllegalArgumentException("The number of brokers must be greater than 0");
        }
        this.brokersNumber = brokersNumber;
        return this;
    }

    protected final void setHostsNumber(int hostsNumber) {
        if (hostsNumber <= 0) {
            throw new IllegalArgumentException("Number of hosts must be greater than zero.");
        }
        this.hostsNumber = hostsNumber;
    }

    protected final VmAllocationPolicy newVmAllocationPolicy() {
        return this.vmAllocationPolicySupplier == null ? new VmAllocationPolicySimple() : this.vmAllocationPolicySupplier.get();
    }

    public String toString() {
        return "Experiment %d".formatted(this.index);
    }

    public final ExperimentRunner<?> getRunner() {
        return this.runner;
    }

    public final int getDatacentersNumber() {
        return this.datacentersNumber;
    }

    public final Experiment<T> setDatacentersNumber(int datacentersNumber) {
        this.datacentersNumber = datacentersNumber;
        return this;
    }

    public final int getBrokersNumber() {
        return this.brokersNumber;
    }

    public final CloudSimPlus getSimulation() {
        return this.simulation;
    }

    public final List<Datacenter> getDatacenterList() {
        return this.datacenterList;
    }

    public final List<DatacenterBroker> getBrokerList() {
        return this.brokerList;
    }

    public final List<Vm> getVmList() {
        return this.vmList;
    }

    public final List<Cloudlet> getCloudletList() {
        return this.cloudletList;
    }

    public final long getSeed() {
        return this.seed;
    }

    public final int getIndex() {
        return this.index;
    }

    public final Experiment<T> setBeforeExperimentRun(@NonNull Consumer<T> beforeExperimentRun) {
        if (beforeExperimentRun == null) {
            throw new NullPointerException("beforeExperimentRun is marked non-null but is null");
        }
        this.beforeExperimentRun = beforeExperimentRun;
        return this;
    }

    public final Experiment<T> setAfterExperimentFinish(@NonNull Consumer<T> afterExperimentFinish) {
        if (afterExperimentFinish == null) {
            throw new NullPointerException("afterExperimentFinish is marked non-null but is null");
        }
        this.afterExperimentFinish = afterExperimentFinish;
        return this;
    }

    public final Experiment<T> setBeforeExperimentBuild(@NonNull Consumer<? extends Experiment> beforeExperimentBuild) {
        if (beforeExperimentBuild == null) {
            throw new NullPointerException("beforeExperimentBuild is marked non-null but is null");
        }
        this.beforeExperimentBuild = beforeExperimentBuild;
        return this;
    }

    public final Experiment<T> setAfterExperimentBuild(@NonNull Consumer<? extends Experiment> afterExperimentBuild) {
        if (afterExperimentBuild == null) {
            throw new NullPointerException("afterExperimentBuild is marked non-null but is null");
        }
        this.afterExperimentBuild = afterExperimentBuild;
        return this;
    }

    @NonNull
    public final Function<DatacenterBroker, Integer> getVmsByBrokerFunction() {
        return this.vmsByBrokerFunction;
    }

    public final Experiment<T> setVmsByBrokerFunction(@NonNull Function<DatacenterBroker, Integer> vmsByBrokerFunction) {
        if (vmsByBrokerFunction == null) {
            throw new NullPointerException("vmsByBrokerFunction is marked non-null but is null");
        }
        this.vmsByBrokerFunction = vmsByBrokerFunction;
        return this;
    }

    public final Experiment<T> setVmAllocationPolicySupplier(Supplier<VmAllocationPolicy> vmAllocationPolicySupplier) {
        this.vmAllocationPolicySupplier = vmAllocationPolicySupplier;
        return this;
    }
}

