/*
 * Decompiled with CFR 0.152.
 */
package org.cloudsimplus.testbeds;

import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.apache.commons.math3.stat.descriptive.SummaryStatistics;
import org.cloudsimplus.distributions.ContinuousDistribution;
import org.cloudsimplus.distributions.StatisticalDistribution;
import org.cloudsimplus.distributions.UniformDistr;
import org.cloudsimplus.testbeds.AbstractRunnable;
import org.cloudsimplus.testbeds.ConfidenceInterval;
import org.cloudsimplus.testbeds.Experiment;
import org.cloudsimplus.testbeds.ResultTable;
import org.cloudsimplus.util.TimeUtil;
import org.cloudsimplus.util.Util;

public abstract class ExperimentRunner<T extends Experiment<T>>
extends AbstractRunnable {
    private final boolean parallel;
    private boolean showProgress;
    private boolean progressBarInNewLine;
    private int firstExperimentCreated = -1;
    private final long baseSeed;
    private final List<Long> seeds;
    private int simulationRuns;
    private final AtomicInteger finishedRuns;
    private long experimentsStartTimeSecs;
    private long experimentsExecutionTimeSecs;
    private final boolean applyAntitheticVariates;
    private final int batchesNumber;
    private final Map<String, List<Double>> metricsMap;
    private String description;
    private String resultsTableId;
    private boolean latexTableResultsGeneration;
    private List<Experiment> experiments;

    protected ExperimentRunner(long baseSeed, int simulationRuns) {
        this(baseSeed, simulationRuns, false);
    }

    protected ExperimentRunner(long baseSeed, int simulationRuns, boolean latexTableResultsGeneration, boolean parallel) {
        this(baseSeed, simulationRuns, 0, false, parallel, latexTableResultsGeneration);
    }

    protected ExperimentRunner(long baseSeed, int simulationRuns, boolean applyAntitheticVariates) {
        this(baseSeed, simulationRuns, 0, applyAntitheticVariates, false, false);
    }

    protected ExperimentRunner(long baseSeed, int simulationRuns, int batchesNumber, boolean applyAntitheticVariates) {
        this(baseSeed, simulationRuns, batchesNumber, applyAntitheticVariates, false, false);
    }

    protected ExperimentRunner(long baseSeed, int simulationRuns, int batchesNumber, boolean applyAntitheticVariates, boolean parallel, boolean latexTableResultsGeneration) {
        this.baseSeed = baseSeed;
        this.applyAntitheticVariates = applyAntitheticVariates;
        this.simulationRuns = this.validateSimulationRuns(simulationRuns);
        this.finishedRuns = new AtomicInteger();
        this.parallel = parallel && simulationRuns > 1;
        this.showProgress = true;
        this.batchesNumber = this.validateBatchesNumber(batchesNumber);
        this.latexTableResultsGeneration = latexTableResultsGeneration;
        this.seeds = parallel ? Collections.synchronizedList(new ArrayList()) : new ArrayList();
        this.metricsMap = parallel ? Collections.synchronizedMap(new TreeMap()) : new TreeMap();
        this.setSimulationRunsAndBatchesToEvenNumber();
        this.setNumberOfSimulationRunsAsMultipleOfNumberOfBatches();
    }

    private int validateBatchesNumber(int batchesNumber) {
        if (batchesNumber < 0 || batchesNumber == 1) {
            throw new IllegalArgumentException("Batches number must be greater than 1. Use 0 just to disable the Batch Means method.");
        }
        return batchesNumber;
    }

    private int validateSimulationRuns(int simulationRuns) {
        if (simulationRuns <= 0) {
            throw new IllegalArgumentException("Simulation runs must be greater than 0.");
        }
        return simulationRuns;
    }

    private void setSimulationRunsAndBatchesToEvenNumber() {
        if (!this.isApplyBatchMeansMethod() && !this.isApplyAntitheticVariates()) {
            return;
        }
        if (this.getSimulationRuns() % 2 != 0) {
            ++this.simulationRuns;
        }
        if (this.getBatchesNumber() > 0 && this.getSimulationRuns() % this.getBatchesNumber() != 0) {
            this.setSimulationRunsAsMultipleOfBatchNumber();
        }
    }

    private void setNumberOfSimulationRunsAsMultipleOfNumberOfBatches() {
        if (this.isApplyBatchMeansAndSimulationRunsIsNotMultipleOfBatches()) {
            this.simulationRuns = this.batchSizeCeil() * this.getBatchesNumber();
        }
    }

    private boolean isApplyBatchMeansAndSimulationRunsIsNotMultipleOfBatches() {
        return this.isApplyBatchMeansMethod() && this.getSimulationRuns() % this.getBatchesNumber() != 0;
    }

    public int batchSizeCeil() {
        return (int)Math.ceil((double)this.simulationRuns / (double)this.batchesNumber);
    }

    public boolean isApplyBatchMeansMethod() {
        boolean batchesGreaterThan1 = this.batchesNumber > 1;
        boolean runsIsGraterThanBatches = this.simulationRuns > this.batchesNumber;
        return batchesGreaterThan1 && runsIsGraterThanBatches;
    }

    protected List<Double> computeBatchMeans(List<Double> samples) {
        if (!this.isApplyBatchMeansMethod()) {
            return samples;
        }
        ArrayList<Double> batchMeans = new ArrayList<Double>(this.getBatchesNumber());
        for (int i = 0; i < this.getBatchesNumber(); ++i) {
            batchMeans.add(this.getBatchAverage(samples, i));
        }
        System.out.printf("\tBatch Means Method applied. The number of samples was reduced to %d after computing the mean for each batch.%n", this.getBatchesNumber());
        return batchMeans;
    }

    private double getBatchAverage(List<Double> samples, int index) {
        int k = this.batchSizeCeil();
        return IntStream.range(0, k).mapToDouble(j -> (Double)samples.get(this.getBatchElementIndex(index, j))).average().orElse(0.0);
    }

    private int getBatchElementIndex(int i, int j) {
        int k = this.batchSizeCeil();
        return i * k + j;
    }

    public boolean isSingleRun() {
        return this.simulationRuns == 1;
    }

    private ExperimentRunner setSimulationRunsAsMultipleOfBatchNumber() {
        double batches = this.getBatchesNumber();
        this.simulationRuns = (int)(batches * Math.ceil((double)this.simulationRuns / batches));
        return this;
    }

    public long getSeed(int experimentIndex) {
        return this.seeds.get(experimentIndex);
    }

    public <S extends StatisticalDistribution> S createRandomGen(int experimentIndex, Function<Long, S> randomGenCreator) {
        Objects.requireNonNull(randomGenCreator, "The Function to instantiate the Random Number Generator cannot be null.");
        if (this.seeds.isEmpty()) {
            throw new IllegalStateException("You have to create at least 1 SimulationExperiment before requesting a ExperimentRunner to create a pseudo random number generator (PRNG)!");
        }
        if (this.isToReuseSeedFromFirstHalfOfExperiments(experimentIndex)) {
            int expIndexFromFirstHalf = experimentIndex - this.halfSimulationRuns();
            StatisticalDistribution prng = (StatisticalDistribution)randomGenCreator.apply(this.getSeed(expIndexFromFirstHalf));
            prng.setApplyAntitheticVariates(true);
            return (S)prng;
        }
        return (S)((StatisticalDistribution)randomGenCreator.apply(this.getSeed(experimentIndex)));
    }

    public ContinuousDistribution createRandomGen(int experimentIndex) {
        return this.createRandomGen(experimentIndex, 0.0, 1.0);
    }

    public ContinuousDistribution createRandomGen(int experimentIndex, double minInclusive, double maxExclusive) {
        return this.createRandomGen(experimentIndex, seed -> new UniformDistr(minInclusive, maxExclusive, (long)seed));
    }

    public boolean isToReuseSeedFromFirstHalfOfExperiments(int currentExperimentIndex) {
        return this.isApplyAntitheticVariates() && this.simulationRuns > 1 && currentExperimentIndex >= this.halfSimulationRuns();
    }

    void addSeed(long seed) {
        if (!this.seeds.contains(seed)) {
            this.seeds.add(seed);
        }
    }

    public int halfSimulationRuns() {
        return this.simulationRuns / 2;
    }

    @Override
    public void run() {
        this.createAllExperimentsBeforeFirstRun();
        String runWord = this.simulationRuns > 1 ? "runs" : "run";
        System.out.printf("Started %s for %d %s using %s (real local time: %s)%n", this.getClass().getSimpleName(), this.simulationRuns, runWord, "CloudSim Plus 8.0.0", LocalTime.now());
        if (this.description != null && !this.description.isBlank()) {
            System.out.println(this.description);
        }
        this.printSimulationParameters();
        this.experimentsStartTimeSecs = Math.round((double)System.currentTimeMillis() / 1000.0);
        this.printProgress(0);
        this.getStream(this.experiments).forEach(Experiment::run);
        System.out.println();
        this.experimentsExecutionTimeSecs = TimeUtil.elapsedSeconds(this.experimentsStartTimeSecs);
        System.out.printf("%nFinal simulation results for %d metrics in %d simulation runs -------------------%n", this.metricsMap.size(), this.simulationRuns);
        if (this.batchesNumber > 1 && !this.isApplyBatchMeansMethod()) {
            System.out.println("Batch means method was not be applied because the number of simulation runs is not greater than the number of batches.");
        }
        this.computeAndPrintFinalResults();
        System.out.printf("%nExperiments for %d runs finished in %s (real local time: %s)!%n", this.simulationRuns, TimeUtil.secondsToStr(this.experimentsExecutionTimeSecs), LocalTime.now());
    }

    private void createAllExperimentsBeforeFirstRun() {
        if (this.experiments == null) {
            this.experiments = IntStream.range(0, this.simulationRuns).mapToObj(this::createExperiment).collect(Collectors.toList());
        }
    }

    private void computeAndPrintFinalResults() {
        List confidenceIntervals = this.metricsMap.entrySet().stream().map(this::computeFinalResults).collect(Collectors.toCollection(() -> new ArrayList(this.metricsMap.size())));
        ResultTable table = new ResultTable(this, confidenceIntervals);
        table.buildLatexMetricsResultTable();
        table.buildCsvResultsTable();
    }

    private Stream<Experiment> getStream(List<Experiment> experiments) {
        return this.parallel ? (Stream)experiments.stream().parallel() : experiments.stream();
    }

    private Experiment createExperiment(int index) {
        this.print((index + 1) % 100 == 0 ? ". Run #%d%n".formatted(index + 1) : ".");
        this.setFirstExperimentCreated(index);
        return this.createExperimentInternal(index);
    }

    protected abstract T createExperimentInternal(int var1);

    protected ConfidenceInterval computeFinalResults(Map.Entry<String, List<Double>> metricEntry) {
        List<Double> metricValues = metricEntry.getValue();
        SummaryStatistics stats = this.computeFinalStatistics(metricValues);
        return new ConfidenceInterval(stats, metricEntry.getKey());
    }

    protected final SummaryStatistics computeFinalStatistics(List<Double> values) {
        SummaryStatistics stats = new SummaryStatistics();
        List<Double> adjustedValues = this.computeAntitheticMeans(this.computeBatchMeans(values));
        adjustedValues.forEach(arg_0 -> ((SummaryStatistics)stats).addValue(arg_0));
        return stats;
    }

    protected final void addMetricValue(String metricName, Double value) {
        List<Double> metricValues = this.getMetricValues(metricName);
        if (value != null) {
            metricValues.add(value);
        }
    }

    protected final List<Double> getMetricValues(String metricName) {
        return this.metricsMap.compute(metricName, (key, values) -> values == null ? new ArrayList(this.simulationRuns) : values);
    }

    protected List<Double> computeAntitheticMeans(List<Double> samples) {
        if (!this.isApplyAntitheticVariates()) {
            return samples;
        }
        int half = samples.size() / 2;
        ArrayList<Double> antitheticMeans = new ArrayList<Double>(half);
        for (int i = 0; i < half; ++i) {
            antitheticMeans.add((samples.get(i) + samples.get(half + i)) / 2.0);
        }
        System.out.printf("\tAntithetic Variates Technique applied. The number of samples was reduced to the half (%d).%n", half);
        return antitheticMeans;
    }

    protected abstract void printSimulationParameters();

    public void setFirstExperimentCreated(int firstExperimentCreated) {
        if (this.firstExperimentCreated < 0) {
            this.firstExperimentCreated = firstExperimentCreated;
        }
    }

    public int getFinishedRuns() {
        return this.finishedRuns.get();
    }

    final int incFinishedRuns() {
        return this.finishedRuns.incrementAndGet();
    }

    final void printProgress(int current) {
        if (this.simulationRuns > 1 && this.showProgress) {
            Util.printProgress(current, this.simulationRuns, this.progressBarInNewLine);
        }
    }

    public final boolean isParallel() {
        return this.parallel;
    }

    public final boolean isShowProgress() {
        return this.showProgress;
    }

    public final boolean isProgressBarInNewLine() {
        return this.progressBarInNewLine;
    }

    public final int getFirstExperimentCreated() {
        return this.firstExperimentCreated;
    }

    public final long getBaseSeed() {
        return this.baseSeed;
    }

    public final List<Long> getSeeds() {
        return this.seeds;
    }

    public final int getSimulationRuns() {
        return this.simulationRuns;
    }

    public final long getExperimentsStartTimeSecs() {
        return this.experimentsStartTimeSecs;
    }

    public final long getExperimentsExecutionTimeSecs() {
        return this.experimentsExecutionTimeSecs;
    }

    public final boolean isApplyAntitheticVariates() {
        return this.applyAntitheticVariates;
    }

    public final int getBatchesNumber() {
        return this.batchesNumber;
    }

    public final Map<String, List<Double>> getMetricsMap() {
        return this.metricsMap;
    }

    public final String getDescription() {
        return this.description;
    }

    public final String getResultsTableId() {
        return this.resultsTableId;
    }

    public final boolean isLatexTableResultsGeneration() {
        return this.latexTableResultsGeneration;
    }

    public final List<Experiment> getExperiments() {
        return this.experiments;
    }

    public final ExperimentRunner<T> setShowProgress(boolean showProgress) {
        this.showProgress = showProgress;
        return this;
    }

    public final ExperimentRunner<T> setProgressBarInNewLine(boolean progressBarInNewLine) {
        this.progressBarInNewLine = progressBarInNewLine;
        return this;
    }

    public final ExperimentRunner<T> setDescription(String description) {
        this.description = description;
        return this;
    }

    public final ExperimentRunner<T> setResultsTableId(String resultsTableId) {
        this.resultsTableId = resultsTableId;
        return this;
    }

    public final ExperimentRunner<T> setLatexTableResultsGeneration(boolean latexTableResultsGeneration) {
        this.latexTableResultsGeneration = latexTableResultsGeneration;
        return this;
    }
}

