/*
 * Decompiled with CFR 0.152.
 */
package org.cloudsimplus.traces.google;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import lombok.NonNull;
import org.cloudsimplus.brokers.DatacenterBroker;
import org.cloudsimplus.brokers.DatacenterBrokerSimple;
import org.cloudsimplus.traces.google.GoogleTaskEventsTraceReader;
import org.cloudsimplus.traces.google.TaskEventField;

public final class BrokerManager {
    private DatacenterBroker defaultBroker;
    private final Map<String, DatacenterBroker> brokersMap;
    private final GoogleTaskEventsTraceReader reader;

    BrokerManager(@NonNull GoogleTaskEventsTraceReader reader) {
        if (reader == null) {
            throw new NullPointerException("reader is marked non-null but is null");
        }
        this.reader = reader;
        this.brokersMap = new HashMap<String, DatacenterBroker>();
    }

    public List<DatacenterBroker> getBrokers() {
        return this.defaultBroker == null ? new ArrayList<DatacenterBroker>(this.brokersMap.values()) : Collections.singletonList(this.defaultBroker);
    }

    public void setDefaultBroker(DatacenterBroker broker) {
        this.defaultBroker = broker;
        this.brokersMap.clear();
    }

    DatacenterBroker getOrCreateBroker(String username) {
        return this.getBroker(() -> this.brokersMap.computeIfAbsent(username, this::createBroker));
    }

    private DatacenterBroker createBroker(String username) {
        return new DatacenterBrokerSimple(this.reader.getSimulation(), "Broker_" + username);
    }

    DatacenterBroker getBroker() {
        String value = (String)TaskEventField.USERNAME.getValue(this.reader);
        return this.getBroker(value);
    }

    DatacenterBroker getBroker(String username) {
        return this.getBroker(() -> this.brokersMap.get(username));
    }

    DatacenterBroker getBroker(Supplier<DatacenterBroker> supplier) {
        return this.defaultBroker == null ? supplier.get() : this.defaultBroker;
    }
}

