/*
 * Decompiled with CFR 0.152.
 */
package org.cloudsimplus.traces.google;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import lombok.NonNull;
import org.cloudsimplus.core.CloudInformationService;
import org.cloudsimplus.core.CloudSimTag;
import org.cloudsimplus.datacenters.Datacenter;
import org.cloudsimplus.hosts.Host;
import org.cloudsimplus.traces.google.GoogleTraceReaderAbstract;
import org.cloudsimplus.traces.google.MachineEvent;
import org.cloudsimplus.traces.google.MachineEventField;
import org.cloudsimplus.traces.google.MachineEventType;
import org.cloudsimplus.util.BytesConversion;
import org.cloudsimplus.util.ResourceLoader;

public final class GoogleMachineEventsTraceReader
extends GoogleTraceReaderAbstract<Host> {
    private long maxRamCapacity;
    private int maxCpuCores;
    @NonNull
    private Datacenter datacenterForLaterHosts;
    private Function<MachineEvent, Host> hostCreationFunction;
    private final List<Host> laterAvailableHosts;
    private final List<Host> hostsForRemoval;

    public static GoogleMachineEventsTraceReader getInstance(String filePath, Function<MachineEvent, Host> hostCreationFunction) {
        InputStream is = ResourceLoader.newInputStream(filePath, GoogleMachineEventsTraceReader.class);
        return new GoogleMachineEventsTraceReader(filePath, is, hostCreationFunction);
    }

    public GoogleMachineEventsTraceReader(String filePath, Function<MachineEvent, Host> hostCreationFunction) throws IOException {
        this(filePath, Files.newInputStream(Paths.get(filePath, new String[0]), new OpenOption[0]), hostCreationFunction);
    }

    private GoogleMachineEventsTraceReader(String filePath, InputStream reader, Function<MachineEvent, Host> hostCreationFunction) {
        super(filePath, reader);
        this.setHostCreationFunction(hostCreationFunction);
        this.setMaxRamCapacity((long)BytesConversion.gigaToMega(16.0));
        this.setMaxCpuCores(8);
        this.laterAvailableHosts = new ArrayList<Host>();
        this.hostsForRemoval = new ArrayList<Host>();
    }

    @Override
    public Collection<Host> process() {
        return super.process();
    }

    @Override
    protected void preProcess() {
        if (this.datacenterForLaterHosts == null) {
            throw new IllegalStateException("The Datacenter where the Hosts with timestamp greater than 0 will be created must be set.");
        }
    }

    @Override
    protected void postProcess() {
        if (this.datacenterForLaterHosts.getSimulation().isRunning()) {
            this.sendLaterHostsAdditionAndRemovalRequests();
        } else {
            this.datacenterForLaterHosts.getSimulation().addOnSimulationStartListener(info -> this.sendLaterHostsAdditionAndRemovalRequests());
        }
    }

    private void sendLaterHostsAdditionAndRemovalRequests() {
        CloudInformationService cis = this.datacenterForLaterHosts.getSimulation().getCis();
        this.laterAvailableHosts.forEach(host -> cis.schedule(this.datacenterForLaterHosts, host.getStartTime(), CloudSimTag.HOST_ADD, host));
        cis.getDatacenterList().forEach(this::sendHostsRemovalRequests);
    }

    private void sendHostsRemovalRequests(Datacenter dc) {
        CloudInformationService cis = dc.getSimulation().getCis();
        this.hostsForRemoval.forEach(host -> cis.schedule(dc, host.getShutdownTime() + (double)dc.getId() * 1.0E-5, CloudSimTag.HOST_REMOVE, host.getId()));
    }

    @Override
    protected boolean processParsedLineInternal() {
        return this.getEventType().process(this);
    }

    public int getNumberOfLaterAvailableHosts() {
        return this.laterAvailableHosts.size();
    }

    public int getNumberOfHostsForRemoval() {
        return this.hostsForRemoval.size();
    }

    private MachineEventType getEventType() {
        return MachineEventType.getValue((Integer)MachineEventField.EVENT_TYPE.getValue(this));
    }

    Host createHostFromTraceLine() {
        MachineEvent event = MachineEvent.builder().cpuCores((Integer)MachineEventField.CPU_CAPACITY.getValue(this)).ram((Long)MachineEventField.RAM_CAPACITY.getValue(this)).timestamp((Double)MachineEventField.TIMESTAMP.getValue(this)).machineId((Long)MachineEventField.MACHINE_ID.getValue(this)).build();
        Host host = this.hostCreationFunction.apply(event);
        host.setId((Long)MachineEventField.MACHINE_ID.getValue(this));
        return host;
    }

    boolean addHostToRemovalList(Host host) {
        return this.hostsForRemoval.add(host);
    }

    boolean addLaterAvailableHost(Host host) {
        return this.laterAvailableHosts.add(host);
    }

    public void setMaxRamCapacity(long maxRamCapacity) {
        if (maxRamCapacity <= 0L) {
            throw new IllegalArgumentException("RAM capacity must be greater than 0.");
        }
        this.maxRamCapacity = maxRamCapacity;
    }

    public void setMaxCpuCores(int maxCpuCores) {
        if (maxCpuCores <= 0) {
            throw new IllegalArgumentException("Number of CPU cores must be greater than 0.");
        }
        this.maxCpuCores = maxCpuCores;
    }

    public final long getMaxRamCapacity() {
        return this.maxRamCapacity;
    }

    public final int getMaxCpuCores() {
        return this.maxCpuCores;
    }

    @NonNull
    public final Datacenter getDatacenterForLaterHosts() {
        return this.datacenterForLaterHosts;
    }

    public final List<Host> getLaterAvailableHosts() {
        return this.laterAvailableHosts;
    }

    public final List<Host> getHostsForRemoval() {
        return this.hostsForRemoval;
    }

    public final GoogleMachineEventsTraceReader setDatacenterForLaterHosts(@NonNull Datacenter datacenterForLaterHosts) {
        if (datacenterForLaterHosts == null) {
            throw new NullPointerException("datacenterForLaterHosts is marked non-null but is null");
        }
        this.datacenterForLaterHosts = datacenterForLaterHosts;
        return this;
    }

    public final GoogleMachineEventsTraceReader setHostCreationFunction(Function<MachineEvent, Host> hostCreationFunction) {
        this.hostCreationFunction = hostCreationFunction;
        return this;
    }
}

