/*
 * Decompiled with CFR 0.152.
 */
package org.cloudsimplus.traces.google;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import lombok.NonNull;
import org.cloudsimplus.brokers.DatacenterBroker;
import org.cloudsimplus.cloudlets.Cloudlet;
import org.cloudsimplus.core.CloudSimPlus;
import org.cloudsimplus.core.CloudSimTag;
import org.cloudsimplus.core.events.CloudSimEvent;
import org.cloudsimplus.core.events.SimEvent;
import org.cloudsimplus.traces.google.BrokerManager;
import org.cloudsimplus.traces.google.GoogleTraceReaderAbstract;
import org.cloudsimplus.traces.google.TaskEvent;
import org.cloudsimplus.traces.google.TaskEventType;
import org.cloudsimplus.util.ResourceLoader;
import org.cloudsimplus.utilizationmodels.UtilizationModelDynamic;

public class GoogleTaskEventsTraceReader
extends GoogleTraceReaderAbstract<Cloudlet> {
    protected final Map<Cloudlet, List<CloudSimEvent>> cloudletEvents;
    private final BrokerManager brokerManager;
    private int maxCloudletsToCreate;
    private boolean autoSubmitCloudlets;
    private Function<TaskEvent, Cloudlet> cloudletCreationFunction;
    private final CloudSimPlus simulation;

    public static GoogleTaskEventsTraceReader getInstance(CloudSimPlus simulation, String filePath, Function<TaskEvent, Cloudlet> cloudletCreationFunction) {
        InputStream is = ResourceLoader.newInputStream(filePath, GoogleTaskEventsTraceReader.class);
        return new GoogleTaskEventsTraceReader(simulation, filePath, is, cloudletCreationFunction);
    }

    public GoogleTaskEventsTraceReader(CloudSimPlus simulation, String filePath, Function<TaskEvent, Cloudlet> cloudletCreationFunction) throws IOException {
        this(simulation, filePath, Files.newInputStream(Paths.get(filePath, new String[0]), new OpenOption[0]), cloudletCreationFunction);
    }

    protected GoogleTaskEventsTraceReader(@NonNull CloudSimPlus simulation, String filePath, InputStream reader, Function<TaskEvent, Cloudlet> cloudletCreationFunction) {
        super(filePath, reader);
        if (simulation == null) {
            throw new NullPointerException("simulation is marked non-null but is null");
        }
        this.simulation = simulation;
        this.cloudletCreationFunction = Objects.requireNonNull(cloudletCreationFunction);
        this.autoSubmitCloudlets = true;
        this.cloudletEvents = new HashMap<Cloudlet, List<CloudSimEvent>>();
        this.brokerManager = new BrokerManager(this);
        this.setMaxCloudletsToCreate(Integer.MAX_VALUE);
    }

    @Override
    public final Collection<Cloudlet> process() {
        if (!this.autoSubmitCloudlets) {
            LOGGER.info("{}: Auto-submission of Cloudlets from trace file is disabled. Don't forget to submitted them to the broker.", (Object)this.getClass().getSimpleName());
        }
        return super.process();
    }

    @Override
    protected void preProcess() {
    }

    @Override
    protected void postProcess() {
        if (this.simulation.isRunning()) {
            this.sendCloudletEvents();
        } else {
            this.simulation.addOnSimulationStartListener(info -> this.sendCloudletEvents());
        }
    }

    private void sendCloudletEvents() {
        this.cloudletEvents.values().forEach(this::sendCloudletEvents);
    }

    protected void sendCloudletEvents(List<CloudSimEvent> events) {
        events.forEach(evt -> evt.getSource().schedule((SimEvent)evt));
    }

    @Override
    protected boolean processParsedLineInternal() {
        TaskEventType eventType = TaskEventType.of(this);
        return eventType.process(this);
    }

    boolean requestCloudletStatusChange(CloudSimTag tag) {
        TaskEvent taskEvent = TaskEvent.of(this);
        DatacenterBroker broker = this.brokerManager.getBroker(taskEvent.getUserName());
        double delay = taskEvent.getTimestamp();
        return this.findObject(taskEvent.getUniqueTaskId()).map(cloudlet -> this.addCloudletStatusChangeEvents(new CloudSimEvent(delay, broker, tag, cloudlet), taskEvent)).isPresent();
    }

    private Cloudlet addCloudletStatusChangeEvents(CloudSimEvent statusChangeSimEvt, TaskEvent taskEvent) {
        Cloudlet cloudlet = (Cloudlet)statusChangeSimEvt.getData();
        this.addEventToSend(cloudlet, statusChangeSimEvt);
        Cloudlet clone = this.createCloudlet(taskEvent);
        clone.setId(cloudlet.getId());
        if (!this.areCloudletAttributesDifferent(cloudlet, clone)) {
            return cloudlet;
        }
        Runnable attributesUpdateRunnable = () -> {
            DatacenterBroker broker = cloudlet.getBroker();
            StringBuilder builder = new StringBuilder();
            if (clone.getPriority() != cloudlet.getPriority()) {
                builder.append("priority: ").append(cloudlet.getPriority()).append(" -> ").append(clone.getPriority()).append(" | ");
                cloudlet.setFileSize(clone.getFileSize());
            }
            if (clone.getPesNumber() != cloudlet.getPesNumber()) {
                builder.append("PEs: ").append(cloudlet.getPesNumber()).append(" -> ").append(clone.getPesNumber()).append(" | ");
                cloudlet.setPesNumber(clone.getPesNumber());
            }
            UtilizationModelDynamic cloneRamUM = (UtilizationModelDynamic)clone.getUtilizationModelRam();
            UtilizationModelDynamic cloudletRamUM = (UtilizationModelDynamic)cloudlet.getUtilizationModelRam();
            if (cloneRamUM.getMaxResourceUtilization() != cloudletRamUM.getMaxResourceUtilization()) {
                builder.append("Max RAM Usage: ").append(this.formatPercentValue(cloudletRamUM.getMaxResourceUtilization())).append(" -> ").append(this.formatPercentValue(cloneRamUM.getMaxResourceUtilization())).append("% | ");
                cloudletRamUM.setMaxResourceUtilization(cloneRamUM.getMaxResourceUtilization());
            }
            DatacenterBroker.LOGGER.trace("{}: {}: {} attributes updated: {}", new Object[]{this.getSimulation().clockStr(), broker.getName(), cloudlet, builder});
        };
        CloudSimEvent attrsChangeSimEvt = new CloudSimEvent(taskEvent.getTimestamp(), statusChangeSimEvt.getDestination(), CloudSimTag.CLOUDLET_UPDATE_ATTRIBUTES, attributesUpdateRunnable);
        this.addEventToSend(cloudlet, attrsChangeSimEvt);
        return cloudlet;
    }

    private void addEventToSend(Cloudlet cloudlet, CloudSimEvent evt) {
        this.cloudletEvents.compute(cloudlet, (key, list) -> list == null ? new LinkedList() : list).add(evt);
    }

    protected Cloudlet createCloudlet(TaskEvent taskEvent) {
        Cloudlet cloudlet = this.cloudletCreationFunction.apply(taskEvent);
        if (cloudlet.getUtilizationModelRam() instanceof UtilizationModelDynamic) {
            return cloudlet;
        }
        throw new IllegalStateException("Since the 'task events' trace file provides a field defining the max RAM the Cloudlet can request (RESOURCE_REQUEST_FOR_RAM), it's required to use a UtilizationModelDynamic for the Cloudlet's RAM utilization model, so that the UtilizationModelDynamic.maxResourceUtilization attribute can be changed when defined in the trace file.");
    }

    private boolean areCloudletAttributesDifferent(Cloudlet cloudlet1, Cloudlet cloudlet2) {
        return cloudlet2.getFileSize() != cloudlet1.getFileSize() || cloudlet2.getPesNumber() != cloudlet1.getPesNumber() || cloudlet2.getUtilizationOfCpu() != cloudlet1.getUtilizationOfCpu() || cloudlet2.getUtilizationOfRam() != cloudlet1.getUtilizationOfRam();
    }

    public GoogleTaskEventsTraceReader setMaxCloudletsToCreate(int maxCloudletsToCreate) {
        if (maxCloudletsToCreate <= 0) {
            throw new IllegalArgumentException("Maximum number of Cloudlets to create must be greater than 0. If you want to create all Cloudlets from the entire file, provide Integer.MAX_VALUE.");
        }
        this.maxCloudletsToCreate = maxCloudletsToCreate;
        return this;
    }

    protected boolean allowCloudletCreation() {
        return this.availableObjectsCount() < this.getMaxCloudletsToCreate();
    }

    public final BrokerManager getBrokerManager() {
        return this.brokerManager;
    }

    public final int getMaxCloudletsToCreate() {
        return this.maxCloudletsToCreate;
    }

    public final boolean isAutoSubmitCloudlets() {
        return this.autoSubmitCloudlets;
    }

    public final Function<TaskEvent, Cloudlet> getCloudletCreationFunction() {
        return this.cloudletCreationFunction;
    }

    public final CloudSimPlus getSimulation() {
        return this.simulation;
    }

    public final GoogleTaskEventsTraceReader setAutoSubmitCloudlets(boolean autoSubmitCloudlets) {
        this.autoSubmitCloudlets = autoSubmitCloudlets;
        return this;
    }
}

