/*
 * Decompiled with CFR 0.152.
 */
package org.cloudsimplus.traces.google;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import lombok.NonNull;
import org.cloudsimplus.brokers.DatacenterBroker;
import org.cloudsimplus.cloudlets.Cloudlet;
import org.cloudsimplus.core.CloudSimTag;
import org.cloudsimplus.core.Simulation;
import org.cloudsimplus.core.events.CloudSimEvent;
import org.cloudsimplus.core.events.SimEvent;
import org.cloudsimplus.listeners.EventInfo;
import org.cloudsimplus.traces.google.GoogleTaskEventsTraceReader;
import org.cloudsimplus.traces.google.GoogleTraceReaderAbstract;
import org.cloudsimplus.traces.google.TaskUsage;
import org.cloudsimplus.traces.google.TraceField;
import org.cloudsimplus.util.ResourceLoader;
import org.cloudsimplus.util.TimeUtil;
import org.cloudsimplus.utilizationmodels.UtilizationModel;
import org.cloudsimplus.utilizationmodels.UtilizationModelDynamic;

public final class GoogleTaskUsageTraceReader
extends GoogleTraceReaderAbstract<Cloudlet> {
    private final List<CloudSimEvent> cloudletUsageChangeEvents;
    private final GoogleTaskEventsTraceReader taskEventsReader;
    private final Simulation simulation;

    public static GoogleTaskUsageTraceReader getInstance(GoogleTaskEventsTraceReader taskEventsReader, String filePath) {
        InputStream is = ResourceLoader.newInputStream(filePath, GoogleTaskUsageTraceReader.class);
        return new GoogleTaskUsageTraceReader(taskEventsReader, filePath, is);
    }

    private GoogleTaskUsageTraceReader(@NonNull GoogleTaskEventsTraceReader taskEventsReader, String filePath, InputStream reader) {
        super(filePath, reader);
        if (taskEventsReader == null) {
            throw new NullPointerException("taskEventsReader is marked non-null but is null");
        }
        this.taskEventsReader = taskEventsReader;
        List<DatacenterBroker> brokerList = this.getBrokers();
        if (brokerList.isEmpty()) {
            throw new IllegalArgumentException("The broker list in your GoogleTaskEventsTraceReader is empty");
        }
        this.simulation = brokerList.get(0).getSimulation();
        this.cloudletUsageChangeEvents = new ArrayList<CloudSimEvent>();
    }

    private List<DatacenterBroker> getBrokers() {
        return this.taskEventsReader.getBrokerManager().getBrokers();
    }

    @Override
    public Collection<Cloudlet> process() {
        return super.process();
    }

    @Override
    protected void preProcess() {
    }

    @Override
    protected void postProcess() {
        this.simulation.addOnSimulationStartListener(this::onSimulationStart);
    }

    private void onSimulationStart(EventInfo info) {
        this.cloudletUsageChangeEvents.forEach(evt -> evt.getSource().schedule((SimEvent)evt));
    }

    @Override
    protected boolean processParsedLineInternal() {
        TaskUsage taskUsage = new TaskUsage(this);
        return this.taskEventsReader.findObject(taskUsage.getUniqueTaskId()).map(cloudlet -> this.requestCloudletUsageChange((Cloudlet)cloudlet, taskUsage)).isPresent();
    }

    private boolean requestCloudletUsageChange(Cloudlet cloudlet, TaskUsage taskUsage) {
        Runnable resourceUsageUpdateRunnable = () -> {
            StringBuilder builder = new StringBuilder();
            if (cloudlet.getUtilizationOfCpu() != taskUsage.getMeanCpuUsageRate()) {
                builder.append("CPU Utilization: ").append(this.formatPercentValue(cloudlet.getUtilizationOfCpu())).append(" -> ").append(this.formatPercentValue(taskUsage.getMeanCpuUsageRate())).append('%').append(" | ");
                cloudlet.setUtilizationModelCpu(this.createUtilizationModel(cloudlet.getUtilizationModelCpu(), taskUsage.getMeanCpuUsageRate()));
            }
            if (cloudlet.getUtilizationOfRam() != taskUsage.getCanonicalMemoryUsage()) {
                builder.append("RAM Utilization: ").append(this.formatPercentValue(cloudlet.getUtilizationOfRam())).append(" -> ").append(this.formatPercentValue(taskUsage.getCanonicalMemoryUsage())).append('%').append(" | ");
                cloudlet.setUtilizationModelRam(this.createUtilizationModel(cloudlet.getUtilizationModelRam(), taskUsage.getCanonicalMemoryUsage()));
            }
            DatacenterBroker broker = cloudlet.getBroker();
            DatacenterBroker.LOGGER.trace("{}: {}: {} resource usage changed: {}", new Object[]{this.simulation.clockStr(), broker.getName(), cloudlet, builder});
            cloudlet.getVm().getHost().updateProcessing(this.simulation.clock());
        };
        if (this.hasCloudletResourceUsageChanged(cloudlet, taskUsage)) {
            this.addAvailableObject(cloudlet);
            CloudSimEvent evt = new CloudSimEvent(taskUsage.getStartTime(), cloudlet.getBroker(), CloudSimTag.CLOUDLET_UPDATE_ATTRIBUTES, resourceUsageUpdateRunnable);
            return this.cloudletUsageChangeEvents.add(evt);
        }
        return false;
    }

    private UtilizationModel createUtilizationModel(UtilizationModel source, double initialUtilization) {
        if (source instanceof UtilizationModelDynamic) {
            UtilizationModelDynamic umDynamic = (UtilizationModelDynamic)source;
            return new UtilizationModelDynamic(umDynamic, initialUtilization);
        }
        return new UtilizationModelDynamic(initialUtilization);
    }

    private boolean hasCloudletResourceUsageChanged(Cloudlet cloudlet, TaskUsage taskUsage) {
        return cloudlet.getUtilizationOfCpu() != taskUsage.getMeanCpuUsageRate() || cloudlet.getUtilizationOfRam() != taskUsage.getCanonicalMemoryUsage();
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum FieldIndex implements TraceField<GoogleTaskUsageTraceReader>
    {
        START_TIME{

            @Override
            public Double getValue(GoogleTaskUsageTraceReader reader) {
                return TimeUtil.microToSeconds(reader.getFieldDoubleValue(this));
            }
        }
        ,
        END_TIME{

            @Override
            public Double getValue(GoogleTaskUsageTraceReader reader) {
                return TimeUtil.microToSeconds(reader.getFieldDoubleValue(this));
            }
        }
        ,
        JOB_ID{

            @Override
            public Long getValue(GoogleTaskUsageTraceReader reader) {
                return reader.getFieldLongValue(this);
            }
        }
        ,
        TASK_INDEX{

            @Override
            public Long getValue(GoogleTaskUsageTraceReader reader) {
                return reader.getFieldLongValue(this);
            }
        }
        ,
        MACHINE_ID{

            @Override
            public Long getValue(GoogleTaskUsageTraceReader reader) {
                return reader.getFieldLongValue(this, -1L);
            }
        }
        ,
        MEAN_CPU_USAGE_RATE{

            @Override
            public Double getValue(GoogleTaskUsageTraceReader reader) {
                return reader.getFieldDoubleValue(this, 0.0);
            }
        }
        ,
        CANONICAL_MEMORY_USAGE{

            @Override
            public Double getValue(GoogleTaskUsageTraceReader reader) {
                return reader.getFieldDoubleValue(this, 0.0);
            }
        }
        ,
        ASSIGNED_MEMORY_USAGE{

            @Override
            public Double getValue(GoogleTaskUsageTraceReader reader) {
                return reader.getFieldDoubleValue(this, 0.0);
            }
        }
        ,
        UNMAPPED_PAGE_CACHE_MEMORY_USAGE{

            @Override
            public Double getValue(GoogleTaskUsageTraceReader reader) {
                return reader.getFieldDoubleValue(this, 0.0);
            }
        }
        ,
        TOTAL_PAGE_CACHE_MEMORY_USAGE{

            @Override
            public Double getValue(GoogleTaskUsageTraceReader reader) {
                return reader.getFieldDoubleValue(this, 0.0);
            }
        }
        ,
        MAXIMUM_MEMORY_USAGE{

            @Override
            public Double getValue(GoogleTaskUsageTraceReader reader) {
                return reader.getFieldDoubleValue(this, -1.0);
            }
        }
        ,
        MEAN_DISK_IO_TIME{

            @Override
            public Double getValue(GoogleTaskUsageTraceReader reader) {
                return reader.getFieldDoubleValue(this, 0.0);
            }
        }
        ,
        MEAN_LOCAL_DISK_SPACE_USED{

            @Override
            public Double getValue(GoogleTaskUsageTraceReader reader) {
                return reader.getFieldDoubleValue(this, 0.0);
            }
        }
        ,
        MAXIMUM_CPU_USAGE{

            @Override
            public Double getValue(GoogleTaskUsageTraceReader reader) {
                return reader.getFieldDoubleValue(this, -1.0);
            }
        }
        ,
        MAXIMUM_DISK_IO_TIME{

            @Override
            public Double getValue(GoogleTaskUsageTraceReader reader) {
                return reader.getFieldDoubleValue(this, -1.0);
            }
        };

    }
}

