/*
 * Decompiled with CFR 0.152.
 */
package org.cloudsimplus.traces.google;

import org.cloudsimplus.hosts.Host;
import org.cloudsimplus.traces.google.GoogleMachineEventsTraceReader;
import org.cloudsimplus.traces.google.MachineEventField;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum MachineEventType {
    ADD{

        @Override
        protected boolean process(GoogleMachineEventsTraceReader reader) {
            Host host = reader.createHostFromTraceLine();
            host.setStartTime((Double)MachineEventField.TIMESTAMP.getValue(reader));
            return host.getStartTime() == 0.0 ? reader.addAvailableObject(host) : reader.addLaterAvailableHost(host);
        }
    }
    ,
    REMOVE{

        @Override
        protected boolean process(GoogleMachineEventsTraceReader reader) {
            Host host = reader.createHostFromTraceLine();
            host.setShutdownTime((Double)MachineEventField.TIMESTAMP.getValue(reader));
            return reader.addHostToRemovalList(host);
        }
    }
    ,
    UPDATE{

        @Override
        protected boolean process(GoogleMachineEventsTraceReader reader) {
            System.err.printf("%s: Update events are NOT being processed yet.%n", ((Object)((Object)this)).getClass().getSimpleName());
            return false;
        }
    };


    public static MachineEventType getValue(int ordinal) {
        return MachineEventType.values()[ordinal];
    }

    protected abstract boolean process(GoogleMachineEventsTraceReader var1);
}

