/*
 * Decompiled with CFR 0.152.
 */
package org.cloudsimplus.util;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.math3.linear.Array2DRowRealMatrix;
import org.apache.commons.math3.stat.regression.OLSMultipleLinearRegression;
import org.apache.commons.math3.stat.regression.SimpleRegression;
import org.cloudsimplus.util.MathUtil;

public final class Regression {
    private Regression() {
    }

    public static SimpleRegression newLinearRegression(double[] x, double[] y) {
        SimpleRegression regression = new SimpleRegression();
        for (int i = 0; i < x.length; ++i) {
            regression.addData(x[i], y[i]);
        }
        return regression;
    }

    public static OLSMultipleLinearRegression newLinearRegression(double[][] x, double[] y) {
        OLSMultipleLinearRegression regression = new OLSMultipleLinearRegression();
        regression.newSampleData(y, x);
        return regression;
    }

    public static SimpleRegression newWeightedLinearRegression(double[] x, double[] y, double[] weights) {
        double[] weightedX = new double[x.length];
        double[] weightedY = new double[y.length];
        long numZeroWeights = Arrays.stream(weights).filter(weight -> weight <= 0.0).count();
        for (int i = 0; i < x.length; ++i) {
            if ((double)numZeroWeights >= 0.4 * (double)weights.length) {
                weightedX[i] = Math.sqrt(weights[i]) * x[i];
                weightedY[i] = Math.sqrt(weights[i]) * y[i];
                continue;
            }
            weightedX[i] = x[i];
            weightedY[i] = y[i];
        }
        return Regression.newLinearRegression(weightedX, weightedY);
    }

    public static double[] getLoessParameterEstimates(double ... y) {
        double[] x = Regression.createIndependentArray(y.length);
        SimpleRegression regression = Regression.newWeightedLinearRegression(x, y, Regression.getTricubeWeights(y.length));
        return regression.regress().getParameterEstimates();
    }

    public static double[] getRobustLoessParameterEstimates(double ... y) {
        double[] x = Regression.createIndependentArray(y.length);
        SimpleRegression tricubeRegression = Regression.newWeightedLinearRegression(x, y, Regression.getTricubeWeights(y.length));
        double[] residuals = new double[y.length];
        for (int i = 0; i < y.length; ++i) {
            residuals[i] = y[i] - tricubeRegression.predict(x[i]);
        }
        SimpleRegression tricubeBySqrRegression = Regression.newWeightedLinearRegression(x, y, Regression.getTricubeBisquareWeights(residuals));
        double[] estimates = tricubeBySqrRegression.regress().getParameterEstimates();
        if (Double.isNaN(estimates[0]) || Double.isNaN(estimates[1])) {
            return tricubeRegression.regress().getParameterEstimates();
        }
        return estimates;
    }

    private static double[] getTricubeWeights(int weightsNumber) {
        double[] weights = new double[weightsNumber];
        double top = weightsNumber - 1;
        for (int i = 2; i < weightsNumber; ++i) {
            double k = Math.pow(1.0 - Math.pow((top - (double)i) / top, 3.0), 3.0);
            weights[i] = k > 0.0 ? 1.0 / k : Double.MAX_VALUE;
        }
        weights[0] = weights[1] = weights[2];
        return weights;
    }

    private static double[] getTricubeBisquareWeights(double ... residuals) {
        double[] weights = Regression.getTricubeWeights(residuals.length);
        double[] weights2 = new double[residuals.length];
        double s6 = MathUtil.median(MathUtil.abs(residuals)) * 6.0;
        for (int i = 2; i < residuals.length; ++i) {
            double k = Math.pow(1.0 - Math.pow(residuals[i] / s6, 2.0), 2.0);
            weights2[i] = k > 0.0 ? 1.0 / k * weights[i] : Double.MAX_VALUE;
        }
        weights2[0] = weights2[1] = weights2[2];
        return weights2;
    }

    public static List<Double> correlationCoefficients(double[][] data) {
        int rows = data.length;
        int cols = data[0].length;
        LinkedList<Double> correlationCoefficients = new LinkedList<Double>();
        for (int i = 0; i < rows; ++i) {
            double[][] x = new double[rows - 1][cols];
            int k = 0;
            for (int j = 0; j < rows; ++j) {
                if (j == i) continue;
                x[k++] = data[j];
            }
            double[][] xT = new Array2DRowRealMatrix(x).transpose().getData();
            correlationCoefficients.add(Regression.newLinearRegression(xT, data[i]).calculateRSquared());
        }
        return correlationCoefficients;
    }

    private static double[] createIndependentArray(int length) {
        double[] x = new double[length];
        for (int i = 0; i < length; ++i) {
            x[i] = i + 1;
        }
        return x;
    }
}

