/*
 * Decompiled with CFR 0.152.
 */
package org.cloudsimplus.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UncheckedIOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class ResourceLoader {
    private ResourceLoader() {
    }

    public static BufferedReader newBufferedReader(String filePath, Class klass) {
        return new BufferedReader(ResourceLoader.newInputStreamReader(filePath, klass));
    }

    public static InputStreamReader newInputStreamReader(String filePath, Class klass) {
        return new InputStreamReader(ResourceLoader.newInputStream(filePath, klass));
    }

    public static InputStreamReader newInputStreamReader(String filePath) {
        try {
            return new InputStreamReader(Files.newInputStream(Paths.get(filePath, new String[0]), new OpenOption[0]));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static InputStream newInputStream(String filePath, Class klass) {
        InputStream inputStream = klass.getClassLoader().getResourceAsStream(File.separator + filePath);
        if (inputStream != null) {
            return inputStream;
        }
        inputStream = klass.getResourceAsStream(File.separator + filePath);
        if (inputStream != null) {
            return inputStream;
        }
        try {
            return Files.newInputStream(Paths.get(filePath, new String[0]), new OpenOption[0]);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static String getResourcePath(Class klass, String name) {
        URL url = ResourceLoader.getResourceUrl(klass, name);
        return url == null || url.getPath() == null ? "" : url.getFile();
    }

    public static URL getResourceUrl(Class klass, String name) {
        return klass.getClassLoader().getResource(name);
    }

    public static List<String> getResourceList(Class klass, String resourceDir) {
        List<String> list;
        block9: {
            URI uri = ResourceLoader.getResourceUri(klass, resourceDir);
            Path fullPath = ResourceLoader.uriToPath(resourceDir, uri);
            Stream<Path> pathStream = Files.walk(fullPath, 1, new FileVisitOption[0]);
            try {
                List<String> fileNameList = pathStream.map(path -> resourceDir + File.separator + path.getFileName().toString()).collect(Collectors.toList());
                if (!fileNameList.isEmpty()) {
                    fileNameList.remove(0);
                }
                list = fileNameList;
                if (pathStream == null) break block9;
            }
            catch (Throwable throwable) {
                if (pathStream != null) {
                    try {
                        pathStream.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            pathStream.close();
        }
        return list;
    }

    private static URI getResourceUri(Class klass, String resourceDir) {
        try {
            return ResourceLoader.getResourceUrl(klass, resourceDir).toURI();
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Path uriToPath(String resourceDir, URI uri) {
        Path path;
        if (!uri.getScheme().equals("jar")) return Paths.get(uri);
        try (FileSystem fileSystem = FileSystems.newFileSystem(uri, Collections.emptyMap());){
            path = fileSystem.getPath(resourceDir, new String[0]);
            if (fileSystem == null) return path;
        }
        return path;
    }
}

