/*
 * Decompiled with CFR 0.152.
 */
package org.cloudsimplus.util;

import org.apache.commons.lang3.StringUtils;
import org.cloudsimplus.util.MathUtil;

public final class Util {
    private Util() {
    }

    public static void sleep(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static void printProgress(int current, int total) {
        Util.printProgress(current, total, false);
    }

    public static void printProgress(int current, int total, boolean progressBarInNewLine) {
        String progress = StringUtils.repeat((char)'#', (int)current);
        String end = progressBarInNewLine ? "%n" : "\r";
        String format = "%120s[%-" + total + "s] %3.0f%% (%d/%d)" + end;
        System.out.printf(format, " ", progress, MathUtil.percentValue(current, total), current, total);
    }

    public static double[][] newSquareMatrix(int size) {
        return new double[size][size];
    }

    public static double[][] newSquareMatrix(int size, double defaultValue) {
        double[][] matrix;
        for (double[] line : matrix = Util.newSquareMatrix(size)) {
            for (int col = 0; col < size; ++col) {
                line[col] = defaultValue;
            }
        }
        return matrix;
    }
}

