/*
 * Decompiled with CFR 0.152.
 */
package org.cloudsimplus.utilizationmodels;

import lombok.NonNull;
import org.cloudsimplus.core.Simulation;
import org.cloudsimplus.utilizationmodels.UtilizationModel;

public abstract class UtilizationModelAbstract
implements UtilizationModel {
    public static final double ALMOST_ZERO = 1.0E-10;
    @NonNull
    private Simulation simulation;
    private UtilizationModel.Unit unit;
    private boolean overCapacityRequestAllowed;

    public UtilizationModelAbstract() {
        this(UtilizationModel.Unit.PERCENTAGE);
    }

    public UtilizationModelAbstract(@NonNull UtilizationModel.Unit unit) {
        if (unit == null) {
            throw new NullPointerException("unit is marked non-null but is null");
        }
        this.simulation = Simulation.NULL;
        this.setUnit(unit);
    }

    protected final void setUnit(@NonNull UtilizationModel.Unit unit) {
        if (unit == null) {
            throw new NullPointerException("unit is marked non-null but is null");
        }
        this.unit = unit;
    }

    @Override
    public final double getUtilization() {
        return this.getUtilization(this.simulation.clock());
    }

    @Override
    public final double getUtilization(double time) {
        if (time < 0.0) {
            throw new IllegalArgumentException("Time cannot be negative.");
        }
        double requested = this.getUtilizationInternal(time);
        return this.unit == UtilizationModel.Unit.ABSOLUTE || this.overCapacityRequestAllowed ? requested : Math.min(requested, 1.0);
    }

    protected abstract double getUtilizationInternal(double var1);

    protected void validateUtilizationField(String fieldName, double fieldValue) {
        this.validateUtilizationField(fieldName, fieldValue, 0.0);
    }

    protected void validateUtilizationField(String fieldName, double fieldValue, double minValue) {
        double d = minValue = minValue <= 1.0E-10 ? 0.0 : minValue;
        if (fieldValue < minValue) {
            throw new IllegalArgumentException(fieldName + " cannot be lower than " + minValue);
        }
    }

    @Override
    @NonNull
    public final Simulation getSimulation() {
        return this.simulation;
    }

    @Override
    public final UtilizationModel.Unit getUnit() {
        return this.unit;
    }

    @Override
    public final boolean isOverCapacityRequestAllowed() {
        return this.overCapacityRequestAllowed;
    }

    @Override
    public final UtilizationModelAbstract setSimulation(@NonNull Simulation simulation) {
        if (simulation == null) {
            throw new NullPointerException("simulation is marked non-null but is null");
        }
        this.simulation = simulation;
        return this;
    }

    @Override
    public final UtilizationModelAbstract setOverCapacityRequestAllowed(boolean overCapacityRequestAllowed) {
        this.overCapacityRequestAllowed = overCapacityRequestAllowed;
        return this;
    }
}

