/*
 * Decompiled with CFR 0.152.
 */
package org.cloudsimplus.vms;

import java.util.List;
import org.cloudsimplus.autoscaling.HorizontalVmScaling;
import org.cloudsimplus.autoscaling.VerticalVmScaling;
import org.cloudsimplus.brokers.DatacenterBroker;
import org.cloudsimplus.cloudlets.Cloudlet;
import org.cloudsimplus.core.AbstractMachine;
import org.cloudsimplus.core.CustomerEntity;
import org.cloudsimplus.core.ResourceStatsComputer;
import org.cloudsimplus.core.UniquelyIdentifiable;
import org.cloudsimplus.datacenters.Datacenter;
import org.cloudsimplus.datacenters.TimeZoned;
import org.cloudsimplus.hosts.Host;
import org.cloudsimplus.listeners.EventListener;
import org.cloudsimplus.listeners.VmDatacenterEventInfo;
import org.cloudsimplus.listeners.VmHostEventInfo;
import org.cloudsimplus.resources.Processor;
import org.cloudsimplus.resources.Resource;
import org.cloudsimplus.schedulers.MipsShare;
import org.cloudsimplus.schedulers.cloudlet.CloudletScheduler;
import org.cloudsimplus.vms.VmGroup;
import org.cloudsimplus.vms.VmNull;
import org.cloudsimplus.vms.VmResourceStats;
import org.cloudsimplus.vms.VmStateHistoryEntry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface Vm
extends AbstractMachine<Resource>,
UniquelyIdentifiable,
Comparable<Vm>,
CustomerEntity,
TimeZoned,
ResourceStatsComputer<VmResourceStats> {
    public static final Logger LOGGER = LoggerFactory.getLogger((String)Vm.class.getSimpleName());
    public static final Vm NULL = new VmNull();

    public String getDescription();

    public Vm setDescription(String var1);

    public VmGroup getGroup();

    public void addStateHistoryEntry(VmStateHistoryEntry var1);

    public CloudletScheduler getCloudletScheduler();

    public long getFreePesNumber();

    public long getExpectedFreePesNumber();

    public long getCurrentRequestedBw();

    public MipsShare getCurrentRequestedMips();

    public long getCurrentRequestedRam();

    public double getTotalCpuMipsRequested();

    public Host getHost();

    public Vm addOnHostAllocationListener(EventListener<VmHostEventInfo> var1);

    public Vm addOnMigrationStartListener(EventListener<VmHostEventInfo> var1);

    public Vm addOnMigrationFinishListener(EventListener<VmHostEventInfo> var1);

    public Vm addOnHostDeallocationListener(EventListener<VmHostEventInfo> var1);

    public Vm addOnCreationFailureListener(EventListener<VmDatacenterEventInfo> var1);

    public Vm addOnUpdateProcessingListener(EventListener<VmHostEventInfo> var1);

    public void notifyOnHostAllocationListeners();

    public void notifyOnHostDeallocationListeners(Host var1);

    public void notifyOnCreationFailureListeners(Datacenter var1);

    public boolean removeOnMigrationStartListener(EventListener<VmHostEventInfo> var1);

    public boolean removeOnMigrationFinishListener(EventListener<VmHostEventInfo> var1);

    public boolean removeOnUpdateProcessingListener(EventListener<VmHostEventInfo> var1);

    public boolean removeOnHostAllocationListener(EventListener<VmHostEventInfo> var1);

    public boolean removeOnHostDeallocationListener(EventListener<VmHostEventInfo> var1);

    public boolean removeOnCreationFailureListener(EventListener<VmDatacenterEventInfo> var1);

    @Override
    public Resource getBw();

    @Override
    public Resource getRam();

    @Override
    public Resource getStorage();

    public List<VmStateHistoryEntry> getStateHistory();

    public double getCpuPercentUtilization(double var1);

    public double getCpuPercentUtilization();

    public double getCpuPercentRequested(double var1);

    public double getCpuPercentRequested();

    @Override
    public void enableUtilizationStats();

    public double getHostRamUtilization();

    public double getHostBwUtilization();

    default public double getHostCpuUtilization() {
        return this.getHostCpuUtilization(this.getSimulation().clock());
    }

    public double getHostCpuUtilization(double var1);

    public double getExpectedHostCpuUtilization(double var1);

    public double getTotalCpuMipsUtilization();

    public double getTotalCpuMipsUtilization(double var1);

    public String getVmm();

    public boolean isCreated();

    public boolean isSuitableForCloudlet(Cloudlet var1);

    public void setCreated(boolean var1);

    public boolean isInMigration();

    public Vm setInMigration(boolean var1);

    public Vm setBw(long var1);

    public Vm setHost(Host var1);

    public Vm setRam(long var1);

    public Vm setSize(long var1);

    public double updateProcessing(double var1, MipsShare var3);

    public double updateProcessing(MipsShare var1);

    public Vm setCloudletScheduler(CloudletScheduler var1);

    public void setFailed(boolean var1);

    public boolean isFailed();

    public boolean isWorking();

    @Override
    default public boolean isIdleEnough(double time) {
        return this.getCloudletScheduler().getCloudletExecList().isEmpty() && AbstractMachine.super.isIdleEnough(time);
    }

    public HorizontalVmScaling getHorizontalScaling();

    public Vm setHorizontalScaling(HorizontalVmScaling var1) throws IllegalArgumentException;

    public Vm setRamVerticalScaling(VerticalVmScaling var1) throws IllegalArgumentException;

    public Vm setBwVerticalScaling(VerticalVmScaling var1) throws IllegalArgumentException;

    public Vm setPeVerticalScaling(VerticalVmScaling var1) throws IllegalArgumentException;

    public VerticalVmScaling getRamVerticalScaling();

    public VerticalVmScaling getBwVerticalScaling();

    public VerticalVmScaling getPeVerticalScaling();

    public Processor getProcessor();

    @Override
    public DatacenterBroker getBroker();

    @Override
    public CustomerEntity setBroker(DatacenterBroker var1);

    public double getStopTime();

    public double getTotalExecutionTime();

    public Vm setStopTime(double var1);

    @Override
    public double getTimeZone();

    @Override
    public Vm setTimeZone(double var1);
}

