/*
 * Decompiled with CFR 0.152.
 */
package org.cloudsimplus.vms;

import java.util.List;
import java.util.Objects;
import lombok.NonNull;
import org.cloudsimplus.core.AbstractMachine;
import org.cloudsimplus.resources.ResourceCapacity;
import org.cloudsimplus.schedulers.MipsShare;
import org.cloudsimplus.schedulers.cloudlet.CloudletScheduler;
import org.cloudsimplus.vms.Vm;
import org.cloudsimplus.vms.VmSimple;

public class VmGroup
extends VmSimple {
    private final List<Vm> vmList;

    public VmGroup(@NonNull List<Vm> vmList) {
        super(VmGroup.getMaxMips(vmList), VmGroup.getTotalPes(vmList));
        if (vmList == null) {
            throw new NullPointerException("vmList is marked non-null but is null");
        }
        this.vmList = vmList;
        this.vmList.forEach(vm -> ((VmSimple)vm).setGroup(this));
        if (vmList.isEmpty()) {
            throw new IllegalStateException("The List of VMs belonging to a " + VmGroup.class.getSimpleName() + " cannot be empty.");
        }
        this.setBroker(vmList.get(0).getBroker());
        this.setCloudletScheduler(CloudletScheduler.NULL);
        this.setVmm("None");
        this.setTotalRam();
        this.setTotalBw();
        this.setTotalStorage();
        this.setTimeZone(Double.MIN_VALUE);
    }

    public VmGroup(List<Vm> vmList, double timeZone) {
        this(vmList);
        this.setTimeZone(timeZone);
    }

    public VmGroup(long id, List<Vm> vmList, double timeZone) {
        this(vmList, timeZone);
        this.setId(id);
    }

    @Override
    public double getHostCpuUtilization(double time) {
        return this.vmList.stream().mapToDouble(vm -> vm.getHostCpuUtilization(time)).sum();
    }

    @Override
    public double getHostRamUtilization() {
        return this.vmList.stream().mapToDouble(Vm::getHostRamUtilization).sum();
    }

    @Override
    public double getHostBwUtilization() {
        return this.vmList.stream().mapToDouble(Vm::getHostBwUtilization).sum();
    }

    @Override
    public final Vm setTimeZone(double timeZone) {
        if (timeZone != Double.MIN_VALUE) {
            super.setTimeZone(timeZone);
            this.vmList.forEach(vm -> vm.setTimeZone(timeZone));
        }
        return this;
    }

    private static double getMaxMips(List<Vm> vmList) {
        return Objects.requireNonNull(vmList).stream().mapToDouble(AbstractMachine::getMips).max().orElse(0.0);
    }

    private static long getTotalPes(List<Vm> vmList) {
        return vmList.stream().mapToLong(AbstractMachine::getPesNumber).sum();
    }

    private void setTotalRam() {
        long total = this.vmList.stream().map(Vm::getRam).mapToLong(ResourceCapacity::getCapacity).sum();
        this.setRam(total);
    }

    private void setTotalBw() {
        long total = this.vmList.stream().map(Vm::getBw).mapToLong(ResourceCapacity::getCapacity).sum();
        this.setBw(total);
    }

    private void setTotalStorage() {
        long total = this.vmList.stream().map(Vm::getStorage).mapToLong(ResourceCapacity::getCapacity).sum();
        this.setSize(total);
    }

    public int size() {
        return this.vmList.size();
    }

    @Override
    public double updateProcessing(double currentTime, MipsShare mipsShare) {
        double minNextEventDelay = Double.MAX_VALUE;
        for (Vm vm : this.vmList) {
            double nextEventDelay = vm.updateProcessing(currentTime, vm.getHost().getVmScheduler().getAllocatedMips(vm));
            minNextEventDelay = Math.min(minNextEventDelay, nextEventDelay);
        }
        return minNextEventDelay;
    }

    public final List<Vm> getVmList() {
        return this.vmList;
    }
}

