/*
 * Decompiled with CFR 0.152.
 */
package org.cloudsimplus.vmtemplates;

import com.google.gson.Gson;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.cloudsimplus.util.MathUtil;
import org.cloudsimplus.util.ResourceLoader;

public class AwsEc2Template
implements Comparable<AwsEc2Template> {
    public static final AwsEc2Template NULL = new AwsEc2Template();
    private Path path;
    private String name;
    private int cpus;
    private int memoryInMB;
    private double pricePerHour;
    private String region;

    public AwsEc2Template() {
    }

    public AwsEc2Template(AwsEc2Template source) {
        this.name = source.name;
        this.cpus = source.cpus;
        this.region = source.region;
        this.memoryInMB = source.memoryInMB;
        this.pricePerHour = source.pricePerHour;
        this.path = Paths.get(source.path.toUri());
    }

    public AwsEc2Template(String jsonFilePath) {
        this(AwsEc2Template.getInstanceInternal(jsonFilePath, ResourceLoader.newInputStreamReader(jsonFilePath)));
    }

    public static AwsEc2Template getInstance(String jsonFilePath) {
        InputStreamReader reader = ResourceLoader.newInputStreamReader(jsonFilePath, AwsEc2Template.class);
        return AwsEc2Template.getInstanceInternal(jsonFilePath, reader);
    }

    private static AwsEc2Template getInstanceInternal(String jsonFilePath, InputStreamReader reader) {
        AwsEc2Template template = (AwsEc2Template)new Gson().fromJson((Reader)reader, AwsEc2Template.class);
        template.path = Paths.get(jsonFilePath, new String[0]);
        return template;
    }

    public void setPricePerHour(double pricePerHour) {
        this.pricePerHour = MathUtil.nonNegative(pricePerHour, "pricePerHour");
    }

    public String getFilePath() {
        return this.path.toAbsolutePath().toString();
    }

    public String getFileName() {
        return this.path.getFileName().toString();
    }

    @Override
    public int compareTo(AwsEc2Template template) {
        int comparison = Double.compare(this.cpus, template.cpus);
        if (comparison != 0) {
            return comparison;
        }
        comparison = Double.compare(this.memoryInMB, template.memoryInMB);
        if (comparison != 0) {
            return comparison;
        }
        comparison = Double.compare(this.pricePerHour, template.pricePerHour);
        return comparison;
    }

    public static Builder builder() {
        return new Builder();
    }

    public final Path getPath() {
        return this.path;
    }

    public final String getName() {
        return this.name;
    }

    public final int getCpus() {
        return this.cpus;
    }

    public final int getMemoryInMB() {
        return this.memoryInMB;
    }

    public final double getPricePerHour() {
        return this.pricePerHour;
    }

    public final String getRegion() {
        return this.region;
    }

    public final AwsEc2Template setPath(Path path) {
        this.path = path;
        return this;
    }

    public final AwsEc2Template setName(String name) {
        this.name = name;
        return this;
    }

    public final AwsEc2Template setCpus(int cpus) {
        this.cpus = cpus;
        return this;
    }

    public final AwsEc2Template setMemoryInMB(int memoryInMB) {
        this.memoryInMB = memoryInMB;
        return this;
    }

    public final AwsEc2Template setRegion(String region) {
        this.region = region;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AwsEc2Template)) {
            return false;
        }
        AwsEc2Template other = (AwsEc2Template)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getCpus() != other.getCpus()) {
            return false;
        }
        if (this.getMemoryInMB() != other.getMemoryInMB()) {
            return false;
        }
        if (Double.compare(this.getPricePerHour(), other.getPricePerHour()) != 0) {
            return false;
        }
        Path this$path = this.getPath();
        Path other$path = other.getPath();
        if (this$path == null ? other$path != null : !((Object)this$path).equals(other$path)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$region = this.getRegion();
        String other$region = other.getRegion();
        return !(this$region == null ? other$region != null : !this$region.equals(other$region));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AwsEc2Template;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getCpus();
        result = result * 59 + this.getMemoryInMB();
        long $pricePerHour = Double.doubleToLongBits(this.getPricePerHour());
        result = result * 59 + (int)($pricePerHour >>> 32 ^ $pricePerHour);
        Path $path = this.getPath();
        result = result * 59 + ($path == null ? 43 : ((Object)$path).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $region = this.getRegion();
        result = result * 59 + ($region == null ? 43 : $region.hashCode());
        return result;
    }

    public String toString() {
        return "AwsEc2Template(name=" + this.getName() + ", cpus=" + this.getCpus() + ", memoryInMB=" + this.getMemoryInMB() + ", pricePerHour=" + this.getPricePerHour() + ", region=" + this.getRegion() + ")";
    }

    protected AwsEc2Template(Path path, String name, int cpus, int memoryInMB, double pricePerHour, String region) {
        this.path = path;
        this.name = name;
        this.cpus = cpus;
        this.memoryInMB = memoryInMB;
        this.pricePerHour = pricePerHour;
        this.region = region;
    }

    public static class Builder {
        private Path path;
        private String name;
        private int cpus;
        private int memoryInMB;
        private double pricePerHour;
        private String region;

        Builder() {
        }

        public final Builder path(Path path) {
            this.path = path;
            return this;
        }

        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Builder cpus(int cpus) {
            this.cpus = cpus;
            return this;
        }

        public final Builder memoryInMB(int memoryInMB) {
            this.memoryInMB = memoryInMB;
            return this;
        }

        public final Builder pricePerHour(double pricePerHour) {
            this.pricePerHour = pricePerHour;
            return this;
        }

        public final Builder region(String region) {
            this.region = region;
            return this;
        }

        public AwsEc2Template build() {
            return new AwsEc2Template(this.path, this.name, this.cpus, this.memoryInMB, this.pricePerHour, this.region);
        }

        public String toString() {
            return "AwsEc2Template.Builder(path=" + this.path + ", name=" + this.name + ", cpus=" + this.cpus + ", memoryInMB=" + this.memoryInMB + ", pricePerHour=" + this.pricePerHour + ", region=" + this.region + ")";
        }
    }
}

