/*
 * Decompiled with CFR 0.152.
 */
package org.clulab.pdf2txt.amazon;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.util.concurrent.atomic.AtomicBoolean;
import org.clulab.pdf2txt.amazon.AmazonConverter$;
import org.clulab.pdf2txt.amazon.AmazonSettings;
import org.clulab.pdf2txt.common.pdf.PdfConverter;
import org.clulab.pdf2txt.common.utils.Closer$;
import org.clulab.pdf2txt.common.utils.MetadataHolder;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.ProfileCredentialsProvider;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.profiles.ProfileFile;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.model.DeleteObjectRequest;
import software.amazon.awssdk.services.s3.model.DeleteObjectResponse;
import software.amazon.awssdk.services.s3.model.GetObjectAttributesRequest;
import software.amazon.awssdk.services.s3.model.GetObjectAttributesResponse;
import software.amazon.awssdk.services.s3.model.NoSuchKeyException;
import software.amazon.awssdk.services.s3.model.ObjectAttributes;
import software.amazon.awssdk.services.s3.model.PutObjectRequest;
import software.amazon.awssdk.services.s3.model.PutObjectResponse;
import software.amazon.awssdk.services.textract.TextractClient;
import software.amazon.awssdk.services.textract.model.Block;
import software.amazon.awssdk.services.textract.model.BlockType;
import software.amazon.awssdk.services.textract.model.DetectDocumentTextRequest;
import software.amazon.awssdk.services.textract.model.DetectDocumentTextResponse;
import software.amazon.awssdk.services.textract.model.Document;
import software.amazon.awssdk.services.textract.model.DocumentLocation;
import software.amazon.awssdk.services.textract.model.GetDocumentTextDetectionRequest;
import software.amazon.awssdk.services.textract.model.GetDocumentTextDetectionResponse;
import software.amazon.awssdk.services.textract.model.S3Object;
import software.amazon.awssdk.services.textract.model.StartDocumentTextDetectionRequest;
import software.amazon.awssdk.services.textract.model.StartDocumentTextDetectionResponse;

@ScalaSignature(bytes="\u0006\u0001\u0005mg\u0001B\u0012%\u00015B\u0001B\u0010\u0001\u0003\u0002\u0003\u0006Ia\u0010\u0005\u0006\u0007\u0002!\t\u0001\u0012\u0005\b\u000f\u0002\u0011\r\u0011\"\u0001I\u0011\u0019\u0019\u0006\u0001)A\u0005\u0013\"9A\u000b\u0001b\u0001\n\u0003A\u0005BB+\u0001A\u0003%\u0011\nC\u0004W\u0001\t\u0007I\u0011A,\t\r\u0015\u0004\u0001\u0015!\u0003Y\u0011!1\u0007\u0001#b\u0001\n\u00039\u0007\u0002C;\u0001\u0011\u000b\u0007I\u0011\u0001<\t\u0013}\u0004\u0001R1A\u0005\u0002\u0005\u0005\u0001bBA\b\u0001\u0011\u0005\u0013\u0011\u0003\u0005\b\u00037\u0001A\u0011AA\u000f\u0011\u001d\tI\u0003\u0001C\u0001\u0003WAq!a\u0010\u0001\t\u0003\t\t\u0005C\u0004\u0002F\u0001!\t!a\u0012\t\u000f\u0005%\u0004\u0001\"\u0001\u0002l!9\u0011\u0011\u000f\u0001\u0005\u0002\u0005M\u0004bBA<\u0001\u0011\u0005\u0013\u0011\u0010\u0005\n\u0003'\u0003\u0011\u0013!C\u0001\u0003+;q!a+%\u0011\u0003\tiK\u0002\u0004$I!\u0005\u0011q\u0016\u0005\u0007\u0007Z!\t!a.\t\u0011\u0005efC1A\u0005\u0002]Cq!a/\u0017A\u0003%\u0001\fC\u0005\u0002>Z\u0011\r\u0011\"\u0001\u0002@\"A\u0011Q\u0019\f!\u0002\u0013\t\t\rC\u0005\u0002HZ\u0011\r\u0011\"\u0001\u0002@\"A\u0011\u0011\u001a\f!\u0002\u0013\t\t\rC\u0005\u0002LZ\u0011\r\u0011\"\u0001\u0002@\"A\u0011Q\u001a\f!\u0002\u0013\t\t\rC\u0005\u0002PZ\u0011\r\u0011\"\u0001\u0002R\"9\u00111\u001b\f!\u0002\u0013y\u0004\"CAk-E\u0005I\u0011AAl\u0005=\tU.\u0019>p]\u000e{gN^3si\u0016\u0014(BA\u0013'\u0003\u0019\tW.\u0019>p]*\u0011q\u0005K\u0001\ba\u00124'\u0007\u001e=u\u0015\tI#&\u0001\u0004dYVd\u0017M\u0019\u0006\u0002W\u0005\u0019qN]4\u0004\u0001M\u0019\u0001A\f\u001c\u0011\u0005=\"T\"\u0001\u0019\u000b\u0005E\u0012\u0014\u0001\u00027b]\u001eT\u0011aM\u0001\u0005U\u00064\u0018-\u0003\u00026a\t1qJ\u00196fGR\u0004\"a\u000e\u001f\u000e\u0003aR!!\u000f\u001e\u0002\u0007A$gM\u0003\u0002<M\u000511m\\7n_:L!!\u0010\u001d\u0003\u0019A#gmQ8om\u0016\u0014H/\u001a:\u0002\u001d\u0005l\u0017M_8o'\u0016$H/\u001b8hgB\u0011\u0001)Q\u0007\u0002I%\u0011!\t\n\u0002\u000f\u00036\f'p\u001c8TKR$\u0018N\\4t\u0003\u0019a\u0014N\\5u}Q\u0011QI\u0012\t\u0003\u0001\u0002AqA\u0010\u0002\u0011\u0002\u0003\u0007q(\u0001\u0005tg%\u001bx\n]3o+\u0005I\u0005C\u0001&R\u001b\u0005Y%B\u0001'N\u0003\u0019\tGo\\7jG*\u0011ajT\u0001\u000bG>t7-\u001e:sK:$(B\u0001)3\u0003\u0011)H/\u001b7\n\u0005I[%!D!u_6L7MQ8pY\u0016\fg.A\u0005tg%\u001bx\n]3oA\u0005a\u0011-\\1{_:L5o\u00149f]\u0006i\u0011-\\1{_:L5o\u00149f]\u0002\n!BY;dW\u0016$h*Y7f+\u0005A\u0006CA-c\u001d\tQ\u0006\r\u0005\u0002\\=6\tAL\u0003\u0002^Y\u00051AH]8pizR\u0011aX\u0001\u0006g\u000e\fG.Y\u0005\u0003Cz\u000ba\u0001\u0015:fI\u00164\u0017BA2e\u0005\u0019\u0019FO]5oO*\u0011\u0011MX\u0001\fEV\u001c7.\u001a;OC6,\u0007%A\nde\u0016$WM\u001c;jC2\u001c\bK]8wS\u0012,'/F\u0001i!\tI7/D\u0001k\u0015\tYG.A\u0006de\u0016$WM\u001c;jC2\u001c(BA7o\u0003\u0011\tW\u000f\u001e5\u000b\u0005=\u0004\u0018AB1xgN$7N\u0003\u0002&c*\t!/\u0001\u0005t_\u001a$x/\u0019:f\u0013\t!(N\u0001\u000eQe>4\u0017\u000e\\3De\u0016$WM\u001c;jC2\u001c\bK]8wS\u0012,'/\u0001\u0005tg\rc\u0017.\u001a8u+\u00059\bC\u0001=~\u001b\u0005I(B\u0001>|\u0003\t\u00198G\u0003\u0002}]\u0006A1/\u001a:wS\u000e,7/\u0003\u0002\u007fs\nA1kM\"mS\u0016tG/\u0001\u0007b[\u0006TxN\\\"mS\u0016tG/\u0006\u0002\u0002\u0004A!\u0011QAA\u0006\u001b\t\t9AC\u0002\u0002\nm\f\u0001\u0002^3yiJ\f7\r^\u0005\u0005\u0003\u001b\t9A\u0001\bUKb$(/Y2u\u00072LWM\u001c;\u0002\u000b\rdwn]3\u0015\u0005\u0005M\u0001\u0003BA\u000b\u0003/i\u0011AX\u0005\u0004\u00033q&\u0001B+oSR\fAb]\u001aGS2,W\t_5tiN$B!a\b\u0002&A!\u0011QCA\u0011\u0013\r\t\u0019C\u0018\u0002\b\u0005>|G.Z1o\u0011\u0019\t9#\u0004a\u00011\u0006Aa-\u001b7f\u001d\u0006lW-\u0001\u0007tgU\u0003Hn\\1e\r&dW\r\u0006\u0004\u0002\u0014\u00055\u0012Q\b\u0005\b\u0003_q\u0001\u0019AA\u0019\u0003\u00111\u0017\u000e\\3\u0011\t\u0005M\u0012\u0011H\u0007\u0003\u0003kQ1!a\u000e3\u0003\tIw.\u0003\u0003\u0002<\u0005U\"\u0001\u0002$jY\u0016Da!a\n\u000f\u0001\u0004A\u0016\u0001D:4\t\u0016dW\r^3GS2,G\u0003BA\n\u0003\u0007Ba!a\n\u0010\u0001\u0004A\u0016!D2p]Z,'\u000f\u001e\"m_\u000e\\7\u000fF\u0002Y\u0003\u0013Bq!a\u0013\u0011\u0001\u0004\ti%\u0001\u0004cY>\u001c7n\u001d\t\u0007\u0003\u001f\nI&!\u0018\u000e\u0005\u0005E#\u0002BA*\u0003+\nq!\\;uC\ndWMC\u0002\u0002Xy\u000b!bY8mY\u0016\u001cG/[8o\u0013\u0011\tY&!\u0015\u0003\u0007M+\u0017\u000f\u0005\u0003\u0002`\u0005\u0015TBAA1\u0015\u0011\t\u0019'a\u0002\u0002\u000b5|G-\u001a7\n\t\u0005\u001d\u0014\u0011\r\u0002\u0006\u00052|7m[\u0001\u0012G>tg/\u001a:u'&tw\r\\3QC\u001e,Gc\u0001-\u0002n!9\u0011qN\tA\u0002\u0005E\u0012a\u00029eM\u001aKG.Z\u0001\u0015G>tg/\u001a:u\u001bVdG/\u001b9mKB\u000bw-Z:\u0015\u0007a\u000b)\bC\u0004\u0002pI\u0001\r!!\r\u0002\u000f\r|gN^3siR)\u0001,a\u001f\u0002~!9\u0011qN\nA\u0002\u0005E\u0002\"CA@'A\u0005\t\u0019AAA\u0003EiW\r^1eCR\f\u0007j\u001c7eKJ|\u0005\u000f\u001e\t\u0007\u0003+\t\u0019)a\"\n\u0007\u0005\u0015eL\u0001\u0004PaRLwN\u001c\t\u0005\u0003\u0013\u000by)\u0004\u0002\u0002\f*\u0019\u0011Q\u0012\u001e\u0002\u000bU$\u0018\u000e\\:\n\t\u0005E\u00151\u0012\u0002\u000f\u001b\u0016$\u0018\rZ1uC\"{G\u000eZ3s\u0003E\u0019wN\u001c<feR$C-\u001a4bk2$HEM\u000b\u0003\u0003/SC!!!\u0002\u001a.\u0012\u00111\u0014\t\u0005\u0003;\u000b9+\u0004\u0002\u0002 *!\u0011\u0011UAR\u0003%)hn\u00195fG.,GMC\u0002\u0002&z\u000b!\"\u00198o_R\fG/[8o\u0013\u0011\tI+a(\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-A\bB[\u0006TxN\\\"p]Z,'\u000f^3s!\t\u0001ecE\u0002\u0017\u0003c\u0003B!!\u0006\u00024&\u0019\u0011Q\u00170\u0003\r\u0005s\u0017PU3g)\t\ti+\u0001\neK\u001a\fW\u000f\u001c;De\u0016$WM\u001c;jC2\u001c\u0018a\u00053fM\u0006,H\u000e^\"sK\u0012,g\u000e^5bYN\u0004\u0013A\u00043fM\u0006,H\u000e\u001e)s_\u001aLG.Z\u000b\u0003\u0003\u0003\u00042aLAb\u0013\t\u0019\u0007'A\beK\u001a\fW\u000f\u001c;Qe>4\u0017\u000e\\3!\u00035!WMZ1vYR\u0014VmZ5p]\u0006qA-\u001a4bk2$(+Z4j_:\u0004\u0013!\u00043fM\u0006,H\u000e\u001e\"vG.,G/\u0001\beK\u001a\fW\u000f\u001c;Ck\u000e\\W\r\u001e\u0011\u0002\u001f\u0011,g-Y;miN+G\u000f^5oON,\u0012aP\u0001\u0011I\u00164\u0017-\u001e7u'\u0016$H/\u001b8hg\u0002\n1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\nTCAAmU\ry\u0014\u0011\u0014")
public class AmazonConverter
implements PdfConverter {
    private ProfileCredentialsProvider credentialsProvider;
    private S3Client s3Client;
    private TextractClient amazonClient;
    private final AmazonSettings amazonSettings;
    private final AtomicBoolean s3IsOpen;
    private final AtomicBoolean amazonIsOpen;
    private final String bucketName;
    private final String inputExtension;
    private final String outputExtension;
    private final String metaExtension;
    private volatile byte bitmap$0;

    public static AmazonSettings $lessinit$greater$default$1() {
        return AmazonConverter$.MODULE$.$lessinit$greater$default$1();
    }

    public static AmazonSettings defaultSettings() {
        return AmazonConverter$.MODULE$.defaultSettings();
    }

    public static String defaultBucket() {
        return AmazonConverter$.MODULE$.defaultBucket();
    }

    public static String defaultRegion() {
        return AmazonConverter$.MODULE$.defaultRegion();
    }

    public static String defaultProfile() {
        return AmazonConverter$.MODULE$.defaultProfile();
    }

    public static String defaultCredentials() {
        return AmazonConverter$.MODULE$.defaultCredentials();
    }

    public String inputExtension() {
        return this.inputExtension;
    }

    public String outputExtension() {
        return this.outputExtension;
    }

    public String metaExtension() {
        return this.metaExtension;
    }

    public void org$clulab$pdf2txt$common$pdf$PdfConverter$_setter_$inputExtension_$eq(String x$1) {
        this.inputExtension = x$1;
    }

    public void org$clulab$pdf2txt$common$pdf$PdfConverter$_setter_$outputExtension_$eq(String x$1) {
        this.outputExtension = x$1;
    }

    public void org$clulab$pdf2txt$common$pdf$PdfConverter$_setter_$metaExtension_$eq(String x$1) {
        this.metaExtension = x$1;
    }

    public AtomicBoolean s3IsOpen() {
        return this.s3IsOpen;
    }

    public AtomicBoolean amazonIsOpen() {
        return this.amazonIsOpen;
    }

    public String bucketName() {
        return this.bucketName;
    }

    private ProfileCredentialsProvider credentialsProvider$lzycompute() {
        AmazonConverter amazonConverter = this;
        synchronized (amazonConverter) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                ProfileFile profileFile = ProfileFile.builder().content(new File(this.amazonSettings.credentials()).toPath()).type(ProfileFile.Type.CREDENTIALS).build();
                this.credentialsProvider = ProfileCredentialsProvider.builder().profileFile(profileFile).profileName(this.amazonSettings.profile()).build();
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.credentialsProvider;
    }

    public ProfileCredentialsProvider credentialsProvider() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.credentialsProvider$lzycompute() : this.credentialsProvider;
    }

    /*
     * WARNING - void declaration
     */
    private S3Client s3Client$lzycompute() {
        AmazonConverter amazonConverter = this;
        synchronized (amazonConverter) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                void var2_2;
                S3Client s3Client = (S3Client)S3Client.builder().credentialsProvider((AwsCredentialsProvider)this.credentialsProvider()).region(Region.of((String)this.amazonSettings.region())).build();
                this.s3IsOpen().set(true);
                this.s3Client = var2_2;
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.s3Client;
    }

    public S3Client s3Client() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.s3Client$lzycompute() : this.s3Client;
    }

    /*
     * WARNING - void declaration
     */
    private TextractClient amazonClient$lzycompute() {
        AmazonConverter amazonConverter = this;
        synchronized (amazonConverter) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                void var2_2;
                TextractClient amazonClient = (TextractClient)TextractClient.builder().region(Region.of((String)this.amazonSettings.region())).credentialsProvider((AwsCredentialsProvider)this.credentialsProvider()).build();
                this.amazonIsOpen().set(true);
                this.amazonClient = var2_2;
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.amazonClient;
    }

    public TextractClient amazonClient() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this.amazonClient$lzycompute() : this.amazonClient;
    }

    public void close() {
        block1: {
            if (this.s3IsOpen().getAndSet(false)) {
                this.s3Client().close();
            }
            if (!this.amazonIsOpen().getAndSet(false)) break block1;
            this.amazonClient().close();
        }
    }

    public boolean s3FileExists(String fileName) {
        boolean bl;
        try {
            GetObjectAttributesRequest getObjectAttributesRequest = (GetObjectAttributesRequest)GetObjectAttributesRequest.builder().bucket(this.bucketName()).key(fileName).objectAttributes(new ObjectAttributes[]{ObjectAttributes.OBJECT_SIZE}).build();
            GetObjectAttributesResponse getObjectAttributesResponse = this.s3Client().getObjectAttributes(getObjectAttributesRequest);
            bl = true;
        }
        catch (NoSuchKeyException noSuchKeyException) {
            bl = false;
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        return bl;
    }

    public void s3UploadFile(File file, String fileName) {
        PutObjectRequest putObjectRequest = (PutObjectRequest)PutObjectRequest.builder().bucket(this.bucketName()).key(fileName).build();
        PutObjectResponse putObjectResponse = this.s3Client().putObject(putObjectRequest, file.toPath());
    }

    public void s3DeleteFile(String fileName) {
        DeleteObjectRequest deleteObjectRequest = (DeleteObjectRequest)DeleteObjectRequest.builder().bucket(this.bucketName()).key(fileName).build();
        DeleteObjectResponse deleteObjectResponse = this.s3Client().deleteObject(deleteObjectRequest);
    }

    public String convertBlocks(scala.collection.mutable.Seq<Block> blocks) {
        StringBuilder stringBuilder = new StringBuilder();
        blocks.foreach((Function1 & Serializable & scala.Serializable)block -> {
            BoxedUnit boxedUnit;
            BlockType blockType = block.blockType();
            BlockType blockType2 = blockType;
            if (BlockType.PAGE.equals(blockType2)) {
                boxedUnit = stringBuilder.nonEmpty() ? stringBuilder.append("\f") : BoxedUnit.UNIT;
            } else if (BlockType.LINE.equals(blockType2)) {
                stringBuilder.append(block.text());
                boxedUnit = stringBuilder.append("\n");
            } else if (BlockType.WORD.equals(blockType2)) {
                boxedUnit = BoxedUnit.UNIT;
            } else {
                Predef$.MODULE$.println((Object)"Unknown blocktype");
                boxedUnit = BoxedUnit.UNIT;
            }
            return boxedUnit;
        });
        return stringBuilder.toString();
    }

    public String convertSinglePage(File pdfFile) {
        SdkBytes sdkBytes = (SdkBytes)Closer$.MODULE$.AutoCloser((Object)new FileInputStream(pdfFile)).autoClose((Function1 & Serializable & scala.Serializable)inputStream -> SdkBytes.fromInputStream((InputStream)inputStream));
        Document document = (Document)Document.builder().bytes(sdkBytes).build();
        DetectDocumentTextRequest detectDocumentTextRequest = (DetectDocumentTextRequest)DetectDocumentTextRequest.builder().document(document).build();
        DetectDocumentTextResponse detectDocumentTextResponse = this.amazonClient().detectDocumentText(detectDocumentTextRequest);
        Buffer blocks = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(detectDocumentTextResponse.blocks()).asScala();
        return this.convertBlocks((scala.collection.mutable.Seq<Block>)blocks);
    }

    public String convertMultiplePages(File pdfFile) {
        String pdfFileName = pdfFile.getName();
        if (this.s3FileExists(pdfFileName)) {
            throw new RuntimeException(new java.lang.StringBuilder(69).append("There is already a blob \"").append(pdfFileName).append("\" in the \"").append(this.bucketName()).append("\" bucket.  Please remove it first.").toString());
        }
        this.s3UploadFile(pdfFile, pdfFileName);
        S3Object s3Object = (S3Object)S3Object.builder().bucket(this.bucketName()).name(pdfFileName).build();
        DocumentLocation documentLocation = (DocumentLocation)DocumentLocation.builder().s3Object(s3Object).build();
        StartDocumentTextDetectionRequest startDocumentTextDetectionRequest = (StartDocumentTextDetectionRequest)StartDocumentTextDetectionRequest.builder().documentLocation(documentLocation).build();
        StartDocumentTextDetectionResponse startDocumentTextDetectionRequestResponse = this.amazonClient().startDocumentTextDetection(startDocumentTextDetectionRequest);
        String jobId = startDocumentTextDetectionRequestResponse.jobId();
        scala.collection.mutable.Seq blocks = this.loopJobId$1(jobId);
        String result = this.convertBlocks((scala.collection.mutable.Seq<Block>)blocks);
        this.s3DeleteFile(pdfFileName);
        return result;
    }

    public String convert(File pdfFile, Option<MetadataHolder> metadataHolderOpt) {
        return this.amazonSettings.bucket().isEmpty() ? this.convertSinglePage(pdfFile) : this.convertMultiplePages(pdfFile);
    }

    public Option<MetadataHolder> convert$default$2() {
        return None$.MODULE$;
    }

    private final GetDocumentTextDetectionResponse loopRequest$1(GetDocumentTextDetectionRequest getDocumentTextDetectionRequest$1) {
        GetDocumentTextDetectionResponse getDocumentTextDetectionResponse;
        while (true) {
            getDocumentTextDetectionResponse = this.amazonClient().getDocumentTextDetection(getDocumentTextDetectionRequest$1);
            String string = getDocumentTextDetectionResponse.jobStatusAsString();
            String string2 = "IN_PROGRESS";
            if (string == null ? string2 != null : !string.equals(string2)) break;
            Thread.sleep(1000L);
        }
        return getDocumentTextDetectionResponse;
    }

    private final GetDocumentTextDetectionResponse loopTokenOpt$1(Option tokenOpt, String jobId$1) {
        GetDocumentTextDetectionRequest.Builder builder = GetDocumentTextDetectionRequest.builder().jobId(jobId$1);
        tokenOpt.foreach((Function1 & Serializable & scala.Serializable)x$1 -> builder.nextToken(x$1));
        GetDocumentTextDetectionRequest getDocumentTextDetectionRequest = (GetDocumentTextDetectionRequest)builder.build();
        return this.loopRequest$1(getDocumentTextDetectionRequest);
    }

    private final void loopNextTokenOpt$1(Option tokenOpt, ArrayBuffer blocks$1, String jobId$1) {
        while (true) {
            GetDocumentTextDetectionResponse getDocumentTextDetectionResponse = this.loopTokenOpt$1(tokenOpt, jobId$1);
            Option nextTokenOpt = Option$.MODULE$.apply((Object)getDocumentTextDetectionResponse.nextToken());
            blocks$1.$plus$plus$eq((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(getDocumentTextDetectionResponse.blocks()).asScala());
            if (!nextTokenOpt.isDefined()) break;
            tokenOpt = nextTokenOpt;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final scala.collection.mutable.Seq loopBlocks$1(String jobId$1) {
        void var2_2;
        ArrayBuffer blocks = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.loopNextTokenOpt$1((Option)None$.MODULE$, blocks, jobId$1);
        return var2_2;
    }

    private final scala.collection.mutable.Seq loopJobId$1(String jobId) {
        return this.loopBlocks$1(jobId);
    }

    public AmazonConverter(AmazonSettings amazonSettings) {
        this.amazonSettings = amazonSettings;
        PdfConverter.$init$((PdfConverter)this);
        this.s3IsOpen = new AtomicBoolean(false);
        this.amazonIsOpen = new AtomicBoolean(false);
        this.bucketName = amazonSettings.bucket();
    }
}

