/*
 * Decompiled with CFR 0.152.
 */
package jsr166y.forkjoin;

import java.lang.reflect.Field;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import jsr166y.forkjoin.ForkJoinWorkerThread;
import sun.misc.Unsafe;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ForkJoinTask<V> {
    volatile Throwable exception;
    static final AtomicReferenceFieldUpdater<ForkJoinTask, Throwable> exceptionUpdater = AtomicReferenceFieldUpdater.newUpdater(ForkJoinTask.class, Throwable.class, "exception");
    int status;
    private static final Unsafe _unsafe = ForkJoinTask.getUnsafe();

    ForkJoinTask() {
    }

    final void setStolen() {
        this.status = 1;
    }

    final Throwable setDone() {
        Throwable ex = this.exception;
        int s = this.status;
        this.status = -1;
        if (s != 0) {
            ForkJoinWorkerThread.signalTaskCompletion();
        }
        return ex;
    }

    final Throwable setDoneExceptionally(Throwable rex) {
        exceptionUpdater.compareAndSet(this, null, rex);
        ForkJoinWorkerThread.signalTaskCompletion();
        return this.exception;
    }

    final V reportAsForkJoinResult() {
        Throwable ex = this.getException();
        if (ex != null) {
            ForkJoinTask.rethrowException(ex);
        }
        return this.rawResult();
    }

    final V reportAsFutureResult() throws ExecutionException {
        Throwable ex = this.getException();
        if (ex != null) {
            if (ex instanceof CancellationException) {
                throw (CancellationException)ex;
            }
            throw new ExecutionException(ex);
        }
        return this.rawResult();
    }

    public final void fork() {
        ((ForkJoinWorkerThread)Thread.currentThread()).pushTask(this);
    }

    public final V join() {
        return (V)((ForkJoinWorkerThread)Thread.currentThread()).doJoinTask(this);
    }

    public abstract V forkJoin();

    public final boolean isDone() {
        return this.exception != null || this.status < 0;
    }

    public final boolean isCancelled() {
        return this.exception instanceof CancellationException;
    }

    public void cancel() {
        this.setDoneExceptionally(new CancellationException());
    }

    public final Throwable getException() {
        return this.exception;
    }

    public abstract V rawResult();

    public void reinitialize() {
        if (this.exception != null) {
            this.exception = null;
        }
        this.status = 0;
    }

    public final boolean isStolen() {
        return this.status > 0;
    }

    public final Throwable quietlyJoin() {
        return ((ForkJoinWorkerThread)Thread.currentThread()).doQuietlyJoinTask(this);
    }

    public abstract Throwable exec();

    public abstract void finish(V var1);

    public abstract void finishExceptionally(Throwable var1);

    private static Unsafe getUnsafe() {
        try {
            if (ForkJoinTask.class.getClassLoader() != null) {
                Field f = Unsafe.class.getDeclaredField("theUnsafe");
                f.setAccessible(true);
                return (Unsafe)f.get(null);
            }
            return Unsafe.getUnsafe();
        }
        catch (Exception e) {
            throw new RuntimeException("Could not initialize intrinsics", e);
        }
    }

    static final void rethrowException(Throwable ex) {
        if (ex != null) {
            _unsafe.throwException(ex);
        }
    }
}

