/*
 * Decompiled with CFR 0.152.
 */
package org.codeconsole.web.analytics;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.codeconsole.web.analytics.AnalyticsHttpRequest;
import org.codeconsole.web.analytics.AnalyticsSession;
import org.codeconsole.web.analytics.HttpStatusExposingServletResponse;
import org.codeconsole.web.analytics.integration.AnalyticsGateway;
import org.codeconsole.web.analytics.integration.SourceRevisionResolver;
import org.codeconsole.web.analytics.integration.UserDetailsResolver;
import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.web.bind.ServletRequestUtils;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class AnalyticsFilter
implements Filter {
    public static final String DEFAULT_ANALTICS_URL = "/analytics";
    public static final String DEFAULT_SPRING_CONFIGURATION = "META-INF/spring/analytics.xml";
    private String analyticsUrl = "/analytics";
    private String springConfiguration = "META-INF/spring/analytics.xml";
    private String sessionAttributeName = "analyticsSession";
    private int maxHistorySize = 50;
    private AnalyticsGateway analyticsGateway;
    private List<Pattern> excludedUrlPatterns = new ArrayList<Pattern>();
    private List<Pattern> excludedParamPatterns = new ArrayList<Pattern>();
    private SourceRevisionResolver sourceRevisionResolver;
    private UserDetailsResolver userDetailsResolver;

    public void destroy() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        Serializable userDetails22;
        boolean ignore22;
        AnalyticsHttpRequest rq;
        AnalyticsSession analyticsSession;
        HttpStatusExposingServletResponse httpResponse;
        HttpServletRequest httpRequest;
        block25: {
            Iterator<Pattern> i$;
            String compareUrl;
            httpRequest = (HttpServletRequest)request;
            httpResponse = new HttpStatusExposingServletResponse((HttpServletResponse)response);
            analyticsSession = (AnalyticsSession)httpRequest.getSession().getAttribute(this.sessionAttributeName);
            if (analyticsSession == null) {
                analyticsSession = new AnalyticsSession(this.maxHistorySize, httpRequest.getHeader("referer"), this.getIp(httpRequest));
                httpRequest.getSession().setAttribute(this.sessionAttributeName, (Object)analyticsSession);
            }
            if ((compareUrl = this.getComparisonUrl((HttpServletRequest)request)).endsWith(this.analyticsUrl)) {
                response.setContentType("text/html");
                PrintWriter out = response.getWriter();
                out.println("<html><head><title>Analytics Report</title></head><body>");
                if (ServletRequestUtils.getBooleanParameter((ServletRequest)request, (String)"send", (boolean)false)) {
                    if (this.analyticsGateway != null) {
                        this.analyticsGateway.sendAnalytics(analyticsSession);
                    } else {
                        out.println("<div>Warning: Can't send report.  No Spring application context specified/configured.</div>");
                    }
                    out.println("<div>Message: Report Sent!</div>");
                }
                if (ServletRequestUtils.getBooleanParameter((ServletRequest)request, (String)"clear", (boolean)false)) {
                    analyticsSession.clear();
                    httpRequest.getSession().setAttribute(this.sessionAttributeName, (Object)analyticsSession);
                    out.println("<div>Message: History Cleared!</div>");
                }
                out.print("<div><a href=\"?\">Refresh</a> &nbsp; <a href=\"?clear=true\">Clear</a> &nbsp; <a href=\"?send=true\">Send</a> &nbsp; <a href=\"?send=true&clear=true\">Send and Clear</a></div>");
                out.print(analyticsSession.toHtmlString());
                out.println("</body></html>");
                out.close();
                return;
            }
            String sourceRevision = this.sourceRevisionResolver == null ? null : this.sourceRevisionResolver.getRevision(httpRequest);
            HashMap<String, String[]> filteredParamMap = request.getParameterMap();
            if (!this.excludedUrlPatterns.isEmpty()) {
                filteredParamMap = new HashMap<String, String[]>();
                for (Map.Entry next : request.getParameterMap().entrySet()) {
                    for (Pattern exclude : this.excludedUrlPatterns) {
                        if (exclude.matcher(compareUrl).matches()) {
                            filteredParamMap.put((String)next.getKey(), new String[]{"**FILTERED**"});
                            continue;
                        }
                        filteredParamMap.put((String)next.getKey(), (String[])next.getValue());
                    }
                }
            }
            rq = new AnalyticsHttpRequest(httpRequest.getMethod(), httpRequest.getRequestURL().toString(), httpRequest.getQueryString(), filteredParamMap, sourceRevision);
            try {
                try {
                    chain.doFilter(request, (ServletResponse)httpResponse);
                }
                catch (IOException e) {
                    rq.setException(e);
                    throw e;
                }
                catch (ServletException e) {
                    rq.setException((Exception)((Object)e));
                    throw e;
                }
                catch (RuntimeException e) {
                    rq.setException(e);
                    throw e;
                }
                Object var15_18 = null;
                rq.setCompletionTime(System.currentTimeMillis());
                rq.setStatus(httpResponse.getStatus());
                ignore22 = false;
                if (rq.getStatus() != 200 && rq.getStatus() != 304) break block25;
                i$ = this.excludedUrlPatterns.iterator();
            }
            catch (Throwable throwable) {
                Serializable userDetails22;
                Object var15_19 = null;
                rq.setCompletionTime(System.currentTimeMillis());
                rq.setStatus(httpResponse.getStatus());
                boolean ignore22 = false;
                if (rq.getStatus() == 200 || rq.getStatus() == 304) {
                    for (Pattern exclude : this.excludedUrlPatterns) {
                        if (!exclude.matcher(compareUrl).matches()) continue;
                        ignore22 = true;
                        break;
                    }
                }
                if (!ignore22) {
                    analyticsSession.appendHistory(rq);
                }
                Serializable serializable = userDetails22 = this.userDetailsResolver == null ? null : this.userDetailsResolver.getUserDetails(httpRequest);
                if (!(userDetails22 == null || analyticsSession.getUserDetails() != null && analyticsSession.getUserDetails().equals(userDetails22))) {
                    analyticsSession.setUserDetails(userDetails22);
                }
                if (!httpResponse.isCommitted()) {
                    httpRequest.getSession().setAttribute(this.sessionAttributeName, (Object)analyticsSession);
                }
                if (rq.getWrappedException() == null) throw throwable;
                if (this.analyticsGateway == null) throw throwable;
                this.analyticsGateway.sendAnalytics(analyticsSession);
                throw throwable;
            }
            while (i$.hasNext()) {
                Pattern exclude = i$.next();
                if (!exclude.matcher(compareUrl).matches()) continue;
                ignore22 = true;
                break;
            }
        }
        if (!ignore22) {
            analyticsSession.appendHistory(rq);
        }
        Serializable serializable = userDetails22 = this.userDetailsResolver == null ? null : this.userDetailsResolver.getUserDetails(httpRequest);
        if (!(userDetails22 == null || analyticsSession.getUserDetails() != null && analyticsSession.getUserDetails().equals(userDetails22))) {
            analyticsSession.setUserDetails(userDetails22);
        }
        if (!httpResponse.isCommitted()) {
            httpRequest.getSession().setAttribute(this.sessionAttributeName, (Object)analyticsSession);
        }
        if (rq.getWrappedException() == null) return;
        if (this.analyticsGateway == null) return;
        this.analyticsGateway.sendAnalytics(analyticsSession);
    }

    public void init(FilterConfig fConfig) throws ServletException {
        String excludedParms;
        String excluded;
        String sessionAttribute;
        String historySize;
        String springConfigurationParam = fConfig.getInitParameter("spring-context-location");
        if (springConfigurationParam != null) {
            this.springConfiguration = springConfigurationParam;
        }
        ClassPathXmlApplicationContext context = null;
        try {
            context = new ClassPathXmlApplicationContext(this.springConfiguration);
        }
        catch (BeanDefinitionStoreException notfound) {
            System.out.println("AnalyticsFilter: Could not locate context configuration: " + this.springConfiguration + ". Attempting to load root Web Application Context.");
            context = WebApplicationContextUtils.getWebApplicationContext((ServletContext)fConfig.getServletContext());
        }
        System.out.println("AnalyticsFilter: Loading bean definitions.");
        if (context != null) {
            if (context.containsBean("analyticsGateway")) {
                this.analyticsGateway = (AnalyticsGateway)context.getBean("analyticsGateway", AnalyticsGateway.class);
                System.out.println("AnalyticsFilter: Gateway loaded.");
            } else {
                System.out.println("AnalyticsFilter: Could not a bean named 'analyticsGateway'. Analytics will not be sent!");
            }
            if (context.containsBean("userDetailsResolver")) {
                this.userDetailsResolver = (UserDetailsResolver)context.getBean("userDetailsResolver", UserDetailsResolver.class);
                System.out.println("AnalyticsFilter: UserDetailsResolver loaded.");
            }
            if (context.containsBean("sourceRevisionResolver")) {
                this.sourceRevisionResolver = (SourceRevisionResolver)context.getBean("sourceRevisionResolver", SourceRevisionResolver.class);
                System.out.println("AnalyticsFilter: SourceRevisionResolver loaded.");
            }
        } else {
            System.out.println("AnalyticsFilter: Could not load root Web Application Context.");
        }
        if ((historySize = fConfig.getInitParameter("history-size")) != null) {
            this.maxHistorySize = Integer.parseInt(historySize);
        }
        if ((sessionAttribute = fConfig.getInitParameter("session-attribute")) != null) {
            this.sessionAttributeName = sessionAttribute;
        }
        if ((excluded = fConfig.getInitParameter("exclude-urls")) != null) {
            String[] excludes;
            for (String exclude : excludes = excluded.split("[\r\n]+")) {
                if ((exclude = exclude.trim()).isEmpty()) continue;
                this.excludedUrlPatterns.add(Pattern.compile(exclude));
            }
        }
        if ((excludedParms = fConfig.getInitParameter("exclude-params")) != null) {
            String[] paramExcludes;
            for (String exclude : paramExcludes = excludedParms.split("[\r\n]+")) {
                if ((exclude = exclude.trim()).isEmpty()) continue;
                this.excludedParamPatterns.add(Pattern.compile(exclude));
            }
        }
    }

    private String getIp(HttpServletRequest request) {
        String ip = request.getHeader("x-forwarded-for");
        if (ip == null) {
            return request.getRemoteAddr();
        }
        if (ip.indexOf(44) != -1) {
            ip = ip.substring(ip.lastIndexOf(44) + 1).trim();
        }
        return ip;
    }

    private String getComparisonUrl(HttpServletRequest request) {
        String uri = request.getRequestURI();
        int pathParamIndex = uri.indexOf(59);
        if (pathParamIndex > 0) {
            uri = uri.substring(0, pathParamIndex);
        }
        return uri;
    }
}

