/*
 * Decompiled with CFR 0.152.
 */
package org.codeconsole.web.analytics;

import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.codeconsole.web.analytics.WrappedException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnalyticsHttpRequest
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final Date requestTime = new Date();
    private long completionTime;
    private final String url;
    private final String method;
    private final String queryString;
    private int status = 0;
    private final Map<String, String[]> parameterMap;
    private WrappedException exception;
    private final String sourceRevision;

    public AnalyticsHttpRequest(String method, String url, String queryString, Map<String, String[]> parameterMap, String sourceRevision) {
        this.method = method;
        this.url = url;
        this.queryString = queryString;
        this.parameterMap = new HashMap<String, String[]>();
        this.parameterMap.putAll(parameterMap);
        if (queryString != null) {
            Pattern pattern = Pattern.compile("(\\w+)=");
            Matcher matcher = pattern.matcher(queryString);
            while (matcher.find()) {
                this.parameterMap.remove(matcher.group(1));
            }
        }
        this.sourceRevision = sourceRevision;
    }

    public Date getRequestTime() {
        return this.requestTime;
    }

    public String getMethod() {
        return this.method;
    }

    public String getUrl() {
        return this.url;
    }

    public String getUrlWithQueryString() {
        return this.url + (this.queryString != null ? "?" + this.queryString : "");
    }

    public String getQueryString() {
        return this.queryString;
    }

    public Map<String, String[]> getParameterMap() {
        return this.parameterMap;
    }

    public void setCompletionTime(long completionTime) {
        this.completionTime = completionTime;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public int getStatus() {
        return this.status;
    }

    public WrappedException getWrappedException() {
        return this.exception;
    }

    public String getSourceRevision() {
        return this.sourceRevision;
    }

    public void setException(Exception exception) {
        this.exception = new WrappedException(exception);
    }

    public String toString() {
        StringBuilder url = new StringBuilder(new SimpleDateFormat("MM-dd-yyyy h:mm:ss a").format(this.requestTime));
        url.append(" (");
        url.append(this.getMethod());
        url.append(") - ");
        url.append(this.getUrlWithQueryString());
        url.append(" ");
        Iterator<Map.Entry<String, String[]>> it = this.getParameterMap().entrySet().iterator();
        while (it.hasNext()) {
            url.append('{');
            Map.Entry<String, String[]> entry = it.next();
            url.append(entry.getKey());
            url.append(":");
            int i = 0;
            while (i < entry.getValue().length) {
                url.append(entry.getValue()[i]);
                if (i++ >= entry.getValue().length) continue;
                url.append(',');
            }
            url.deleteCharAt(url.length() - 1);
            url.append("}");
        }
        url.append(" (" + this.getStatus() + " - " + (this.completionTime - this.requestTime.getTime()) + " ms)");
        return url.toString();
    }

    public String toHtmlString() {
        String s = this.toString();
        int start = s.indexOf(") -") + 4;
        StringBuilder url = new StringBuilder();
        url.append(s.substring(0, start));
        url.append("<a href=\"");
        url.append(this.getUrlWithQueryString());
        url.append("\">");
        url.append(this.getUrlWithQueryString());
        url.append("</a>");
        url.append(s.substring(s.indexOf(" ", start)));
        return url.toString();
    }
}

