/*
 * Decompiled with CFR 0.152.
 */
package org.codeconsole.web.analytics;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.util.Date;

public class WrappedException
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final Exception exception;
    private final String fileName;
    private final String methodName;
    private final Integer lineNumber;
    private final String stackTrace;
    private final Date timeStamp;

    public WrappedException(Exception exception) {
        this.exception = exception;
        this.timeStamp = new Date();
        StackTraceElement[] stack = exception.getStackTrace();
        if (stack.length > 0) {
            this.fileName = stack[0].getFileName();
            this.methodName = stack[0].getMethodName();
            this.lineNumber = stack[0].getLineNumber();
        } else {
            this.fileName = null;
            this.methodName = null;
            this.lineNumber = null;
        }
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        exception.printStackTrace(pw);
        this.stackTrace = sw.toString();
        pw.close();
        try {
            sw.close();
        }
        catch (IOException ex) {
            // empty catch block
        }
    }

    public Exception getException() {
        return this.exception;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public Integer getLineNumber() {
        return this.lineNumber;
    }

    public String getStackTrace() {
        return this.stackTrace;
    }

    public Date getTimeStamp() {
        return this.timeStamp;
    }
}

