/*
 * Decompiled with CFR 0.152.
 */
package bitronix.tm;

import bitronix.tm.BitronixTransaction;
import bitronix.tm.BitronixTransactionManagerObjectFactory;
import bitronix.tm.Configuration;
import bitronix.tm.TransactionManagerServices;
import bitronix.tm.Version;
import bitronix.tm.internal.BitronixSystemException;
import bitronix.tm.internal.ThreadContext;
import bitronix.tm.internal.XAResourceManager;
import bitronix.tm.utils.ClassLoaderUtils;
import bitronix.tm.utils.Decoder;
import bitronix.tm.utils.InitializationException;
import bitronix.tm.utils.MonotonicClock;
import bitronix.tm.utils.Scheduler;
import bitronix.tm.utils.Service;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.NoSuchElementException;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicReference;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.InvalidTransactionException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.UserTransaction;
import javax.transaction.xa.XAException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BitronixTransactionManager
implements TransactionManager,
UserTransaction,
Referenceable,
Service {
    private static final Logger log = LoggerFactory.getLogger(BitronixTransactionManager.class);
    private static final String MDC_GTRID_KEY = "btm-gtrid";
    private final SortedMap<BitronixTransaction, ClearContextSynchronization> inFlightTransactions;
    private volatile boolean shuttingDown;

    public BitronixTransactionManager() {
        try {
            this.shuttingDown = false;
            this.logVersion();
            Configuration configuration = TransactionManagerServices.getConfiguration();
            configuration.buildServerIdArray();
            if (log.isDebugEnabled()) {
                log.debug("starting BitronixTransactionManager using " + configuration);
            }
            TransactionManagerServices.getJournal().open();
            TransactionManagerServices.getResourceLoader().init();
            TransactionManagerServices.getRecoverer().run();
            int backgroundRecoveryInterval = TransactionManagerServices.getConfiguration().getBackgroundRecoveryIntervalSeconds();
            if (backgroundRecoveryInterval < 1) {
                throw new InitializationException("invalid configuration value for backgroundRecoveryIntervalSeconds, found '" + backgroundRecoveryInterval + "' but it must be greater than 0");
            }
            this.inFlightTransactions = this.createInFlightTransactionsMap();
            if (log.isDebugEnabled()) {
                log.debug("recovery will run in the background every " + backgroundRecoveryInterval + " second(s)");
            }
            Date nextExecutionDate = new Date(MonotonicClock.currentTimeMillis() + (long)backgroundRecoveryInterval * 1000L);
            TransactionManagerServices.getTaskScheduler().scheduleRecovery(TransactionManagerServices.getRecoverer(), nextExecutionDate);
        }
        catch (IOException ex) {
            throw new InitializationException("cannot open disk journal", ex);
        }
        catch (Exception ex) {
            TransactionManagerServices.getJournal().shutdown();
            TransactionManagerServices.getResourceLoader().shutdown();
            throw new InitializationException("initialization failed, cannot safely start the transaction manager", ex);
        }
    }

    private SortedMap<BitronixTransaction, ClearContextSynchronization> createInFlightTransactionsMap() throws InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        boolean debug = log.isDebugEnabled();
        if (debug) {
            log.debug("Creating sorted memory storage for inflight transactions.");
        }
        Comparator<BitronixTransaction> timestampSortComparator = new Comparator<BitronixTransaction>(){

            @Override
            public int compare(BitronixTransaction t1, BitronixTransaction t2) {
                Long timestamp2;
                Long timestamp1 = t1.getResourceManager().getGtrid().extractTimestamp();
                int compareTo = timestamp1.compareTo(timestamp2 = Long.valueOf(t2.getResourceManager().getGtrid().extractTimestamp()));
                if (compareTo == 0 && !t1.getResourceManager().getGtrid().equals(t2.getResourceManager().getGtrid())) {
                    return t1.getGtrid().compareTo(t2.getGtrid());
                }
                return compareTo;
            }
        };
        if (debug) {
            log.debug("Attempting to use a concurrent sorted map of type 'ConcurrentSkipListMap' (from jre6 or custom supplied backport)");
        }
        try {
            SortedMap mapInstance = (SortedMap)ClassLoaderUtils.loadClass("java.util.concurrent.ConcurrentSkipListMap").getConstructor(Comparator.class).newInstance(timestampSortComparator);
            return mapInstance;
        }
        catch (ClassNotFoundException e) {
            if (debug) {
                log.debug("Concurrent sorted map 'ConcurrentSkipListMap' is not available. Falling back to a synchronized TreeMap.");
            }
            return Collections.synchronizedSortedMap(new TreeMap(timestampSortComparator));
        }
    }

    public void begin() throws NotSupportedException, SystemException {
        BitronixTransaction currentTx;
        if (log.isDebugEnabled()) {
            log.debug("beginning a new transaction");
        }
        if (this.isShuttingDown()) {
            throw new BitronixSystemException("cannot start a new transaction, transaction manager is shutting down");
        }
        if (log.isDebugEnabled()) {
            this.dumpTransactionContexts();
        }
        if ((currentTx = this.getCurrentTransaction()) != null) {
            throw new NotSupportedException("nested transactions not supported");
        }
        currentTx = this.createTransaction();
        ThreadContext threadContext = ThreadContext.getThreadContext();
        ClearContextSynchronization clearContextSynchronization = new ClearContextSynchronization(currentTx, threadContext);
        try {
            currentTx.getSynchronizationScheduler().add(clearContextSynchronization, Scheduler.ALWAYS_LAST_POSITION - 1);
            currentTx.setActive(threadContext.getTimeout());
            this.inFlightTransactions.put(currentTx, clearContextSynchronization);
            if (log.isDebugEnabled()) {
                log.debug("begun new transaction at " + new Date(currentTx.getResourceManager().getGtrid().extractTimestamp()));
            }
        }
        catch (RuntimeException ex) {
            clearContextSynchronization.afterCompletion(6);
            throw ex;
        }
        catch (SystemException ex) {
            clearContextSynchronization.afterCompletion(6);
            throw ex;
        }
    }

    public void commit() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, IllegalStateException, SystemException {
        BitronixTransaction currentTx = this.getCurrentTransaction();
        if (log.isDebugEnabled()) {
            log.debug("committing transaction " + currentTx);
        }
        if (currentTx == null) {
            throw new IllegalStateException("no transaction started on this thread");
        }
        currentTx.commit();
    }

    public void rollback() throws IllegalStateException, SecurityException, SystemException {
        BitronixTransaction currentTx = this.getCurrentTransaction();
        if (log.isDebugEnabled()) {
            log.debug("rolling back transaction " + currentTx);
        }
        if (currentTx == null) {
            throw new IllegalStateException("no transaction started on this thread");
        }
        currentTx.rollback();
    }

    public int getStatus() throws SystemException {
        BitronixTransaction currentTx = this.getCurrentTransaction();
        if (currentTx == null) {
            return 6;
        }
        return currentTx.getStatus();
    }

    public Transaction getTransaction() throws SystemException {
        return this.getCurrentTransaction();
    }

    public void setRollbackOnly() throws IllegalStateException, SystemException {
        BitronixTransaction currentTx = this.getCurrentTransaction();
        if (log.isDebugEnabled()) {
            log.debug("marking transaction as rollback only: " + currentTx);
        }
        if (currentTx == null) {
            throw new IllegalStateException("no transaction started on this thread");
        }
        currentTx.setRollbackOnly();
    }

    public void setTransactionTimeout(int seconds) throws SystemException {
        if (seconds < 0) {
            throw new BitronixSystemException("cannot set a timeout to less than 0 second (was: " + seconds + "s)");
        }
        ThreadContext.getThreadContext().setTimeout(seconds);
    }

    public Transaction suspend() throws SystemException {
        BitronixTransaction currentTx = this.getCurrentTransaction();
        if (log.isDebugEnabled()) {
            log.debug("suspending transaction " + currentTx);
        }
        if (currentTx == null) {
            return null;
        }
        try {
            currentTx.getResourceManager().suspend();
            this.clearCurrentContextForSuspension();
            ((ClearContextSynchronization)this.inFlightTransactions.get(currentTx)).setThreadContext(null);
            MDC.remove((String)MDC_GTRID_KEY);
            return currentTx;
        }
        catch (XAException ex) {
            String extraErrorDetails = TransactionManagerServices.getExceptionAnalyzer().extractExtraXAExceptionDetails(ex);
            throw new BitronixSystemException("cannot suspend " + currentTx + ", error=" + Decoder.decodeXAExceptionErrorCode(ex) + (extraErrorDetails == null ? "" : ", extra error=" + extraErrorDetails), ex);
        }
    }

    public void resume(Transaction transaction) throws InvalidTransactionException, IllegalStateException, SystemException {
        if (log.isDebugEnabled()) {
            log.debug("resuming " + transaction);
        }
        if (transaction == null) {
            throw new InvalidTransactionException("resumed transaction cannot be null");
        }
        if (!(transaction instanceof BitronixTransaction)) {
            throw new InvalidTransactionException("resumed transaction must be an instance of BitronixTransaction");
        }
        BitronixTransaction tx = (BitronixTransaction)transaction;
        if (this.getCurrentTransaction() != null) {
            throw new IllegalStateException("a transaction is already running on this thread");
        }
        try {
            XAResourceManager resourceManager = tx.getResourceManager();
            resourceManager.resume();
            ThreadContext threadContext = ThreadContext.getThreadContext();
            threadContext.setTransaction(tx);
            ((ClearContextSynchronization)this.inFlightTransactions.get(tx)).setThreadContext(threadContext);
            MDC.put((String)MDC_GTRID_KEY, (String)tx.getGtrid());
        }
        catch (XAException ex) {
            String extraErrorDetails = TransactionManagerServices.getExceptionAnalyzer().extractExtraXAExceptionDetails(ex);
            throw new BitronixSystemException("cannot resume " + tx + ", error=" + Decoder.decodeXAExceptionErrorCode(ex) + (extraErrorDetails == null ? "" : ", extra error=" + extraErrorDetails), ex);
        }
    }

    @Override
    public Reference getReference() throws NamingException {
        return new Reference(BitronixTransactionManager.class.getName(), new StringRefAddr("TransactionManager", "BitronixTransactionManager"), BitronixTransactionManagerObjectFactory.class.getName(), null);
    }

    public int getInFlightTransactionCount() {
        return this.inFlightTransactions.size();
    }

    public long getOldestInFlightTransactionTimestamp() {
        try {
            BitronixTransaction oldestTransaction = this.inFlightTransactions.firstKey();
            long oldestTimestamp = oldestTransaction.getResourceManager().getGtrid().extractTimestamp();
            if (log.isDebugEnabled()) {
                log.debug("oldest in-flight transaction's timestamp: " + oldestTimestamp);
            }
            return oldestTimestamp;
        }
        catch (NoSuchElementException e) {
            if (log.isDebugEnabled()) {
                log.debug("oldest in-flight transaction's timestamp: -9223372036854775808");
            }
            return Long.MIN_VALUE;
        }
    }

    public BitronixTransaction getCurrentTransaction() {
        return ThreadContext.getThreadContext().getTransaction();
    }

    private boolean isShuttingDown() {
        return this.shuttingDown;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dumpTransactionContexts() {
        if (!log.isDebugEnabled()) {
            return;
        }
        SortedMap<BitronixTransaction, ClearContextSynchronization> sortedMap = this.inFlightTransactions;
        synchronized (sortedMap) {
            log.debug("dumping " + this.inFlightTransactions.size() + " transaction context(s)");
            for (BitronixTransaction tx : this.inFlightTransactions.keySet()) {
                log.debug(tx.toString());
            }
        }
    }

    @Override
    public synchronized void shutdown() {
        if (this.isShuttingDown()) {
            if (log.isDebugEnabled()) {
                log.debug("Transaction Manager has already shut down");
            }
            return;
        }
        log.info("shutting down Bitronix Transaction Manager");
        this.internalShutdown();
        if (log.isDebugEnabled()) {
            log.debug("shutting down resource loader");
        }
        TransactionManagerServices.getResourceLoader().shutdown();
        if (log.isDebugEnabled()) {
            log.debug("shutting down executor");
        }
        TransactionManagerServices.getExecutor().shutdown();
        if (log.isDebugEnabled()) {
            log.debug("shutting down task scheduler");
        }
        TransactionManagerServices.getTaskScheduler().shutdown();
        if (log.isDebugEnabled()) {
            log.debug("shutting down journal");
        }
        TransactionManagerServices.getJournal().shutdown();
        if (log.isDebugEnabled()) {
            log.debug("shutting down recoverer");
        }
        TransactionManagerServices.getRecoverer().shutdown();
        if (log.isDebugEnabled()) {
            log.debug("shutting down configuration");
        }
        TransactionManagerServices.getConfiguration().shutdown();
        TransactionManagerServices.clear();
        if (log.isDebugEnabled()) {
            log.debug("shutdown ran successfully");
        }
    }

    private void internalShutdown() {
        this.shuttingDown = true;
        this.dumpTransactionContexts();
        int txCount = 0;
        try {
            txCount = this.inFlightTransactions.size();
            for (int seconds = TransactionManagerServices.getConfiguration().getGracefulShutdownInterval(); seconds > 0 && txCount > 0; --seconds) {
                if (log.isDebugEnabled()) {
                    log.debug("still " + txCount + " in-flight transactions, waiting... (" + seconds + " second(s) left)");
                }
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException ex) {
                    // empty catch block
                }
                txCount = this.inFlightTransactions.size();
            }
        }
        catch (Exception ex) {
            log.error("cannot get a list of in-flight transactions", (Throwable)ex);
        }
        if (txCount > 0) {
            if (log.isDebugEnabled()) {
                log.debug("still " + txCount + " in-flight transactions, shutting down anyway");
                this.dumpTransactionContexts();
            }
        } else if (log.isDebugEnabled()) {
            log.debug("all transactions finished, resuming shutdown");
        }
    }

    public String toString() {
        return "a BitronixTransactionManager with " + this.inFlightTransactions.size() + " in-flight transaction(s)";
    }

    private void logVersion() {
        log.info("Bitronix Transaction Manager version " + Version.getVersion());
        if (log.isDebugEnabled()) {
            log.debug("JVM version " + System.getProperty("java.version"));
        }
    }

    private BitronixTransaction createTransaction() {
        BitronixTransaction transaction = new BitronixTransaction();
        ThreadContext.getThreadContext().setTransaction(transaction);
        MDC.put((String)MDC_GTRID_KEY, (String)transaction.getGtrid());
        return transaction;
    }

    private void clearCurrentContextForSuspension() {
        if (log.isDebugEnabled()) {
            log.debug("clearing current thread context: " + ThreadContext.getThreadContext());
        }
        ThreadContext.getThreadContext().clearTransaction();
    }

    private final class ClearContextSynchronization
    implements Synchronization {
        private final BitronixTransaction currentTx;
        private AtomicReference<ThreadContext> threadContext;

        public ClearContextSynchronization(BitronixTransaction currentTx, ThreadContext threadContext) {
            this.currentTx = currentTx;
            this.threadContext = new AtomicReference<ThreadContext>(threadContext);
        }

        public void beforeCompletion() {
        }

        public void afterCompletion(int status) {
            ThreadContext context = this.threadContext.get();
            if (context != null) {
                if (log.isDebugEnabled()) {
                    log.debug("clearing transaction from thread context: " + context);
                }
                context.clearTransaction();
            } else if (log.isDebugEnabled()) {
                log.debug("thread context was null when clear context synchronization executed");
            }
            if (log.isDebugEnabled()) {
                log.debug("removing transaction from in-flight transactions: " + this.currentTx);
            }
            BitronixTransactionManager.this.inFlightTransactions.remove(this.currentTx);
            MDC.remove((String)BitronixTransactionManager.MDC_GTRID_KEY);
        }

        public void setThreadContext(ThreadContext threadContext) {
            this.threadContext.set(threadContext);
        }

        public String toString() {
            return "a ClearContextSynchronization for " + this.currentTx;
        }
    }
}

