/*
 * Decompiled with CFR 0.152.
 */
package bitronix.tm.gui;

import bitronix.tm.Configuration;
import bitronix.tm.TransactionManagerServices;
import bitronix.tm.gui.DuplicatedGtridTableModel;
import bitronix.tm.gui.PendingTransactionTableModel;
import bitronix.tm.gui.RawTransactionTableModel;
import bitronix.tm.gui.ResourcesPanel;
import bitronix.tm.gui.TransactionLogHeaderPanel;
import bitronix.tm.gui.TransactionTableCellRenderer;
import bitronix.tm.gui.TransactionTableModel;
import bitronix.tm.gui.TransactionTableMouseListener;
import bitronix.tm.journal.TransactionLogRecord;
import bitronix.tm.utils.Uid;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JViewport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Console
extends JFrame {
    private static final Logger log = LoggerFactory.getLogger(Console.class);
    protected static final SimpleDateFormat dateFormatter = new SimpleDateFormat("dd-MM-yyyy HH:mm:ss.SSS");
    private JTabbedPane tabbedPane = new JTabbedPane();
    private JTable rawViewTransactionsTable = new JTable();
    private JTable pendingViewTransactionsTable = new JTable();
    private JScrollPane rawTransactionsTableScrollpane = new JScrollPane(this.rawViewTransactionsTable);
    private JScrollPane pendingTransactionsTableScrollpane = new JScrollPane(this.pendingViewTransactionsTable);
    private ResourcesPanel resourcesPanel = new ResourcesPanel();
    private JPanel statusBarPanel = new JPanel();
    private JLabel statusLabel = new JLabel();
    private TransactionLogHeaderPanel transactionLogHeaderPanel1 = new TransactionLogHeaderPanel();
    private TransactionLogHeaderPanel transactionLogHeaderPanel2 = new TransactionLogHeaderPanel();
    private JMenuBar menuBar = new JMenuBar();
    private File activeLogFile;
    private File passiveLogFile;
    private File realActiveLogFile;

    public Console() throws IOException {
        final Configuration configuration = TransactionManagerServices.getConfiguration();
        JMenu findMenu = new JMenu("Find");
        this.menuBar.add(findMenu);
        JMenuItem bySequenceItem = new JMenuItem("First by sequence");
        JMenuItem byGtridItem = new JMenuItem("First by GTRID");
        findMenu.add(bySequenceItem);
        findMenu.add(byGtridItem);
        JMenu analysisMenu = new JMenu("Analysis");
        this.menuBar.add(analysisMenu);
        JMenuItem switchLogFilesItem = new JMenuItem("Switch log files");
        analysisMenu.add(switchLogFilesItem);
        JMenuItem countDuplicatedGtridsItem = new JMenuItem("Count duplicated GTRID");
        analysisMenu.add(countDuplicatedGtridsItem);
        JMenuItem countByStatus = new JMenuItem("Count by status");
        analysisMenu.add(countByStatus);
        this.transactionLogHeaderPanel1.read(this.getActiveLogFile(configuration), true);
        this.transactionLogHeaderPanel2.read(this.getPassiveLogFile(configuration), false);
        this.pendingViewTransactionsTable.setModel(new PendingTransactionTableModel(this.getActiveLogFile(configuration)));
        this.pendingViewTransactionsTable.addMouseListener(new TransactionTableMouseListener(this, this.pendingViewTransactionsTable));
        this.rawViewTransactionsTable.setDefaultRenderer(String.class, new TransactionTableCellRenderer());
        this.rawViewTransactionsTable.setModel(new RawTransactionTableModel(this.getActiveLogFile(configuration)));
        this.rawViewTransactionsTable.addMouseListener(new TransactionTableMouseListener(this, this.rawViewTransactionsTable));
        final JPopupMenu rawViewTransactionsTablePopupMenu = new JPopupMenu();
        final JCheckBoxMenuItem filterByGtridItem = new JCheckBoxMenuItem("Filter by GTRID");
        filterByGtridItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Console.this.filterByGtrid(filterByGtridItem.isSelected());
            }
        });
        rawViewTransactionsTablePopupMenu.add(filterByGtridItem);
        this.rawViewTransactionsTable.addMouseListener(new MouseListener(){

            public void mouseClicked(MouseEvent e) {
            }

            public void mouseEntered(MouseEvent e) {
            }

            public void mouseExited(MouseEvent e) {
            }

            public void mousePressed(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    rawViewTransactionsTablePopupMenu.show(e.getComponent(), e.getX(), e.getY());
                    int row = Console.this.rawViewTransactionsTable.rowAtPoint(new Point(e.getX(), e.getY()));
                    Console.this.selectTableRow(Console.this.rawViewTransactionsTable, row);
                }
            }

            public void mouseReleased(MouseEvent e) {
                this.mousePressed(e);
            }
        });
        this.tabbedPane.add("Pending logs", this.pendingTransactionsTableScrollpane);
        this.tabbedPane.add("Raw logs", this.rawTransactionsTableScrollpane);
        this.tabbedPane.add("Resources", this.resourcesPanel);
        this.refreshStatus();
        this.statusBarPanel.setLayout(new GridLayout(3, 1, 1, 1));
        this.statusBarPanel.setBorder(BorderFactory.createEtchedBorder(0));
        this.statusBarPanel.add(this.transactionLogHeaderPanel1);
        this.statusBarPanel.add(this.transactionLogHeaderPanel2);
        this.statusBarPanel.add(this.statusLabel);
        switchLogFilesItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Console.this.switchLogFiles(configuration);
            }
        });
        countDuplicatedGtridsItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Console.this.countDuplicatedGtrids();
            }
        });
        countByStatus.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Console.this.countByStatus();
            }
        });
        bySequenceItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Console.this.findBySequence();
            }
        });
        byGtridItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Console.this.findByGtrid();
            }
        });
        this.setTitle("Bitronix Transaction Manager Console");
        this.setJMenuBar(this.menuBar);
        this.getContentPane().setLayout(new BorderLayout(0, 2));
        this.getContentPane().add((Component)this.tabbedPane, "Center");
        this.getContentPane().add((Component)this.statusBarPanel, "South");
        this.setDefaultCloseOperation(3);
        this.setSize(800, 600);
        this.setVisible(true);
    }

    private File getActiveLogFile(Configuration configuration) throws IOException {
        if (this.activeLogFile == null) {
            this.realActiveLogFile = this.activeLogFile = Console.pickCurrentLogFile(new File(configuration.getLogPart1Filename()), new File(configuration.getLogPart2Filename()));
            if (log.isDebugEnabled()) {
                log.debug("active file is " + this.activeLogFile.getName());
            }
        }
        return this.activeLogFile;
    }

    public static File pickCurrentLogFile(File file1, File file2) throws IOException {
        RandomAccessFile activeRandomAccessFile = new RandomAccessFile(file1, "r");
        int formatId1 = activeRandomAccessFile.readInt();
        if (formatId1 != 1114926712) {
            throw new IOException("log file 1 " + file1.getName() + " is not a Bitronix Log file (incorrect header)");
        }
        long timestamp1 = activeRandomAccessFile.readLong();
        activeRandomAccessFile.close();
        activeRandomAccessFile = new RandomAccessFile(file2, "r");
        int formatId2 = activeRandomAccessFile.readInt();
        if (formatId2 != 1114926712) {
            throw new IOException("log file 2 " + file2.getName() + " is not a Bitronix Log file (incorrect header)");
        }
        long timestamp2 = activeRandomAccessFile.readLong();
        activeRandomAccessFile.close();
        if (timestamp1 > timestamp2) {
            return file1;
        }
        return file2;
    }

    private File getPassiveLogFile(Configuration configuration) throws IOException {
        if (this.passiveLogFile == null) {
            this.passiveLogFile = this.getActiveLogFile(configuration).getName().equals(configuration.getLogPart1Filename()) ? new File(configuration.getLogPart2Filename()) : new File(configuration.getLogPart1Filename());
        }
        return this.passiveLogFile;
    }

    private void refreshStatus() {
        this.statusLabel.setText("active log file is " + this.realActiveLogFile.getName() + " - displayed log file contains " + this.pendingViewTransactionsTable.getModel().getRowCount() + " dangling transaction log(s) over " + this.rawViewTransactionsTable.getModel().getRowCount() + " total transaction log(s)");
    }

    private void switchLogFiles(Configuration configuration) {
        File temp = this.activeLogFile;
        this.activeLogFile = this.passiveLogFile;
        this.passiveLogFile = temp;
        File realPassive = this.activeLogFile == this.realActiveLogFile ? this.passiveLogFile : this.activeLogFile;
        try {
            this.transactionLogHeaderPanel1.read(this.realActiveLogFile, configuration.getLogPart1Filename().equals(this.activeLogFile.getName()));
            this.transactionLogHeaderPanel2.read(realPassive, configuration.getLogPart2Filename().equals(this.activeLogFile.getName()));
            this.pendingViewTransactionsTable.setModel(new PendingTransactionTableModel(this.getActiveLogFile(configuration)));
            this.rawViewTransactionsTable.setModel(new RawTransactionTableModel(this.getActiveLogFile(configuration)));
            this.refreshStatus();
        }
        catch (IOException ex) {
            JOptionPane.showMessageDialog(this, "Reloading model of switched logs failed. Try again.", "Error", 0);
        }
    }

    private void countDuplicatedGtrids() {
        TransactionTableModel transactionTableModel = (TransactionTableModel)this.rawViewTransactionsTable.getModel();
        HashMap gtrids = new HashMap();
        HashMap redundantGtrids = new HashMap();
        for (int i = 0; i < transactionTableModel.getRowCount(); ++i) {
            List<TransactionLogRecord> tlogs;
            TransactionLogRecord tlog = transactionTableModel.getRow(i);
            if (tlog.getStatus() != 8) continue;
            Uid gtrid = tlog.getGtrid();
            if (gtrids.containsKey(gtrid)) {
                tlogs = (List)gtrids.get(gtrid);
                tlogs.add(tlog);
                redundantGtrids.put(gtrid, tlogs);
                continue;
            }
            tlogs = new ArrayList();
            tlogs.add(tlog);
            gtrids.put(gtrid, tlogs);
        }
        JTable table = new JTable(new DuplicatedGtridTableModel(redundantGtrids));
        JScrollPane scrollPane = new JScrollPane(table);
        JDialog dialog = new JDialog((Frame)this, redundantGtrids.size() + " duplicated GTRIDs found");
        dialog.getContentPane().add(scrollPane);
        dialog.pack();
        dialog.setModal(false);
        dialog.setVisible(true);
    }

    private void countByStatus() {
        TransactionTableModel transactionTableModel = (TransactionTableModel)this.rawViewTransactionsTable.getModel();
        int preparing = 0;
        int prepared = 0;
        int rollingback = 0;
        int rolledback = 0;
        int committing = 0;
        int committed = 0;
        int active = 0;
        int unknown = 0;
        block9: for (int i = 0; i < transactionTableModel.getRowCount(); ++i) {
            TransactionLogRecord tlog = transactionTableModel.getRow(i);
            switch (tlog.getStatus()) {
                case 0: {
                    ++active;
                    continue block9;
                }
                case 7: {
                    ++preparing;
                    continue block9;
                }
                case 2: {
                    ++prepared;
                    continue block9;
                }
                case 8: {
                    ++committing;
                    continue block9;
                }
                case 3: {
                    ++committed;
                    continue block9;
                }
                case 9: {
                    ++rollingback;
                    continue block9;
                }
                case 4: {
                    ++rolledback;
                    continue block9;
                }
                default: {
                    ++unknown;
                }
            }
        }
        String message = "Active: " + active + "\n" + "Preparing: " + preparing + "\n" + "Prepared: " + prepared + "\n" + "Committing: " + committing + "\n" + "Committed: " + committed + "\n" + "Rolling back: " + rollingback + "\n" + "Rolled back: " + rolledback;
        if (unknown > 0) {
            message = message + "\nUnknown: " + unknown;
        }
        JOptionPane.showMessageDialog(this, message, "Count by status", 1);
    }

    private void findBySequence() {
        int searchedSequence;
        String sequence = JOptionPane.showInputDialog(this, (Object)"Enter sequence to search for");
        try {
            searchedSequence = new Integer(sequence);
        }
        catch (NumberFormatException ex) {
            JOptionPane.showMessageDialog(this, "Please input a number", "Find by sequence", 0);
            return;
        }
        if (this.tabbedPane.getSelectedComponent() == this.pendingTransactionsTableScrollpane) {
            TransactionTableModel transactionTableModel = (TransactionTableModel)this.pendingViewTransactionsTable.getModel();
            this.selectTLogMatchingSequence(transactionTableModel, searchedSequence, this.pendingViewTransactionsTable);
        } else {
            TransactionTableModel transactionTableModel = (TransactionTableModel)this.rawViewTransactionsTable.getModel();
            this.selectTLogMatchingSequence(transactionTableModel, searchedSequence, this.rawViewTransactionsTable);
        }
    }

    private void findByGtrid() {
        String gtrid = JOptionPane.showInputDialog(this, (Object)"Enter GTRID to search for");
        if (this.tabbedPane.getSelectedComponent() == this.pendingTransactionsTableScrollpane) {
            TransactionTableModel transactionTableModel = (TransactionTableModel)this.pendingViewTransactionsTable.getModel();
            this.selectTLogMatchingGtrid(transactionTableModel, gtrid, this.pendingViewTransactionsTable);
        } else {
            TransactionTableModel transactionTableModel = (TransactionTableModel)this.rawViewTransactionsTable.getModel();
            this.selectTLogMatchingGtrid(transactionTableModel, gtrid, this.rawViewTransactionsTable);
        }
    }

    private void filterByGtrid(boolean filter) {
        RawTransactionTableModel model = (RawTransactionTableModel)this.rawViewTransactionsTable.getModel();
        if (filter) {
            int selectedRow = this.rawViewTransactionsTable.getSelectedRow();
            String gtrid = (String)model.getValueAt(selectedRow, 7);
            model.filterByGtrid(gtrid);
        } else {
            model.filterByGtrid(null);
        }
        this.rawViewTransactionsTable.repaint();
    }

    private void selectTLogMatchingSequence(TransactionTableModel transactionTableModel, int sequenceNumber, JTable table) {
        TransactionLogRecord tlog;
        int i;
        int startIndex = table.getSelectedRow() + 1;
        Integer sequence = sequenceNumber;
        for (i = startIndex; i < transactionTableModel.getRowCount(); ++i) {
            tlog = transactionTableModel.getRow(i);
            if (!((Object)sequence).equals(tlog.getRecordProperties().get("sequenceNumber"))) continue;
            this.selectTableRow(table, i);
            return;
        }
        if (startIndex > 0) {
            for (i = 0; i < startIndex; ++i) {
                tlog = transactionTableModel.getRow(i);
                if (!((Object)sequence).equals(tlog.getRecordProperties().get("sequenceNumber"))) continue;
                this.selectTableRow(table, i);
                return;
            }
        }
        JOptionPane.showMessageDialog(this, "Not found", "Find by sequence", 1);
    }

    private void selectTLogMatchingGtrid(TransactionTableModel transactionTableModel, String gtrid, JTable table) {
        TransactionLogRecord tlog;
        int startIndex;
        int i;
        for (i = startIndex = table.getSelectedRow() + 1; i < transactionTableModel.getRowCount(); ++i) {
            tlog = transactionTableModel.getRow(i);
            if (!tlog.getGtrid().toString().equals(gtrid)) continue;
            this.selectTableRow(table, i);
            return;
        }
        if (startIndex > 0) {
            for (i = 0; i < startIndex; ++i) {
                tlog = transactionTableModel.getRow(i);
                if (!tlog.getGtrid().toString().equals(gtrid)) continue;
                this.selectTableRow(table, i);
                return;
            }
        }
        JOptionPane.showMessageDialog(this, "Not found", "Find by GTRID", 1);
    }

    private void selectTableRow(JTable table, int rowNum) {
        if (rowNum == -1) {
            return;
        }
        table.setRowSelectionInterval(rowNum, rowNum);
        JViewport viewport = (JViewport)table.getParent();
        Rectangle rect = table.getCellRect(rowNum, 0, true);
        Rectangle viewRect = viewport.getViewRect();
        rect.setLocation(rect.x - viewRect.x, rect.y - viewRect.y);
        viewport.scrollRectToVisible(rect);
    }

    public static void main(String[] args) throws Exception {
        try {
            new Console();
        }
        catch (IOException ex) {
            JOptionPane.showMessageDialog(null, ex.getMessage(), "Error", 0);
            ex.printStackTrace();
        }
    }
}

