/*
 * Decompiled with CFR 0.152.
 */
package bitronix.tm.resource.jdbc;

import bitronix.tm.internal.XAResourceHolderState;
import bitronix.tm.recovery.RecoveryException;
import bitronix.tm.resource.ResourceConfigurationException;
import bitronix.tm.resource.ResourceObjectFactory;
import bitronix.tm.resource.ResourceRegistrar;
import bitronix.tm.resource.common.RecoveryXAResourceHolder;
import bitronix.tm.resource.common.ResourceBean;
import bitronix.tm.resource.common.XAPool;
import bitronix.tm.resource.common.XAResourceHolder;
import bitronix.tm.resource.common.XAResourceProducer;
import bitronix.tm.resource.common.XAStatefulHolder;
import bitronix.tm.resource.jdbc.ConnectionCustomizer;
import bitronix.tm.resource.jdbc.JdbcPooledConnection;
import bitronix.tm.resource.jdbc.PooledConnectionProxy;
import bitronix.tm.resource.jdbc.PoolingDataSourceMBean;
import bitronix.tm.utils.ManagementRegistrar;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import javax.sql.DataSource;
import javax.sql.XADataSource;
import javax.transaction.xa.XAResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PoolingDataSource
extends ResourceBean
implements DataSource,
XAResourceProducer,
PoolingDataSourceMBean {
    private static final Logger log = LoggerFactory.getLogger(PoolingDataSource.class);
    private volatile transient XAPool pool;
    private volatile transient XADataSource xaDataSource;
    private volatile transient RecoveryXAResourceHolder recoveryXAResourceHolder;
    private volatile transient Connection recoveryConnectionHandle;
    private volatile transient Map<XAResource, XAResourceHolder> xaResourceHolderMap;
    private volatile String testQuery;
    private volatile boolean enableJdbc4ConnectionTest;
    private volatile int preparedStatementCacheSize = 0;
    private volatile String isolationLevel;
    private volatile String cursorHoldability;
    private volatile String localAutoCommit;
    private volatile String jmxName;
    private final List<ConnectionCustomizer> connectionCustomizers = new CopyOnWriteArrayList<ConnectionCustomizer>();

    public PoolingDataSource() {
        this.xaResourceHolderMap = new ConcurrentHashMap<XAResource, XAResourceHolder>();
    }

    @Override
    public synchronized void init() {
        if (this.pool != null) {
            return;
        }
        try {
            this.buildXAPool();
            this.jmxName = "bitronix.tm:type=JDBC,UniqueName=" + ManagementRegistrar.makeValidName(this.getUniqueName());
            ManagementRegistrar.register(this.jmxName, this);
        }
        catch (Exception ex) {
            throw new ResourceConfigurationException("cannot create JDBC datasource named " + this.getUniqueName(), ex);
        }
    }

    private void buildXAPool() throws Exception {
        if (this.pool != null) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug("building XA pool for " + this.getUniqueName() + " with " + this.getMinPoolSize() + " connection(s)");
        }
        this.pool = new XAPool(this, this, this.xaDataSource);
        boolean builtXaFactory = false;
        if (this.xaDataSource == null) {
            this.xaDataSource = (XADataSource)this.pool.getXAFactory();
            builtXaFactory = true;
        }
        try {
            ResourceRegistrar.register(this);
        }
        catch (RecoveryException ex) {
            if (builtXaFactory) {
                this.xaDataSource = null;
            }
            this.pool = null;
            throw ex;
        }
    }

    public XADataSource getXaDataSource() {
        return this.xaDataSource;
    }

    public void setXaDataSource(XADataSource xaDataSource) {
        this.xaDataSource = xaDataSource;
    }

    public String getTestQuery() {
        return this.testQuery;
    }

    public void setTestQuery(String testQuery) {
        this.testQuery = testQuery;
    }

    public void setEnableJdbc4ConnectionTest(boolean enableJdbc4ConnectionTest) {
        this.enableJdbc4ConnectionTest = enableJdbc4ConnectionTest;
    }

    public boolean isEnableJdbc4ConnectionTest() {
        return this.enableJdbc4ConnectionTest;
    }

    public int getPreparedStatementCacheSize() {
        return this.preparedStatementCacheSize;
    }

    public void setPreparedStatementCacheSize(int preparedStatementCacheSize) {
        this.preparedStatementCacheSize = preparedStatementCacheSize;
    }

    public String getIsolationLevel() {
        return this.isolationLevel;
    }

    public void setIsolationLevel(String isolationLevel) {
        this.isolationLevel = isolationLevel;
    }

    public String getCursorHoldability() {
        return this.cursorHoldability;
    }

    public void setCursorHoldability(String cursorHoldability) {
        this.cursorHoldability = cursorHoldability;
    }

    public String getLocalAutoCommit() {
        return this.localAutoCommit;
    }

    public void setLocalAutoCommit(String localAutoCommit) {
        this.localAutoCommit = localAutoCommit;
    }

    public void addConnectionCustomizer(ConnectionCustomizer connectionCustomizer) {
        this.connectionCustomizers.add(connectionCustomizer);
    }

    public void removeConnectionCustomizer(ConnectionCustomizer connectionCustomizer) {
        Iterator<ConnectionCustomizer> it = this.connectionCustomizers.iterator();
        while (it.hasNext()) {
            ConnectionCustomizer customizer = it.next();
            if (customizer != connectionCustomizer) continue;
            it.remove();
            return;
        }
    }

    void fireOnAcquire(Connection connection) {
        for (ConnectionCustomizer connectionCustomizer : this.connectionCustomizers) {
            try {
                connectionCustomizer.onAcquire(connection, this.getUniqueName());
            }
            catch (Exception ex) {
                log.warn("ConnectionCustomizer.onAcquire() failed for " + connectionCustomizer, (Throwable)ex);
            }
        }
    }

    void fireOnDestroy(Connection connection) {
        for (ConnectionCustomizer connectionCustomizer : this.connectionCustomizers) {
            try {
                connectionCustomizer.onDestroy(connection, this.getUniqueName());
            }
            catch (Exception ex) {
                log.warn("ConnectionCustomizer.onDestroy() failed for " + connectionCustomizer, (Throwable)ex);
            }
        }
    }

    @Override
    public Connection getConnection() throws SQLException {
        if (this.isDisabled()) {
            throw new SQLException("JDBC connection pool '" + this.getUniqueName() + "' is disabled, cannot get a connection from it");
        }
        this.init();
        if (log.isDebugEnabled()) {
            log.debug("acquiring connection from " + this);
        }
        if (this.pool == null) {
            if (log.isDebugEnabled()) {
                log.debug("pool is closed, returning null connection");
            }
            return null;
        }
        try {
            Connection conn = (Connection)this.pool.getConnectionHandle();
            if (log.isDebugEnabled()) {
                log.debug("acquired connection from " + this);
            }
            return conn;
        }
        catch (Exception ex) {
            throw (SQLException)new SQLException("unable to get a connection from pool of " + this).initCause(ex);
        }
    }

    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        if (log.isDebugEnabled()) {
            log.debug("JDBC connections are pooled, username and password ignored");
        }
        return this.getConnection();
    }

    public String toString() {
        return "a PoolingDataSource containing " + this.pool;
    }

    @Override
    public XAResourceHolderState startRecovery() throws RecoveryException {
        this.init();
        if (this.recoveryConnectionHandle != null) {
            throw new RecoveryException("recovery already in progress on " + this);
        }
        try {
            this.recoveryConnectionHandle = (Connection)this.pool.getConnectionHandle(false);
            PooledConnectionProxy pooledConnection = (PooledConnectionProxy)((Object)this.recoveryConnectionHandle);
            this.recoveryXAResourceHolder = pooledConnection.getPooledConnection().createRecoveryXAResourceHolder();
            return new XAResourceHolderState(pooledConnection.getPooledConnection(), this);
        }
        catch (Exception ex) {
            throw new RecoveryException("cannot start recovery on " + this, ex);
        }
    }

    @Override
    public void endRecovery() throws RecoveryException {
        if (this.recoveryConnectionHandle == null) {
            return;
        }
        try {
            try {
                if (log.isDebugEnabled()) {
                    log.debug("recovery xa resource is being closed: " + this.recoveryXAResourceHolder);
                }
                this.recoveryConnectionHandle.close();
            }
            catch (Exception ex) {
                throw new RecoveryException("error ending recovery on " + this, ex);
            }
            Object var3_1 = null;
            this.recoveryConnectionHandle = null;
            this.recoveryXAResourceHolder = null;
        }
        catch (Throwable throwable) {
            Object var3_2 = null;
            this.recoveryConnectionHandle = null;
            this.recoveryXAResourceHolder = null;
            throw throwable;
        }
    }

    @Override
    public void setFailed(boolean failed) {
        if (this.pool != null) {
            this.pool.setFailed(failed);
        }
    }

    @Override
    public boolean isFailed() {
        return this.pool != null ? this.pool.isFailed() : false;
    }

    @Override
    public void close() {
        if (this.pool == null) {
            if (log.isDebugEnabled()) {
                log.debug("trying to close already closed PoolingDataSource " + this.getUniqueName());
            }
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug("closing " + this);
        }
        this.pool.close();
        this.pool = null;
        this.xaResourceHolderMap.clear();
        this.connectionCustomizers.clear();
        ManagementRegistrar.unregister(this.jmxName);
        this.jmxName = null;
        ResourceRegistrar.unregister(this);
    }

    @Override
    public XAStatefulHolder createPooledConnection(Object xaFactory, ResourceBean bean) throws Exception {
        if (!(xaFactory instanceof XADataSource)) {
            throw new IllegalArgumentException("class '" + xaFactory.getClass().getName() + "' does not implement " + XADataSource.class.getName());
        }
        XADataSource xads = (XADataSource)xaFactory;
        JdbcPooledConnection pooledConnection = new JdbcPooledConnection(this, xads.getXAConnection());
        this.xaResourceHolderMap.put(pooledConnection.getXAResource(), pooledConnection);
        return pooledConnection;
    }

    @Override
    public XAResourceHolder findXAResourceHolder(XAResource xaResource) {
        return this.xaResourceHolderMap.get(xaResource);
    }

    @Override
    public Reference getReference() throws NamingException {
        if (log.isDebugEnabled()) {
            log.debug("creating new JNDI reference of " + this);
        }
        return new Reference(PoolingDataSource.class.getName(), new StringRefAddr("uniqueName", this.getUniqueName()), ResourceObjectFactory.class.getName(), null);
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return this.xaDataSource.getLoginTimeout();
    }

    @Override
    public void setLoginTimeout(int seconds) throws SQLException {
        this.xaDataSource.setLoginTimeout(seconds);
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        return this.xaDataSource.getLogWriter();
    }

    @Override
    public void setLogWriter(PrintWriter out) throws SQLException {
        this.xaDataSource.setLogWriter(out);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface.isAssignableFrom(this.xaDataSource.getClass());
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (this.isWrapperFor(iface)) {
            return (T)this.xaDataSource;
        }
        throw new SQLException(this.getClass().getName() + " is not a wrapper for " + iface);
    }

    @Override
    public int getInPoolSize() {
        return this.pool.inPoolSize();
    }

    @Override
    public int getTotalPoolSize() {
        return this.pool.totalPoolSize();
    }

    @Override
    public void reset() throws Exception {
        this.pool.reset();
    }

    public void unregister(XAResourceHolder xaResourceHolder) {
        this.xaResourceHolderMap.remove(xaResourceHolder.getXAResource());
    }
}

