/*
 * Decompiled with CFR 0.152.
 */
package bitronix.tm.utils;

import bitronix.tm.Configuration;
import bitronix.tm.TransactionManagerServices;
import java.lang.management.ManagementFactory;
import java.lang.ref.WeakReference;
import java.util.LinkedHashMap;
import java.util.Queue;
import java.util.concurrent.ArrayBlockingQueue;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ManagementRegistrar {
    private static final Logger log = LoggerFactory.getLogger(ManagementRegistrar.class);
    private static final MBeanServer mbeanServer;
    private static final Queue<ManagementCommand> commandQueue;

    private ManagementRegistrar() {
    }

    public static String makeValidName(String name) {
        return name.replaceAll("[\\:\\,\\=,\\.]", "_");
    }

    public static void register(String name, Object obj) {
        if (mbeanServer == null) {
            return;
        }
        ManagementRegistrar.runOrEnqueueCommand(new ManagementRegisterCommand(name, obj));
    }

    public static void unregister(String name) {
        if (mbeanServer == null) {
            return;
        }
        ManagementRegistrar.runOrEnqueueCommand(new ManagementUnregisterCommand(name));
    }

    private static void runOrEnqueueCommand(ManagementCommand command) {
        if (commandQueue == null) {
            command.run();
        } else {
            while (!commandQueue.offer(command)) {
                ManagementRegistrar.normalizeAndRunQueuedCommands();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void normalizeAndRunQueuedCommands() {
        if (commandQueue == null) {
            return;
        }
        Queue<ManagementCommand> queue = commandQueue;
        synchronized (queue) {
            ManagementCommand command;
            LinkedHashMap<String, ManagementCommand> mappedCommands = new LinkedHashMap<String, ManagementCommand>(commandQueue.size());
            while ((command = commandQueue.poll()) != null) {
                String name = command.getName();
                ManagementCommand previousCommand = mappedCommands.put(name, command);
                if (previousCommand instanceof ManagementRegisterCommand) {
                    if (!(command instanceof ManagementUnregisterCommand) || ((ManagementRegisterCommand)previousCommand).isReplace()) continue;
                    mappedCommands.remove(name);
                    continue;
                }
                if (!(previousCommand instanceof ManagementUnregisterCommand) || !(command instanceof ManagementRegisterCommand)) continue;
                ((ManagementRegisterCommand)command).setReplace(true);
            }
            for (ManagementCommand c : mappedCommands.values()) {
                c.run();
            }
        }
    }

    static {
        boolean enableJmx = !TransactionManagerServices.getConfiguration().isDisableJmx();
        mbeanServer = enableJmx ? ManagementFactory.getPlatformMBeanServer() : null;
        Configuration configuration = TransactionManagerServices.getConfiguration();
        Queue<Object> queue = commandQueue = mbeanServer == null || configuration.isSynchronousJmxRegistration() ? null : new ArrayBlockingQueue(1024);
        if (commandQueue != null) {
            new Thread(){
                {
                    this.setName("bitronix-async-jmx-worker");
                    this.setDaemon(true);
                }

                public void run() {
                    while (!this.isInterrupted()) {
                        try {
                            ManagementRegistrar.normalizeAndRunQueuedCommands();
                            1.sleep(250L);
                        }
                        catch (InterruptedException ex) {
                            return;
                        }
                        catch (Exception ex) {
                            log.error("an unexpected error occurred in JMX asynchronous registration code", (Throwable)ex);
                        }
                    }
                }
            }.start();
        }
        if (mbeanServer != null) {
            if (log.isDebugEnabled()) {
                log.debug("Enabled JMX with MBeanServer " + mbeanServer + "; MBean registration is '" + (commandQueue == null ? "synchronous" : "asynchronous") + "'.");
            }
        } else if (log.isDebugEnabled()) {
            log.debug("JMX support is disabled.");
        }
    }

    private static abstract class ManagementCommand
    implements Runnable {
        final String name;

        protected ManagementCommand(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public final void run() {
            try {
                if (log.isDebugEnabled()) {
                    log.debug("Calling " + this.getClass().getSimpleName() + " on object with name " + this.name);
                }
                this.runCommand();
            }
            catch (Exception ex) {
                log.warn("Cannot execute " + this.getClass().getSimpleName() + " on object with name " + this.name, (Throwable)ex);
            }
        }

        protected abstract void runCommand() throws Exception;

        public String toString() {
            return this.getClass().getSimpleName() + "{" + "name='" + this.name + '\'' + '}';
        }
    }

    private static class ManagementUnregisterCommand
    extends ManagementCommand {
        ManagementUnregisterCommand(String name) {
            super(name);
        }

        protected void runCommand() throws Exception {
            block2: {
                try {
                    mbeanServer.unregisterMBean(new ObjectName(this.name));
                }
                catch (InstanceNotFoundException e) {
                    if (!log.isDebugEnabled()) break block2;
                    log.debug("Failed to unregister the JMX instance of name '" + this.name + "' as it doesn't exist.");
                }
            }
        }
    }

    private static class ManagementRegisterCommand
    extends ManagementCommand {
        private final WeakReference<Object> instance;
        private boolean replace;

        ManagementRegisterCommand(String name, Object instance) {
            super(name);
            this.instance = new WeakReference<Object>(instance);
        }

        boolean isReplace() {
            return this.replace;
        }

        void setReplace(boolean replace) {
            this.replace = replace;
        }

        protected void runCommand() throws Exception {
            Object object = this.instance.get();
            if (object != null) {
                ObjectName objectName = new ObjectName(this.name);
                if (this.replace && mbeanServer.isRegistered(objectName)) {
                    mbeanServer.unregisterMBean(objectName);
                }
                mbeanServer.registerMBean(object, objectName);
            }
        }
    }
}

