/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.ant;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.codehaus.cargo.ant.DataSourceElement;
import org.codehaus.cargo.ant.DeployableElement;
import org.codehaus.cargo.ant.Property;
import org.codehaus.cargo.ant.UserElement;
import org.codehaus.cargo.container.ContainerType;
import org.codehaus.cargo.container.configuration.Configuration;
import org.codehaus.cargo.container.configuration.ConfigurationType;
import org.codehaus.cargo.container.configuration.FileConfig;
import org.codehaus.cargo.container.configuration.LocalConfiguration;
import org.codehaus.cargo.container.configuration.StandaloneLocalConfiguration;
import org.codehaus.cargo.generic.configuration.DefaultConfigurationFactory;
import org.codehaus.cargo.util.XmlReplacement;
import org.codehaus.cargo.util.log.Logger;

public class ConfigurationElement {
    private ConfigurationType type = ConfigurationType.STANDALONE;
    private String home;
    private List<Property> properties = new ArrayList<Property>();
    private File propertiesFile;
    private Class configurationClass;
    private List<DeployableElement> deployables = new ArrayList<DeployableElement>();
    private List<FileConfig> fileConfigs = new ArrayList<FileConfig>();
    private List<FileConfig> files = new ArrayList<FileConfig>();
    private List<XmlReplacement> xmlReplacements = new ArrayList<XmlReplacement>();
    private List<DataSourceElement> dataSources = new ArrayList<DataSourceElement>();
    private List<UserElement> users = new ArrayList<UserElement>();

    public void setClass(Class configurationClass) {
        this.configurationClass = configurationClass;
    }

    protected Class getConfigurationClass() {
        return this.configurationClass;
    }

    public void addConfiguredDeployable(DeployableElement deployableElement) {
        this.deployables.add(deployableElement);
    }

    protected List<DeployableElement> getDeployables() {
        return this.deployables;
    }

    public void addConfiguredConfigfile(FileConfig configfileElement) {
        this.fileConfigs.add(configfileElement);
    }

    protected List<FileConfig> getFileConfigs() {
        return this.fileConfigs;
    }

    public void addConfiguredFile(FileConfig fileConfigElement) {
        this.files.add(fileConfigElement);
    }

    protected List<FileConfig> getFiles() {
        return this.files;
    }

    public void addConfiguredProperty(Property property) {
        this.properties.add(property);
    }

    protected List<Property> getProperties() {
        return this.properties;
    }

    public File getPropertiesFile() {
        return this.propertiesFile;
    }

    public void setPropertiesFile(File propertiesFile) {
        this.propertiesFile = propertiesFile;
    }

    public void addConfiguredXmlreplacement(XmlReplacement xmlReplacement) {
        this.xmlReplacements.add(xmlReplacement);
    }

    protected List<XmlReplacement> getXmlReplacements() {
        return this.xmlReplacements;
    }

    public void addConfiguredDataSource(DataSourceElement dataSourceElement) {
        this.dataSources.add(dataSourceElement);
    }

    public List<DataSourceElement> getDataSources() {
        return this.dataSources;
    }

    public void addConfiguredUser(UserElement userElement) {
        this.users.add(userElement);
    }

    protected List<UserElement> getUsers() {
        return this.users;
    }

    public void setType(String typeAsString) {
        this.type = ConfigurationType.toType((String)typeAsString);
    }

    public ConfigurationType getType() {
        return this.type;
    }

    public void setHome(String home) {
        this.home = home;
    }

    public String getHome() {
        return this.home;
    }

    public Configuration createConfiguration(String containerId, ContainerType containerType, Project antProject, Logger log) {
        DefaultConfigurationFactory factory = new DefaultConfigurationFactory();
        if (this.getConfigurationClass() != null) {
            factory.registerConfiguration(containerId, containerType, this.getType(), this.getConfigurationClass());
        }
        Configuration configuration = this.getHome() == null ? factory.createConfiguration(containerId, containerType, this.getType()) : factory.createConfiguration(containerId, containerType, this.getType(), this.getHome());
        if (antProject != null && antProject.getProperties() != null) {
            for (Map.Entry entry : antProject.getProperties().entrySet()) {
                if (entry.getKey() == null || entry.getValue() == null || !(entry.getValue() instanceof String) || !((String)entry.getKey()).startsWith("cargo.") || !configuration.getCapability().supportsProperty((String)entry.getKey())) continue;
                log.debug("Injecting container configuration property [" + (String)entry.getKey() + "] based on the Ant build property", this.getClass().getName());
                configuration.setProperty((String)entry.getKey(), (String)entry.getValue());
            }
        }
        if (this.getPropertiesFile() != null) {
            Properties properties = new Properties();
            try {
                try (FileInputStream fileInputStream = new FileInputStream(this.getPropertiesFile());){
                    properties.load(new BufferedInputStream(fileInputStream));
                }
                Enumeration<?> enumeration = properties.propertyNames();
                while (enumeration.hasMoreElements()) {
                    String propertyName = (String)enumeration.nextElement();
                    String propertyValue = properties.getProperty(propertyName);
                    configuration.setProperty(propertyName, propertyValue);
                }
            }
            catch (IOException iOException) {
                throw new BuildException("Configuration property file [" + this.getPropertiesFile() + "] cannot be loaded", (Throwable)iOException);
            }
        }
        for (Property property : this.getProperties()) {
            configuration.setProperty(property.getName(), property.getValue());
        }
        if (configuration instanceof StandaloneLocalConfiguration) {
            StandaloneLocalConfiguration standaloneLocalConfiguration = (StandaloneLocalConfiguration)configuration;
            for (XmlReplacement xmlReplacement : this.getXmlReplacements()) {
                standaloneLocalConfiguration.addXmlReplacement(xmlReplacement);
            }
        }
        if (configuration instanceof LocalConfiguration) {
            LocalConfiguration localConfiguration = (LocalConfiguration)configuration;
            this.addStaticDeployables(containerId, localConfiguration);
            if (this.getFileConfigs() != null) {
                for (FileConfig configfile : this.getFileConfigs()) {
                    localConfiguration.setConfigFileProperty(configfile);
                }
            }
            if (this.getFiles() != null) {
                for (FileConfig file : this.getFiles()) {
                    localConfiguration.setFileProperty(file);
                }
            }
            if (this.getDataSources() != null) {
                for (DataSourceElement dataSource : this.getDataSources()) {
                    localConfiguration.addDataSource(dataSource.createDataSource());
                }
            }
            if (this.getUsers() != null) {
                for (UserElement user : this.getUsers()) {
                    localConfiguration.addUser(user.createUser());
                }
            }
        }
        return configuration;
    }

    private void addStaticDeployables(String containerId, LocalConfiguration configuration) {
        for (DeployableElement deployableElement : this.getDeployables()) {
            configuration.addDeployable(deployableElement.createDeployable(containerId));
        }
    }
}

