/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.maven2;

import org.apache.maven.plugin.MojoExecutionException;
import org.codehaus.cargo.container.Container;
import org.codehaus.cargo.container.LocalContainer;
import org.codehaus.cargo.container.configuration.LocalConfiguration;
import org.codehaus.cargo.container.spi.util.ContainerUtils;
import org.codehaus.cargo.maven2.AbstractCargoMojo;

public class ContainerStartMojo
extends AbstractCargoMojo {
    private boolean wait;

    public void doExecute() throws MojoExecutionException {
        Container container = this.createContainer();
        if (!container.getType().isLocal()) {
            throw new MojoExecutionException("Only local containers can be started");
        }
        LocalContainer localContainer = (LocalContainer)container;
        this.addAutoDeployDeployable(localContainer);
        localContainer.start();
        if (this.wait) {
            this.getLog().info((CharSequence)"Press Ctrl-C to stop the container...");
            ContainerUtils.waitTillContainerIsStopped((Container)localContainer);
        }
    }

    protected void addAutoDeployDeployable(LocalContainer container) throws MojoExecutionException {
        if (this.getDeployerElement() == null && this.getCargoProject().getPackaging() != null && this.getCargoProject().isJ2EEPackaging() && (this.getConfigurationElement() == null || this.getConfigurationElement().getDeployables() == null || !this.containsAutoDeployable(this.getConfigurationElement().getDeployables()))) {
            LocalConfiguration configuration = container.getConfiguration();
            configuration.addDeployable(this.createAutoDeployDeployable((Container)container));
        }
    }
}

