/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.maven2.deployer;

import org.codehaus.cargo.container.Container;
import org.codehaus.cargo.container.LocalContainer;
import org.codehaus.cargo.container.RemoteContainer;
import org.codehaus.cargo.container.configuration.Configuration;
import org.codehaus.cargo.container.deployer.DeployableMonitor;
import org.codehaus.cargo.container.deployer.URLDeployableMonitor;
import org.codehaus.cargo.container.deployer.UrlPathDeployableMonitor;
import org.codehaus.cargo.maven2.configuration.Deployable;
import org.codehaus.cargo.maven2.deployer.DeployableMonitorFactory;

public class DefaultDeployableMonitorFactory
implements DeployableMonitorFactory {
    public DeployableMonitor createDeployableMonitor(Container container, Deployable deployable) {
        URLDeployableMonitor deployableMonitor = null;
        Configuration configuration = this.retrieveConfiguration(container);
        if (deployable.getPingURL() != null) {
            deployableMonitor = this.createUrlDeployableMonitor(deployable);
        } else if (deployable.getPingUrlPath() != null) {
            deployableMonitor = this.createUrlPathDeployableMonitor(configuration, deployable);
        }
        return deployableMonitor;
    }

    private URLDeployableMonitor createUrlDeployableMonitor(Deployable deployable) {
        Long pingTimeout = deployable.getPingTimeout();
        if (pingTimeout == null) {
            return new URLDeployableMonitor(deployable.getPingURL());
        }
        return new URLDeployableMonitor(deployable.getPingURL(), pingTimeout.longValue());
    }

    private UrlPathDeployableMonitor createUrlPathDeployableMonitor(Configuration configuration, Deployable deployable) {
        Long pingTimeout = deployable.getPingTimeout();
        if (pingTimeout == null) {
            return new UrlPathDeployableMonitor(configuration, deployable.getPingUrlPath());
        }
        return new UrlPathDeployableMonitor(configuration, deployable.getPingUrlPath(), pingTimeout.longValue());
    }

    private Configuration retrieveConfiguration(Container container) {
        if (container instanceof LocalContainer) {
            return ((LocalContainer)container).getConfiguration();
        }
        return ((RemoteContainer)container).getConfiguration();
    }
}

