/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.maven2;

import java.util.ArrayList;
import org.apache.maven.plugin.MojoExecutionException;
import org.codehaus.cargo.container.Container;
import org.codehaus.cargo.container.deployer.DeployableMonitor;
import org.codehaus.cargo.container.deployer.DeployableMonitorListener;
import org.codehaus.cargo.container.deployer.Deployer;
import org.codehaus.cargo.generic.deployer.DefaultDeployerFactory;
import org.codehaus.cargo.generic.deployer.DeployerFactory;
import org.codehaus.cargo.maven2.AbstractCargoMojo;
import org.codehaus.cargo.maven2.configuration.Deployable;
import org.codehaus.cargo.maven2.deployer.DefaultDeployableMonitorFactory;

public abstract class AbstractDeployerMojo
extends AbstractCargoMojo {
    public void doExecute() throws MojoExecutionException {
        if (!(this.getCargoProject().getPackaging() != null && this.getCargoProject().isJ2EEPackaging() || this.getDeployablesElement() != null && this.getDeployablesElement().length != 0)) {
            this.getLog().info((CharSequence)"There's nothing to deploy or undeploy");
            return;
        }
        Container container = this.createContainer();
        Deployer deployer = this.createDeployer(container);
        this.performDeployerActionOnAllDeployables(container, deployer);
    }

    protected Deployer createDeployer(Container container) throws MojoExecutionException {
        Deployer deployer = this.getDeployerElement() == null ? this.createDeployerFactory().createDeployer(container) : this.getDeployerElement().createDeployer(container);
        return deployer;
    }

    protected DeployerFactory createDeployerFactory() {
        return new DefaultDeployerFactory();
    }

    private void performDeployerActionOnAllDeployables(Container container, Deployer deployer) throws MojoExecutionException {
        this.getLog().debug((CharSequence)("Performing deployment action into [" + container.getName() + "]..."));
        ArrayList<Object> deployableElements = new ArrayList<Object>();
        if (this.getDeployablesElement() != null) {
            for (Deployable deployableElement : this.getDeployablesElement()) {
                if (deployableElements.contains(deployableElement)) continue;
                deployableElements.add(deployableElement);
            }
        }
        for (Deployable deployable : deployableElements) {
            org.codehaus.cargo.container.deployable.Deployable deployable2 = deployable.createDeployable(container.getId(), this.getCargoProject());
            DeployableMonitor monitor = this.createDeployableMonitor(container, deployable, deployable2);
            this.performDeployerActionOnSingleDeployable(deployer, deployable2, monitor);
        }
        if (this.getCargoProject().getPackaging() != null && this.getCargoProject().isJ2EEPackaging()) {
            Deployable[] deployableElementsArray = new Deployable[deployableElements.size()];
            deployableElements.toArray(deployableElementsArray);
            if (!this.containsAutoDeployable(deployableElementsArray)) {
                this.performDeployerActionOnSingleDeployable(deployer, this.createAutoDeployDeployable(container), null);
            }
        }
    }

    protected abstract void performDeployerActionOnSingleDeployable(Deployer var1, org.codehaus.cargo.container.deployable.Deployable var2, DeployableMonitor var3);

    private DeployableMonitor createDeployableMonitor(Container container, Deployable deployableElement, org.codehaus.cargo.container.deployable.Deployable deployable) {
        DefaultDeployableMonitorFactory monitorFactory = new DefaultDeployableMonitorFactory();
        DeployableMonitor monitor = monitorFactory.createDeployableMonitor(container, deployableElement);
        if (monitor != null) {
            DeployerListener listener = new DeployerListener(deployable);
            monitor.registerListener((DeployableMonitorListener)listener);
        }
        return monitor;
    }

    public class DeployerListener
    implements DeployableMonitorListener {
        private org.codehaus.cargo.container.deployable.Deployable deployable;

        public DeployerListener(org.codehaus.cargo.container.deployable.Deployable deployable) {
            this.deployable = deployable;
        }

        public void deployed() {
            AbstractDeployerMojo.this.getLog().debug((CharSequence)("Watchdog finds [" + this.deployable.getFile() + "] deployed."));
        }

        public void undeployed() {
            AbstractDeployerMojo.this.getLog().debug((CharSequence)("Watchdog finds [" + this.deployable.getFile() + "] not deployed yet."));
        }
    }
}

