/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.maven3;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.List;
import java.util.Properties;
import org.apache.maven.Maven;
import org.apache.maven.archiver.MavenArchiveConfiguration;
import org.apache.maven.archiver.MavenArchiver;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.resolver.filter.ScopeArtifactFilter;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuilder;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.shared.transfer.artifact.ArtifactCoordinate;
import org.apache.maven.shared.transfer.artifact.DefaultArtifactCoordinate;
import org.apache.maven.shared.transfer.artifact.install.ArtifactInstaller;
import org.apache.maven.shared.transfer.artifact.resolve.ArtifactResolver;
import org.apache.maven.shared.transfer.dependencies.resolve.DependencyResolver;
import org.codehaus.cargo.maven3.AbstractUberWarMojo;
import org.codehaus.cargo.maven3.DependencyCalculator;
import org.codehaus.cargo.maven3.Merge;
import org.codehaus.cargo.maven3.MergeRoot;
import org.codehaus.cargo.maven3.merge.MergeWebXml;
import org.codehaus.cargo.maven3.merge.MergeXslt;
import org.codehaus.cargo.module.merge.DocumentStreamAdapter;
import org.codehaus.cargo.module.merge.MergeException;
import org.codehaus.cargo.module.merge.MergeProcessor;
import org.codehaus.cargo.module.webapp.DefaultWarArchive;
import org.codehaus.cargo.module.webapp.merge.MergedWarArchive;
import org.codehaus.cargo.module.webapp.merge.WarArchiveMerger;
import org.codehaus.plexus.archiver.jar.JarArchiver;
import org.codehaus.plexus.archiver.war.WarArchiver;
import org.codehaus.plexus.classworlds.realm.ClassRealm;
import org.codehaus.plexus.context.Context;
import org.codehaus.plexus.context.ContextException;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Contextualizable;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

@Mojo(name="uberwar", defaultPhase=LifecyclePhase.PACKAGE, requiresDependencyResolution=ResolutionScope.TEST, threadSafe=true)
public class UberWarMojo
extends AbstractUberWarMojo
implements Contextualizable {
    private static final String PLEXUS_UTILS_POM_PROPERTIES = "META-INF/maven/org.codehaus.plexus/plexus-utils/pom.properties";
    @Parameter(property="project.build.directory", required=true)
    private String outputDirectory;
    @Parameter(property="project.build.finalName", required=true)
    private String warName;
    @Parameter
    private File descriptor;
    @Parameter
    private boolean resolveDependencies = false;
    @Parameter
    private String descriptorId;
    @Component
    private ArtifactResolver artifactResolver;
    @Component
    private DependencyResolver dependencyResolver;
    @Parameter(defaultValue="${session.projectBuildingRequest}", readonly=true, required=true)
    private ProjectBuildingRequest projectBuildingRequest;
    @Parameter(property="project", readonly=true, required=true)
    private MavenProject mavenProject;
    @Parameter(property="session", readonly=true, required=true)
    private MavenSession mavenSession;
    @Parameter
    private MavenArchiveConfiguration archive = new MavenArchiveConfiguration();
    @Component
    private ProjectBuilder mavenProjectBuilder;
    @Component
    private ArtifactInstaller installer;

    protected File getConfigDirectory() {
        return this.descriptor.getParentFile();
    }

    @Override
    public void execute() throws MojoExecutionException {
        InputStreamReader r = null;
        if (this.descriptor != null) {
            try {
                r = new FileReader(this.descriptor);
            }
            catch (FileNotFoundException ex) {
                throw new MojoExecutionException("Could not find specified descriptor");
            }
        } else if (this.descriptorId != null) {
            InputStream resourceAsStream = ((Object)((Object)this)).getClass().getResourceAsStream("/uberwar/" + this.descriptorId + ".xml");
            if (resourceAsStream == null) {
                throw new MojoExecutionException("Descriptor with ID '" + this.descriptorId + "' not found");
            }
            r = new InputStreamReader(resourceAsStream);
        } else {
            throw new MojoExecutionException("You must specify descriptor or descriptorId");
        }
        try {
            Method read;
            Class<?> uberWarXpp3ReaderClass = null;
            try {
                uberWarXpp3ReaderClass = ((Object)((Object)this)).getClass().getClassLoader().loadClass("org.codehaus.cargo.maven3.io.xpp3.UberWarXpp3Reader");
                read = uberWarXpp3ReaderClass.getMethod("read", Reader.class);
            }
            catch (ClassNotFoundException | NoClassDefFoundError e) {
                ClassRealm classLoader = (ClassRealm)((Object)((Object)this)).getClass().getClassLoader();
                DefaultArtifactCoordinate plexusCoordinate = new DefaultArtifactCoordinate();
                plexusCoordinate.setGroupId("org.codehaus.plexus");
                plexusCoordinate.setArtifactId("plexus-utils");
                plexusCoordinate.setExtension("jar");
                ClassLoader mavenCore = Maven.class.getClassLoader();
                if (mavenCore.getResource(PLEXUS_UTILS_POM_PROPERTIES) != null) {
                    try (InputStream plexusUtilsStream = mavenCore.getResourceAsStream(PLEXUS_UTILS_POM_PROPERTIES);){
                        Properties plexusUtilsProperties = new Properties();
                        plexusUtilsProperties.load(plexusUtilsStream);
                        plexusCoordinate.setVersion(plexusUtilsProperties.getProperty("version"));
                    }
                } else {
                    throw new ClassNotFoundException("Cannot load the Uberwar library", e);
                }
                Artifact plexusArtifact = this.artifactResolver.resolveArtifact(this.projectBuildingRequest, (ArtifactCoordinate)plexusCoordinate).getArtifact();
                URL plexusArtifactUrl = plexusArtifact.getFile().toURI().toURL();
                classLoader.addURL(plexusArtifactUrl);
                uberWarXpp3ReaderClass = ((Object)((Object)this)).getClass().getClassLoader().loadClass("org.codehaus.cargo.maven3.io.xpp3.UberWarXpp3Reader");
                read = uberWarXpp3ReaderClass.getMethod("read", Reader.class);
            }
            Object reader = uberWarXpp3ReaderClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            MergeRoot root = (MergeRoot)read.invoke(reader, r);
            WarArchiveMerger wam = new WarArchiveMerger();
            List wars = root.getWars();
            if (wars.isEmpty()) {
                this.addAllWars(wam);
            } else {
                for (String id : wars) {
                    this.addWar(wam, id);
                }
            }
            if (this.resolveDependencies) {
                wam.setMergeJarFiles(false);
                this.addAllTransitiveJars(wam);
            } else {
                this.addAllDependentJars(wam);
            }
            for (Object mergeObject : root.getMerges()) {
                Merge merge = (Merge)mergeObject;
                this.doMerge(wam, merge);
            }
            File assembleDir = new File(this.outputDirectory, this.warName);
            File warFile = new File(this.outputDirectory, this.warName + ".war");
            MergedWarArchive output = (MergedWarArchive)wam.performMerge();
            output.merge(assembleDir.getAbsolutePath());
            WarArchiver warArchiver = new WarArchiver();
            warArchiver.addDirectory(assembleDir);
            warArchiver.setIgnoreWebxml(false);
            MavenArchiver mar = new MavenArchiver();
            mar.setArchiver((JarArchiver)warArchiver);
            mar.setOutputFile(warFile);
            mar.createArchive(this.mavenSession, this.mavenProject, this.archive);
            this.getProject().getArtifact().setFile(warFile);
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getCause();
            if (t instanceof XmlPullParserException) {
                throw new MojoExecutionException("Invalid XML descriptor", t);
            }
            throw new MojoExecutionException("Exception creating Uberwar", t);
        }
        catch (Exception e) {
            throw new MojoExecutionException("Exception creating Uberwar", e);
        }
    }

    private void doMerge(WarArchiveMerger wam, Merge merge) throws MojoExecutionException {
        try {
            String type = merge.getType();
            String file = merge.getFile();
            String document = merge.getDocument();
            String clazz = merge.getClassname();
            MergeProcessor merger = null;
            if (type != null) {
                if (type.equalsIgnoreCase("web.xml")) {
                    merger = new MergeWebXml(this.getConfigDirectory()).create(wam, merge);
                } else if (type.equalsIgnoreCase("xslt")) {
                    merger = new MergeXslt(this.descriptor.getParentFile()).create(wam, merge);
                }
            } else {
                merger = (MergeProcessor)Class.forName(clazz).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            if (merger != null) {
                if (document != null) {
                    merger = new DocumentStreamAdapter(merger);
                    wam.addMergeProcessor(document, merger);
                } else if (file != null) {
                    wam.addMergeProcessor(file, merger);
                }
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException("Problem in file merge", e);
        }
    }

    protected void addAllTransitiveJars(WarArchiveMerger wam) throws MojoExecutionException {
        DependencyCalculator dc = new DependencyCalculator(this.dependencyResolver, this.artifactResolver, this.projectBuildingRequest, this.mavenProject, this.mavenProjectBuilder, this.installer);
        try {
            for (File f : dc.execute()) {
                wam.addMergeItem((Object)f);
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException("Problem merging dependent JAR files", e);
        }
    }

    protected void addAllDependentJars(WarArchiveMerger wam) throws MojoExecutionException {
        for (Object artifactObject : this.getProject().getArtifacts()) {
            String type;
            Artifact artifact = (Artifact)artifactObject;
            ScopeArtifactFilter filter = new ScopeArtifactFilter("runtime");
            if (artifact.isOptional() || !filter.include(artifact) || !"jar".equals(type = artifact.getType())) continue;
            try {
                wam.addMergeItem((Object)artifact.getFile());
            }
            catch (MergeException e) {
                throw new MojoExecutionException("Problem merging WAR", (Exception)((Object)e));
            }
        }
    }

    protected void addWar(WarArchiveMerger wam, String artifactIdent) throws MojoExecutionException, IOException {
        for (Object artifactObject : this.getProject().getArtifacts()) {
            String name;
            String type;
            Artifact artifact = (Artifact)artifactObject;
            ScopeArtifactFilter filter = new ScopeArtifactFilter("runtime");
            if (artifact.isOptional() || !filter.include(artifact) || !"war".equals(type = artifact.getType()) || !(name = artifact.getGroupId() + ":" + artifact.getArtifactId()).equals(artifactIdent)) continue;
            try {
                wam.addMergeItem((Object)new DefaultWarArchive(artifact.getFile().getPath()));
            }
            catch (MergeException e) {
                throw new MojoExecutionException("Problem merging WAR", (Exception)((Object)e));
            }
            return;
        }
        throw new MojoExecutionException("Could not find a dependent WAR file matching " + artifactIdent);
    }

    protected void addAllWars(WarArchiveMerger wam) throws MojoExecutionException, IOException {
        for (Object artifactObject : this.getProject().getArtifacts()) {
            String type;
            Artifact artifact = (Artifact)artifactObject;
            ScopeArtifactFilter filter = new ScopeArtifactFilter("runtime");
            if (artifact.isOptional() || !filter.include(artifact) || !"war".equals(type = artifact.getType())) continue;
            try {
                wam.addMergeItem((Object)new DefaultWarArchive(artifact.getFile().getPath()));
            }
            catch (MergeException e) {
                throw new MojoExecutionException("Problem merging WAR", (Exception)((Object)e));
            }
        }
    }

    public void contextualize(Context context) throws ContextException {
    }
}

