/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.gmaven.plugin;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nullable;
import org.codehaus.gmaven.adapter.ClassSource;
import org.codehaus.plexus.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(role=ClassSourceFactory.class)
public class ClassSourceFactory {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    @VisibleForTesting
    static final AtomicInteger scriptCounter = new AtomicInteger(0);

    public ClassSource create(String source) {
        Preconditions.checkNotNull((Object)source);
        String trimmed = source.trim();
        this.log.trace("Creating class-source from: {}", (Object)trimmed);
        try {
            return new ClassSourceImpl(new URL(trimmed), null, null);
        }
        catch (MalformedURLException e) {
            this.log.trace("Not a URL", (Throwable)e);
            try {
                File file = new File(trimmed).getCanonicalFile();
                if (file.exists()) {
                    return new ClassSourceImpl(null, file, null);
                }
            }
            catch (IOException e2) {
                this.log.trace("Not a File", (Throwable)e2);
            }
            return new ClassSourceImpl(null, null, new InlineImpl(source));
        }
    }

    private static final class InlineImpl
    implements ClassSource.Inline {
        private final String name = "script" + scriptCounter.incrementAndGet() + ".groovy";
        private final String codeBase;
        private final Reader input;

        private InlineImpl(String source) {
            this.codeBase = "/groovy/script";
            this.input = new StringReader(source);
        }

        public String getName() {
            return this.name;
        }

        public String getCodeBase() {
            return this.codeBase;
        }

        public Reader getInput() {
            return this.input;
        }

        public String toString() {
            return this.getClass().getSimpleName() + "{" + "name='" + this.name + '\'' + ", codeBase='" + this.codeBase + '\'' + ", input=" + this.input + '}';
        }
    }

    private static final class ClassSourceImpl
    implements ClassSource {
        private final URL url;
        private final File file;
        private final ClassSource.Inline inline;

        private ClassSourceImpl(@Nullable URL url, @Nullable File file, @Nullable ClassSource.Inline inline) {
            this.url = url;
            this.file = file;
            this.inline = inline;
        }

        public URL getUrl() {
            return this.url;
        }

        public File getFile() {
            return this.file;
        }

        public ClassSource.Inline getInline() {
            return this.inline;
        }

        public String toString() {
            return this.getClass().getSimpleName() + "{" + "url=" + this.url + ", file=" + this.file + ", inline=" + this.inline + '}';
        }
    }
}

