/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.gmaven.plugin;

import com.google.common.base.Throwables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.settings.Settings;
import org.codehaus.gmaven.adapter.GroovyRuntime;
import org.codehaus.gmaven.adapter.MagicContext;
import org.codehaus.gmaven.plugin.ClasspathScope;
import org.codehaus.gmaven.plugin.FailClosureTarget;
import org.codehaus.gmaven.plugin.GroovyRuntimeFactory;
import org.codehaus.gmaven.plugin.MojoSupport;
import org.codehaus.gmaven.plugin.util.ContainerHelper;
import org.codehaus.gmaven.plugin.util.GroovyVersionHelper;
import org.codehaus.gmaven.plugin.util.MavenVersionHelper;
import org.codehaus.gmaven.plugin.util.PropertiesBuilder;
import org.codehaus.gmaven.plugin.util.VersionHelper;
import org.codehaus.plexus.classworlds.ClassWorld;
import org.codehaus.plexus.classworlds.realm.ClassRealm;
import org.eclipse.aether.version.Version;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RuntimeMojoSupport
extends MojoSupport {
    @Component
    private PluginDescriptor pluginDescriptor;
    @Component
    private MojoExecution mojoExecution;
    @Component
    private MavenProject project;
    @Component
    private MavenSession session;
    @Component
    private Settings settings;
    @Component
    private ContainerHelper containerHelper;
    @Component
    private VersionHelper versionHelper;
    @Component
    private MavenVersionHelper mavenVersionHelper;
    @Component
    private GroovyVersionHelper groovyVersionHelper;
    @Component
    private GroovyRuntimeFactory groovyRuntimeFactory;
    @Component
    private PropertiesBuilder propertiesBuilder;
    @Parameter(property="scope", defaultValue="none")
    private ClasspathScope classpathScope;
    @Parameter(property="scriptpath")
    private List<File> scriptpath;
    private File basedir;
    private ClassWorld classWorld;
    private ClassRealm runtimeRealm;
    private GroovyRuntime runtime;

    protected List<File> getScriptpath() {
        return this.scriptpath;
    }

    protected ClassRealm getRuntimeRealm() {
        return this.runtimeRealm;
    }

    protected GroovyRuntime getRuntime() {
        return this.runtime;
    }

    @Override
    protected void prepare() throws Exception {
        this.basedir = this.resolveBasedir();
        this.log.debug("Base directory: {}", (Object)this.basedir);
        this.classWorld = new ClassWorld();
        ClassLoader parentCl = ((Object)((Object)this)).getClass().getClassLoader();
        this.ensureMavenCompatibility(parentCl);
        this.runtimeRealm = this.classWorld.newRealm("gmaven-runtime", parentCl);
        this.ensureGroovyComparability((ClassLoader)this.runtimeRealm);
        this.runtime = this.groovyRuntimeFactory.create((ClassLoader)this.runtimeRealm);
        this.configureAdditionalClasspath(this.runtimeRealm);
    }

    private File resolveBasedir() throws IOException {
        File file;
        String path = null;
        if (this.project != null && (file = this.project.getBasedir()) != null) {
            path = file.getAbsolutePath();
        }
        if (path == null) {
            path = this.session.getExecutionRootDirectory();
        }
        if (path == null) {
            path = System.getProperty("user.dir");
        }
        return new File(path).getCanonicalFile();
    }

    @Override
    protected void cleanup() throws Exception {
        if (this.runtime != null) {
            this.runtime.cleanup();
        }
        if (this.runtimeRealm != null) {
            this.classWorld.disposeRealm(this.runtimeRealm.getId());
            this.runtimeRealm = null;
        }
        this.classWorld = null;
    }

    private void ensureMavenCompatibility(ClassLoader classLoader) throws MojoExecutionException {
        Version mavenVersion = this.mavenVersionHelper.detectVersion(classLoader);
        if (mavenVersion == null) {
            this.log.error("Unable to determine Maven version");
        } else {
            this.log.debug("Detected Maven version: {}", (Object)mavenVersion);
            if (this.versionHelper.before(3).containsVersion(mavenVersion)) {
                throw new MojoExecutionException("Unsupported Maven version: " + mavenVersion);
            }
        }
    }

    private void ensureGroovyComparability(ClassLoader classLoader) throws MojoExecutionException {
        Version groovyVersion = this.groovyVersionHelper.detectVersion(classLoader);
        if (groovyVersion == null) {
            this.log.error("Unable to determine Groovy version");
        } else {
            this.log.debug("Detected Groovy version: {}", (Object)groovyVersion);
            if (this.versionHelper.before(2).containsVersion(groovyVersion)) {
                throw new MojoExecutionException("Unsupported Groovy version: " + groovyVersion);
            }
        }
    }

    private void configureAdditionalClasspath(ClassRealm realm) {
        this.log.debug("Configuring additional classpath with scope: {}", (Object)this.classpathScope);
        ArrayList classpath = Lists.newArrayList();
        if (this.classpathScope.matches(ClasspathScope.compile)) {
            classpath.add(new File(this.project.getBuild().getOutputDirectory()));
        }
        if (this.classpathScope.matches(ClasspathScope.test)) {
            classpath.add(new File(this.project.getBuild().getTestOutputDirectory()));
        }
        if (!this.project.getArtifacts().isEmpty()) {
            for (Artifact artifact : this.project.getArtifacts()) {
                if (!this.classpathScope.matches(artifact.getScope())) continue;
                File file = artifact.getFile();
                if (!file.exists()) {
                    this.log.warn("Artifact not resolved; ignoring: {}", (Object)artifact);
                    continue;
                }
                classpath.add(file);
            }
        }
        if (!classpath.isEmpty()) {
            this.log.debug("Additional classpath:");
            for (File file : classpath) {
                this.log.debug("  {}", (Object)file);
                try {
                    realm.addURL(file.toURI().toURL());
                }
                catch (MalformedURLException e) {
                    throw Throwables.propagate((Throwable)e);
                }
            }
        }
    }

    private Logger createLogger() {
        String loggerName = String.format("%s.%s.Script", this.project.getGroupId(), this.project.getArtifactId());
        return LoggerFactory.getLogger((String)loggerName);
    }

    private Properties createProperties() {
        this.propertiesBuilder.setProject(this.project).setSession(this.session);
        this.customizeProperties(this.propertiesBuilder);
        Properties props = new Properties();
        props.putAll(this.propertiesBuilder.build());
        return props;
    }

    protected void customizeProperties(PropertiesBuilder builder) {
    }

    protected Map<String, Object> createContext() {
        HashMap context = Maps.newHashMap();
        context.put("log", this.createLogger());
        context.put("container", this.containerHelper);
        context.put("plugin", this.pluginDescriptor);
        context.put("pluginContext", this.getPluginContext());
        context.put("mojo", this.mojoExecution);
        context.put("basedir", this.basedir);
        context.put("project", this.project);
        context.put("properties", this.createProperties());
        context.put("session", this.session);
        context.put("settings", this.settings);
        context.put("ant", MagicContext.ANT_BUILDER);
        context.put("fail", new FailClosureTarget());
        return context;
    }
}

