/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.gmaven.plugin.util;

import java.security.Permission;
import javax.annotation.Nullable;

public class NoExitSecurityManager
extends SecurityManager {
    private final SecurityManager parent;

    public NoExitSecurityManager(@Nullable SecurityManager parent) {
        this.parent = parent;
    }

    private void deny() {
        throw new SecurityException("Use of System.exit() is forbidden");
    }

    @Override
    public void checkPermission(Permission perm) {
        if (perm == null) {
            return;
        }
        String name = perm.getName();
        if (name != null && name.startsWith("exitVM")) {
            this.deny();
        }
        if (this.parent != null) {
            this.parent.checkPermission(perm);
        }
    }

    @Override
    public void checkExit(int code) {
        this.deny();
    }
}

