/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.gmaven.plugin;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import javax.annotation.Nullable;
import org.codehaus.gmaven.adapter.ClassSource;
import org.codehaus.gmaven.plugin.BasicResourceLoader;

public class MojoResourceLoader
extends BasicResourceLoader {
    private final ClassSource classSource;
    private final List<File> scriptpath;

    public MojoResourceLoader(ClassLoader classLoader, @Nullable ClassSource classSource, @Nullable List<File> scriptpath) {
        super(classLoader);
        this.classSource = classSource;
        this.scriptpath = scriptpath;
    }

    public MojoResourceLoader(ClassLoader classLoader, @Nullable List<File> scriptpath) {
        this(classLoader, null, scriptpath);
    }

    @Override
    @Nullable
    protected URL resolve(String className, ClassLoader classLoader) throws MalformedURLException {
        File script;
        URL url;
        File file;
        String name = this.resourceName(className);
        if (this.scriptpath != null) {
            for (File path : this.scriptpath) {
                file = new File(path, name);
                if (!file.exists()) continue;
                return file.toURI().toURL();
            }
        }
        if ((url = classLoader.getResource(name)) == null && name.startsWith("/")) {
            String tmp = name.substring(1, name.length());
            url = classLoader.getResource(tmp);
        }
        if (url != null) {
            return url;
        }
        if (this.classSource != null && (script = this.classSource.getFile()) != null && (file = new File(script.getParentFile(), name)).exists()) {
            return file.toURI().toURL();
        }
        return super.resolve(className, classLoader);
    }
}

