/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.gmavenplus.mojo;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.codehaus.gmavenplus.groovyworkarounds.DotGroovyFile;
import org.codehaus.gmavenplus.model.Version;
import org.codehaus.gmavenplus.mojo.AbstractGroovyStubSourcesMojo;
import org.codehaus.gmavenplus.util.ReflectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractGenerateStubsMojo
extends AbstractGroovyStubSourcesMojo {
    protected String sourceEncoding;
    protected Set<String> scriptExtensions;
    protected String targetBytecode;
    protected boolean debug;
    protected boolean verbose;
    protected int warningLevel;
    protected int tolerance;

    protected synchronized void doStubGeneration(Set<File> stubSources, List classpath, File outputDirectory) throws ClassNotFoundException, InvocationTargetException, IllegalAccessException, InstantiationException, MalformedURLException {
        if (stubSources == null || stubSources.isEmpty()) {
            this.getLog().info((CharSequence)"No sources specified for stub generation.  Skipping.");
            return;
        }
        Class<?> compilerConfigurationClass = Class.forName("org.codehaus.groovy.control.CompilerConfiguration");
        Class<?> javaStubCompilationUnitClass = Class.forName("org.codehaus.groovy.tools.javac.JavaStubCompilationUnit");
        Class<?> groovyClassLoaderClass = Class.forName("groovy.lang.GroovyClassLoader");
        Object compilerConfiguration = ReflectionUtils.invokeConstructor(ReflectionUtils.findConstructor(compilerConfigurationClass, new Class[0]), new Object[0]);
        ReflectionUtils.invokeMethod(ReflectionUtils.findMethod(compilerConfigurationClass, "setDebug", Boolean.TYPE), compilerConfiguration, this.debug);
        ReflectionUtils.invokeMethod(ReflectionUtils.findMethod(compilerConfigurationClass, "setVerbose", Boolean.TYPE), compilerConfiguration, this.verbose);
        ReflectionUtils.invokeMethod(ReflectionUtils.findMethod(compilerConfigurationClass, "setWarningLevel", Integer.TYPE), compilerConfiguration, this.warningLevel);
        ReflectionUtils.invokeMethod(ReflectionUtils.findMethod(compilerConfigurationClass, "setTolerance", Integer.TYPE), compilerConfiguration, this.tolerance);
        ReflectionUtils.invokeMethod(ReflectionUtils.findMethod(compilerConfigurationClass, "setTargetBytecode", String.class), compilerConfiguration, this.targetBytecode);
        if (this.sourceEncoding != null) {
            ReflectionUtils.invokeMethod(ReflectionUtils.findMethod(compilerConfigurationClass, "setSourceEncoding", String.class), compilerConfiguration, this.sourceEncoding);
        }
        HashMap<String, Comparable<File>> options = new HashMap<String, Comparable<File>>();
        options.put("stubDir", outputDirectory);
        options.put("keepStubs", Boolean.TRUE);
        ReflectionUtils.invokeMethod(ReflectionUtils.findMethod(compilerConfigurationClass, "setJointCompilationOptions", Map.class), compilerConfiguration, options);
        ClassLoader parent = ClassLoader.getSystemClassLoader();
        Object groovyClassLoader = ReflectionUtils.invokeConstructor(ReflectionUtils.findConstructor(groovyClassLoaderClass, ClassLoader.class, compilerConfigurationClass), parent, compilerConfiguration);
        Object javaStubCompilationUnit = ReflectionUtils.invokeConstructor(ReflectionUtils.findConstructor(javaStubCompilationUnitClass, compilerConfigurationClass, groovyClassLoaderClass, File.class), compilerConfiguration, groovyClassLoader, outputDirectory);
        this.getLog().debug((CharSequence)"Classpath: ");
        if (classpath != null) {
            for (Object classpathElement : classpath) {
                ReflectionUtils.invokeMethod(ReflectionUtils.findMethod(groovyClassLoaderClass, "addURL", URL.class), groovyClassLoader, new File((String)classpathElement).toURI().toURL());
                if (!this.getLog().isDebugEnabled()) continue;
                this.getLog().debug((CharSequence)("    " + classpathElement));
            }
        }
        this.getLog().debug((CharSequence)"Adding Groovy to generate stubs for:");
        for (File source : stubSources) {
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)("    " + source));
            }
            if (this.getGroovyVersion().compareTo(new Version(1, 8, 3)) >= 0 && (this.getGroovyVersion().compareTo(new Version(1, 9, 0, "beta-1")) < 0 || this.getGroovyVersion().compareTo(new Version(1, 9, 0, "beta-3")) > 0)) {
                Set<String> extensions = this.scriptExtensions != null && !this.scriptExtensions.isEmpty() ? this.scriptExtensions : DotGroovyFile.defaultScriptExtensions();
                ReflectionUtils.invokeMethod(ReflectionUtils.findMethod(compilerConfigurationClass, "setScriptExtensions", Set.class), compilerConfiguration, extensions);
                ReflectionUtils.invokeMethod(ReflectionUtils.findMethod(javaStubCompilationUnitClass, "addSource", File.class), javaStubCompilationUnit, source);
                continue;
            }
            DotGroovyFile dotGroovyFile = new DotGroovyFile(source);
            Set<String> extensions = this.scriptExtensions != null && !this.scriptExtensions.isEmpty() ? this.scriptExtensions : DotGroovyFile.defaultScriptExtensions();
            dotGroovyFile.setScriptExtensions(extensions);
            ReflectionUtils.invokeMethod(ReflectionUtils.findMethod(javaStubCompilationUnitClass, "addSource", File.class), javaStubCompilationUnit, dotGroovyFile);
        }
        ReflectionUtils.invokeMethod(ReflectionUtils.findMethod(javaStubCompilationUnitClass, "compile", new Class[0]), javaStubCompilationUnit, new Object[0]);
        this.getLog().info((CharSequence)("Generated " + this.getStubs().size() + " stub" + (this.getStubs().size() > 1 || this.getStubs().size() == 0 ? "s" : "") + "."));
    }

    protected void resetStubModifiedDates(Set<File> stubs) {
        for (File stub : stubs) {
            boolean success = stub.setLastModified(0L);
            if (success) continue;
            this.getLog().warn((CharSequence)("Unable to set modified time on stub " + stub.getAbsolutePath() + "."));
        }
    }
}

