/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.gmavenplus.mojo;

import com.google.common.io.Closer;
import com.google.common.io.Files;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import org.apache.maven.shared.model.fileset.FileSet;
import org.apache.maven.shared.model.fileset.util.FileSetManager;
import org.codehaus.gmavenplus.groovyworkarounds.GroovyDocTemplateInfo;
import org.codehaus.gmavenplus.model.Scopes;
import org.codehaus.gmavenplus.model.Version;
import org.codehaus.gmavenplus.mojo.AbstractGroovySourcesMojo;
import org.codehaus.gmavenplus.mojo.Link;
import org.codehaus.gmavenplus.util.ReflectionUtils;

public abstract class AbstractGroovydocMojo
extends AbstractGroovySourcesMojo {
    protected File groovydocOutputDirectory;
    protected File testGroovydocOutputDirectory;
    protected String windowTitle;
    protected String docTitle;
    protected String footer;
    protected String header;
    protected boolean displayAuthor;
    protected File overviewFile;
    protected File stylesheetFile;
    protected String stylesheetEncoding;
    protected String scope;
    protected List<Link> links;
    protected boolean groovydocJavaSources;

    protected void generateGroovydoc(FileSet[] sourceDirectories, File outputDirectory) throws ClassNotFoundException, InvocationTargetException, IllegalAccessException, InstantiationException {
        Object groovyDocTool;
        if (sourceDirectories == null || sourceDirectories.length == 0) {
            this.getLog().info((CharSequence)"No source directories specified for Groovydoc generation.  Skipping.");
            return;
        }
        if (this.getGroovyVersion().compareTo(new Version(1, 6, 0, "RC-1")) == 0) {
            this.getLog().warn((CharSequence)"Groovy 1.6-RC-1 is blacklisted from the supported Groovydoc versions because of its dependency on Ant.  Skipping Groovydoc generation.");
            return;
        }
        Class<?> groovyDocToolClass = Class.forName("org.codehaus.groovy.tools.groovydoc.GroovyDocTool");
        Class<?> outputToolClass = Class.forName("org.codehaus.groovy.tools.groovydoc.OutputTool");
        Class<?> fileOutputToolClass = Class.forName("org.codehaus.groovy.tools.groovydoc.FileOutputTool");
        Class<?> resourceManagerClass = Class.forName("org.codehaus.groovy.tools.groovydoc.ResourceManager");
        Class<?> classpathResourceManagerClass = Class.forName("org.codehaus.groovy.tools.groovydoc.ClasspathResourceManager");
        Properties properties = new Properties();
        properties.setProperty("windowTitle", this.windowTitle);
        properties.setProperty("docTitle", this.docTitle);
        properties.setProperty("footer", this.footer);
        properties.setProperty("header", this.header);
        properties.setProperty("author", Boolean.toString(this.displayAuthor));
        properties.setProperty("overviewFile", this.overviewFile != null ? this.overviewFile.getAbsolutePath() : "");
        try {
            Scopes scopeVal = Scopes.valueOf(this.scope.toUpperCase());
            if (scopeVal.equals((Object)Scopes.PUBLIC)) {
                properties.setProperty("publicScope", "true");
            } else if (scopeVal.equals((Object)Scopes.PROTECTED)) {
                properties.setProperty("protectedScope", "true");
            } else if (scopeVal.equals((Object)Scopes.PACKAGE)) {
                properties.setProperty("packageScope", "true");
            } else if (scopeVal.equals((Object)Scopes.PRIVATE)) {
                properties.setProperty("privateScope", "true");
            }
        }
        catch (IllegalArgumentException e) {
            this.getLog().warn((CharSequence)("Scope (" + this.scope + ") was not recognized.  Skipping argument."));
        }
        Object fileOutputTool = ReflectionUtils.invokeConstructor(ReflectionUtils.findConstructor(fileOutputToolClass, new Class[0]), new Object[0]);
        Object classpathResourceManager = ReflectionUtils.invokeConstructor(ReflectionUtils.findConstructor(classpathResourceManagerClass, new Class[0]), new Object[0]);
        FileSetManager fileSetManager = new FileSetManager(this.getLog());
        ArrayList<String> sourceDirectoriesStrings = new ArrayList<String>();
        for (FileSet sourceDirectory : sourceDirectories) {
            sourceDirectoriesStrings.add(sourceDirectory.getDirectory());
        }
        GroovyDocTemplateInfo groovyDocTemplateInfo = new GroovyDocTemplateInfo(this.getGroovyVersion());
        ArrayList<Object> linksList = new ArrayList<Object>();
        if (this.links != null && this.links.size() > 0) {
            Class<?> linkArgumentClass = null;
            if (this.getGroovyVersion().compareTo(new Version(1, 6, 0, "RC-2")) >= 0) {
                linkArgumentClass = Class.forName("org.codehaus.groovy.tools.groovydoc.LinkArgument");
            } else if (this.getGroovyVersion().compareTo(new Version(1, 5, 2)) >= 0) {
                linkArgumentClass = Class.forName("org.codehaus.groovy.ant.Groovydoc$LinkArgument");
            }
            if (linkArgumentClass != null) {
                for (Link link : this.links) {
                    Object linkArgument = ReflectionUtils.invokeConstructor(ReflectionUtils.findConstructor(linkArgumentClass, new Class[0]), new Object[0]);
                    ReflectionUtils.invokeMethod(ReflectionUtils.findMethod(linkArgumentClass, "setHref", String.class), linkArgument, link.getHref());
                    ReflectionUtils.invokeMethod(ReflectionUtils.findMethod(linkArgumentClass, "setPackages", String.class), linkArgument, link.getPackages());
                    linksList.add(linkArgument);
                }
            } else {
                this.getLog().warn((CharSequence)"Requested to use Groovydoc links, but your Groovy version doesn't support it (must be 1.5.2 or newer).  Ignoring links parameter.");
            }
        }
        if (this.getGroovyVersion().compareTo(new Version(1, 6, 0, "RC-2")) < 0) {
            this.getLog().warn((CharSequence)"Your Groovy version doesn't support Groovydoc documentation properties (docTitle, footer, header, displayAuthor, overviewFile, and scope).  You need Groovy 1.6-RC-2 or newer to support this.  Ignoring properties.");
        }
        if (this.getGroovyVersion().compareTo(new Version(1, 6, 0, "RC-2")) >= 0) {
            groovyDocTool = ReflectionUtils.invokeConstructor(ReflectionUtils.findConstructor(groovyDocToolClass, resourceManagerClass, String[].class, String[].class, String[].class, String[].class, List.class, Properties.class), classpathResourceManager, sourceDirectoriesStrings.toArray(new String[sourceDirectoriesStrings.size()]), groovyDocTemplateInfo.defaultDocTemplates(), groovyDocTemplateInfo.defaultPackageTemplates(), groovyDocTemplateInfo.defaultClassTemplates(), linksList, properties);
        } else if (this.getGroovyVersion().compareTo(new Version(1, 5, 2)) >= 0) {
            groovyDocTool = ReflectionUtils.invokeConstructor(ReflectionUtils.findConstructor(groovyDocToolClass, resourceManagerClass, String.class, String[].class, String[].class, String[].class, List.class), classpathResourceManager, sourceDirectoriesStrings.get(0), groovyDocTemplateInfo.defaultDocTemplates(), groovyDocTemplateInfo.defaultPackageTemplates(), groovyDocTemplateInfo.defaultClassTemplates(), linksList);
            if (sourceDirectoriesStrings.size() > 1) {
                this.getLog().warn((CharSequence)("Your Groovy version doesn't support more than one Groovydoc source directory (must be 1.6-RC-2 or newer).  Only using first source directory (" + (String)sourceDirectoriesStrings.get(0) + ")."));
            }
        } else {
            groovyDocTool = ReflectionUtils.invokeConstructor(ReflectionUtils.findConstructor(groovyDocToolClass, resourceManagerClass, String.class, String[].class, String[].class, String[].class), classpathResourceManager, sourceDirectoriesStrings.get(0), groovyDocTemplateInfo.defaultDocTemplates(), groovyDocTemplateInfo.defaultPackageTemplates(), groovyDocTemplateInfo.defaultClassTemplates());
            if (sourceDirectoriesStrings.size() > 1) {
                this.getLog().warn((CharSequence)("Your Groovy version doesn't support more than one Groovydoc source directory (must be 1.6-RC-2 or newer).  Only using first source directory (" + (String)sourceDirectoriesStrings.get(0) + ")."));
            }
        }
        ArrayList<String> javaSources = new ArrayList<String>();
        ArrayList<String> groovySources = new ArrayList<String>();
        ArrayList<String> possibleGroovyStubs = new ArrayList<String>();
        for (FileSet sourceDirectory : sourceDirectories) {
            List<String> sources = Arrays.asList(fileSetManager.getIncludedFiles(sourceDirectory));
            for (String source : sources) {
                if (source.endsWith(".java") && !javaSources.contains(source)) {
                    javaSources.add(source);
                    continue;
                }
                if (groovySources.contains(source)) continue;
                groovySources.add(source);
                possibleGroovyStubs.add(source.replaceFirst("\\." + Files.getFileExtension((String)source), ".java"));
            }
        }
        javaSources.removeAll(possibleGroovyStubs);
        ArrayList<String> groovydocSources = new ArrayList<String>();
        groovydocSources.addAll(javaSources);
        groovydocSources.addAll(groovySources);
        this.getLog().debug((CharSequence)"Adding sources to generate Groovydoc for:");
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)("    " + groovydocSources));
        }
        if (this.getGroovyVersion().compareTo(new Version(1, 6, 0, "RC-2")) >= 0) {
            ReflectionUtils.invokeMethod(ReflectionUtils.findMethod(groovyDocToolClass, "add", List.class), groovyDocTool, groovydocSources);
        } else {
            for (String groovydocSource : groovydocSources) {
                ReflectionUtils.invokeMethod(ReflectionUtils.findMethod(groovyDocToolClass, "add", String.class), groovyDocTool, groovydocSource);
            }
        }
        ReflectionUtils.invokeMethod(ReflectionUtils.findMethod(groovyDocToolClass, "renderToOutput", outputToolClass, String.class), groovyDocTool, fileOutputTool, outputDirectory.getAbsolutePath());
        if (this.stylesheetFile != null) {
            this.copyStylesheet(outputDirectory);
        }
    }

    private void copyStylesheet(File outputDirectory) {
        this.getLog().info((CharSequence)("Using stylesheet from " + this.stylesheetFile.getAbsolutePath() + "."));
        Closer closer = Closer.create();
        try {
            try {
                String line;
                BufferedReader bufferedReader = (BufferedReader)closer.register((Closeable)new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.stylesheetFile), this.stylesheetEncoding)));
                StringBuilder css = new StringBuilder();
                while ((line = bufferedReader.readLine()) != null) {
                    css.append(line).append("\n");
                }
                File outfile = new File(outputDirectory, "stylesheet.css");
                BufferedWriter bufferedWriter = (BufferedWriter)closer.register((Closeable)new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(outfile), this.stylesheetEncoding)));
                bufferedWriter.write(css.toString());
            }
            catch (Throwable throwable) {
                throw closer.rethrow(throwable);
            }
            finally {
                closer.close();
            }
        }
        catch (IOException e) {
            this.getLog().warn((CharSequence)("Unable to copy specified stylesheet (" + this.stylesheetFile.getAbsolutePath() + ")."));
        }
    }
}

