/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.gmavenplus.mojo;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.security.CodeSource;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.maven.plugins.annotations.Parameter;
import org.codehaus.gmavenplus.model.Version;
import org.codehaus.gmavenplus.mojo.AbstractGroovySourcesMojo;
import org.codehaus.gmavenplus.util.ClassWrangler;
import org.codehaus.gmavenplus.util.ReflectionUtils;

public abstract class AbstractCompileMojo
extends AbstractGroovySourcesMojo {
    protected static final Version GROOVY_2_5_0_ALPHA1 = new Version(2, 5, 0, "alpha-1");
    protected static final Version GROOVY_2_3_3 = new Version(2, 3, 3);
    protected static final Version GROOVY_2_1_3 = new Version(2, 1, 3);
    protected static final Version GROOVY_2_1_0_BETA1 = new Version(2, 1, 0, "beta-1");
    protected static final Version GROOVY_2_0_0_BETA3 = new Version(2, 0, 0, "beta-3");
    protected static final Version GROOVY_1_6_0 = new Version(1, 6, 0);
    @Parameter(defaultValue="${project.build.sourceEncoding}")
    protected String sourceEncoding;
    @Parameter(property="maven.compiler.target", defaultValue="1.5")
    protected String targetBytecode;
    @Parameter(defaultValue="false")
    protected boolean debug;
    @Parameter(defaultValue="false")
    protected boolean verbose;
    @Parameter(defaultValue="1")
    protected int warningLevel;
    @Parameter(defaultValue="0")
    protected int tolerance;
    @Parameter(property="invokeDynamic", defaultValue="false")
    protected boolean invokeDynamic;
    @Parameter(property="configScript")
    protected File configScript;
    @Parameter(property="parameters", defaultValue="false")
    protected boolean parameters;

    protected synchronized void doCompile(Set<File> sources, List classpath, File compileOutputDirectory) throws ClassNotFoundException, InstantiationException, IllegalAccessException, InvocationTargetException, MalformedURLException {
        this.classWrangler = new ClassWrangler(classpath, this.getLog());
        if (sources == null || sources.isEmpty()) {
            this.getLog().info((CharSequence)"No sources specified for compilation.  Skipping.");
            return;
        }
        this.logPluginClasspath();
        this.classWrangler.logGroovyVersion(this.mojoExecution.getMojoDescriptor().getGoal());
        if (!this.groovyVersionSupportsAction()) {
            this.getLog().error((CharSequence)("Your Groovy version (" + this.classWrangler.getGroovyVersionString() + ") doesn't support compilation.  The minimum version of Groovy required is " + this.minGroovyVersion + ".  Skipping compiling."));
            return;
        }
        this.verifyGroovyVersionSupportsTargetBytecode();
        Class<?> compilerConfigurationClass = this.classWrangler.getClass("org.codehaus.groovy.control.CompilerConfiguration");
        Class<?> compilationUnitClass = this.classWrangler.getClass("org.codehaus.groovy.control.CompilationUnit");
        Class<?> groovyClassLoaderClass = this.classWrangler.getClass("groovy.lang.GroovyClassLoader");
        Object compilerConfiguration = this.setupCompilerConfiguration(compileOutputDirectory, compilerConfigurationClass);
        Object groovyClassLoader = ReflectionUtils.invokeConstructor(ReflectionUtils.findConstructor(groovyClassLoaderClass, ClassLoader.class, compilerConfigurationClass), this.classWrangler.getClassLoader(), compilerConfiguration);
        Object transformLoader = ReflectionUtils.invokeConstructor(ReflectionUtils.findConstructor(groovyClassLoaderClass, ClassLoader.class), this.classWrangler.getClassLoader());
        Object compilationUnit = this.setupCompilationUnit(sources, compilerConfigurationClass, compilationUnitClass, groovyClassLoaderClass, compilerConfiguration, groovyClassLoader, transformLoader);
        ReflectionUtils.invokeMethod(ReflectionUtils.findMethod(compilationUnitClass, "compile", new Class[0]), compilationUnit, new Object[0]);
        List classes = (List)ReflectionUtils.invokeMethod(ReflectionUtils.findMethod(compilationUnitClass, "getClasses", new Class[0]), compilationUnit, new Object[0]);
        this.getLog().info((CharSequence)("Compiled " + classes.size() + " file" + (classes.size() > 1 || classes.size() == 0 ? "s" : "") + "."));
    }

    protected Object setupCompilationUnit(Set<File> sources, Class<?> compilerConfigurationClass, Class<?> compilationUnitClass, Class<?> groovyClassLoaderClass, Object compilerConfiguration, Object groovyClassLoader, Object transformLoader) throws InvocationTargetException, IllegalAccessException, InstantiationException {
        Object compilationUnit = this.groovyAtLeast(GROOVY_1_6_0) ? ReflectionUtils.invokeConstructor(ReflectionUtils.findConstructor(compilationUnitClass, compilerConfigurationClass, CodeSource.class, groovyClassLoaderClass, groovyClassLoaderClass), compilerConfiguration, null, groovyClassLoader, transformLoader) : ReflectionUtils.invokeConstructor(ReflectionUtils.findConstructor(compilationUnitClass, compilerConfigurationClass, CodeSource.class, groovyClassLoaderClass), compilerConfiguration, null, groovyClassLoader);
        this.getLog().debug((CharSequence)"Adding Groovy to compile:");
        Method addSourceMethod = ReflectionUtils.findMethod(compilationUnitClass, "addSource", File.class);
        for (File source : sources) {
            this.getLog().debug((CharSequence)("    " + source));
            ReflectionUtils.invokeMethod(addSourceMethod, compilationUnit, source);
        }
        return compilationUnit;
    }

    protected Object setupCompilerConfiguration(File compileOutputDirectory, Class<?> compilerConfigurationClass) throws InvocationTargetException, IllegalAccessException, InstantiationException, ClassNotFoundException {
        Object compilerConfiguration = ReflectionUtils.invokeConstructor(ReflectionUtils.findConstructor(compilerConfigurationClass, new Class[0]), new Object[0]);
        if (this.configScript != null) {
            if (!this.configScript.exists()) {
                this.getLog().warn((CharSequence)("Configuration script file (" + this.configScript.getAbsolutePath() + ") doesn't exist.  Ignoring configScript parameter."));
            } else if (this.groovyOlderThan(GROOVY_2_1_0_BETA1)) {
                this.getLog().warn((CharSequence)("Requested to use configScript, but your Groovy version (" + this.classWrangler.getGroovyVersionString() + ") doesn't support it (must be " + GROOVY_2_1_0_BETA1 + " or newer).  Ignoring configScript parameter."));
            } else {
                Class<?> bindingClass = this.classWrangler.getClass("groovy.lang.Binding");
                Class<?> importCustomizerClass = this.classWrangler.getClass("org.codehaus.groovy.control.customizers.ImportCustomizer");
                Class<?> groovyShellClass = this.classWrangler.getClass("groovy.lang.GroovyShell");
                Object binding = ReflectionUtils.invokeConstructor(ReflectionUtils.findConstructor(bindingClass, new Class[0]), new Object[0]);
                ReflectionUtils.invokeMethod(ReflectionUtils.findMethod(bindingClass, "setVariable", String.class, Object.class), binding, "configuration", compilerConfiguration);
                Object shellCompilerConfiguration = ReflectionUtils.invokeConstructor(ReflectionUtils.findConstructor(compilerConfigurationClass, new Class[0]), new Object[0]);
                Object importCustomizer = ReflectionUtils.invokeConstructor(ReflectionUtils.findConstructor(importCustomizerClass, new Class[0]), new Object[0]);
                ReflectionUtils.invokeMethod(ReflectionUtils.findMethod(importCustomizerClass, "addStaticStar", String.class), importCustomizer, "org.codehaus.groovy.control.customizers.builder.CompilerCustomizationBuilder");
                List compilationCustomizers = (List)ReflectionUtils.invokeMethod(ReflectionUtils.findMethod(compilerConfigurationClass, "getCompilationCustomizers", new Class[0]), shellCompilerConfiguration, new Object[0]);
                compilationCustomizers.add(importCustomizer);
                Object shell = ReflectionUtils.invokeConstructor(ReflectionUtils.findConstructor(groovyShellClass, bindingClass, compilerConfigurationClass), binding, shellCompilerConfiguration);
                this.getLog().debug((CharSequence)("Using configuration script " + this.configScript + " for compilation."));
                ReflectionUtils.invokeMethod(ReflectionUtils.findMethod(groovyShellClass, "evaluate", File.class), shell, this.configScript);
            }
        }
        ReflectionUtils.invokeMethod(ReflectionUtils.findMethod(compilerConfigurationClass, "setDebug", Boolean.TYPE), compilerConfiguration, this.debug);
        ReflectionUtils.invokeMethod(ReflectionUtils.findMethod(compilerConfigurationClass, "setVerbose", Boolean.TYPE), compilerConfiguration, this.verbose);
        ReflectionUtils.invokeMethod(ReflectionUtils.findMethod(compilerConfigurationClass, "setWarningLevel", Integer.TYPE), compilerConfiguration, this.warningLevel);
        ReflectionUtils.invokeMethod(ReflectionUtils.findMethod(compilerConfigurationClass, "setTolerance", Integer.TYPE), compilerConfiguration, this.tolerance);
        ReflectionUtils.invokeMethod(ReflectionUtils.findMethod(compilerConfigurationClass, "setTargetBytecode", String.class), compilerConfiguration, this.targetBytecode);
        if (this.sourceEncoding != null) {
            ReflectionUtils.invokeMethod(ReflectionUtils.findMethod(compilerConfigurationClass, "setSourceEncoding", String.class), compilerConfiguration, this.sourceEncoding);
        }
        ReflectionUtils.invokeMethod(ReflectionUtils.findMethod(compilerConfigurationClass, "setTargetDirectory", String.class), compilerConfiguration, compileOutputDirectory.getAbsolutePath());
        if (this.invokeDynamic) {
            if (this.groovyAtLeast(GROOVY_2_0_0_BETA3)) {
                if (this.classWrangler.isGroovyIndy()) {
                    if (this.isJavaSupportIndy()) {
                        Map optimizationOptions = (Map)ReflectionUtils.invokeMethod(ReflectionUtils.findMethod(compilerConfigurationClass, "getOptimizationOptions", new Class[0]), compilerConfiguration, new Object[0]);
                        optimizationOptions.put("indy", true);
                        optimizationOptions.put("int", false);
                    } else {
                        this.getLog().warn((CharSequence)("Requested to use to use invokedynamic, but your Java version (" + this.getJavaVersionString() + ") doesn't support it.  Ignoring invokeDynamic parameter."));
                    }
                } else {
                    this.getLog().warn((CharSequence)"Requested to use invokedynamic, but your Groovy version doesn't support it (must use have indy classifier).  Ignoring invokeDynamic parameter.");
                }
            } else {
                this.getLog().warn((CharSequence)("Requested to use invokeDynamic, but your Groovy version (" + this.classWrangler.getGroovyVersionString() + ") doesn't support it (must be " + GROOVY_2_0_0_BETA3 + " or newer).  Ignoring invokeDynamic parameter."));
            }
        }
        if (this.parameters) {
            if (this.groovyAtLeast(GROOVY_2_5_0_ALPHA1)) {
                if (this.isJavaSupportParameters()) {
                    ReflectionUtils.invokeMethod(ReflectionUtils.findMethod(compilerConfigurationClass, "setParameters", Boolean.TYPE), compilerConfiguration, this.parameters);
                } else {
                    this.getLog().warn((CharSequence)("Requested to use to use parameters, but your Java version (" + this.getJavaVersionString() + ") doesn't support it.  Ignoring parameters parameter."));
                }
            } else {
                this.getLog().warn((CharSequence)("Requested to use parameters, but your Groovy version (" + this.classWrangler.getGroovyVersionString() + ") doesn't support it (must be " + GROOVY_2_5_0_ALPHA1 + " or newer).  Ignoring parameters parameter."));
            }
        }
        return compilerConfiguration;
    }

    protected void verifyGroovyVersionSupportsTargetBytecode() {
        if ("1.9".equals(this.targetBytecode)) {
            throw new IllegalArgumentException("Target bytecode 1.9 is not yet supported.");
        }
        if ("1.8".equals(this.targetBytecode)) {
            if (this.groovyOlderThan(GROOVY_2_3_3)) {
                throw new IllegalArgumentException("Target bytecode 1.8 requires Groovy " + GROOVY_2_3_3 + " or newer.");
            }
        } else if ("1.7".equals(this.targetBytecode) || "1.6".equals(this.targetBytecode)) {
            if (this.groovyOlderThan(GROOVY_2_1_3)) {
                throw new IllegalArgumentException("Target bytecode 1.6 and 1.7 require Groovy " + GROOVY_2_1_3 + " or newer.");
            }
        } else if (!"1.5".equals(this.targetBytecode) && !"1.4".equals(this.targetBytecode)) {
            throw new IllegalArgumentException("Unrecognized target bytecode.");
        }
    }
}

