/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.gmavenplus.mojo;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.util.Set;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.codehaus.gmavenplus.mojo.AbstractToolsMojo;
import org.codehaus.gmavenplus.util.NoExitSecurityManager;
import org.codehaus.gmavenplus.util.ReflectionUtils;

@Mojo(name="console", requiresDependencyResolution=ResolutionScope.TEST, configurator="include-project-test-dependencies")
public class ConsoleMojo
extends AbstractToolsMojo {
    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            this.setupClassWrangler(this.project.getTestClasspathElements(), this.useSharedClassLoader);
        }
        catch (MalformedURLException e) {
            throw new MojoExecutionException("Unable to add project test dependencies to classpath.", (Exception)e);
        }
        catch (DependencyResolutionRequiredException e) {
            throw new MojoExecutionException("Test dependencies weren't resolved.", (Exception)((Object)e));
        }
        this.logPluginClasspath();
        this.classWrangler.logGroovyVersion(this.mojoExecution.getMojoDescriptor().getGoal());
        try {
            this.getLog().debug((CharSequence)("Project test classpath:\n" + this.project.getTestClasspathElements()));
        }
        catch (DependencyResolutionRequiredException e) {
            this.getLog().warn((CharSequence)"Unable to log project test classpath", (Throwable)e);
        }
        if (this.groovyVersionSupportsAction()) {
            SecurityManager sm = System.getSecurityManager();
            try {
                if (!this.allowSystemExits) {
                    System.setSecurityManager(new NoExitSecurityManager());
                }
                Class<?> consoleClass = this.classWrangler.getClass("groovy.ui.Console");
                Class<?> bindingClass = this.classWrangler.getClass("groovy.lang.Binding");
                Object console = this.setupConsole(consoleClass, bindingClass);
                ReflectionUtils.invokeMethod(ReflectionUtils.findMethod(consoleClass, "run", new Class[0]), console, new Object[0]);
                this.bindAntBuilder(consoleClass, bindingClass, console);
                this.waitForConsoleClose();
            }
            catch (ClassNotFoundException e) {
                throw new MojoExecutionException("Unable to get a Groovy class from classpath (" + e.getMessage() + "). Do you have Groovy as a compile dependency in your project or the plugin?", (Exception)e);
            }
            catch (InvocationTargetException e) {
                if (e.getCause() instanceof NoClassDefFoundError && "org/apache/ivy/core/report/ResolveReport".equals(e.getCause().getMessage())) {
                    throw new MojoExecutionException("Groovy 1.7.6 and 1.7.7 have a dependency on Ivy to run the console. Either change your Groovy version or add Ivy as a project or plugin dependency.", (Exception)e);
                }
                throw new MojoExecutionException("Error occurred while calling a method on a Groovy class from classpath.", (Exception)e);
            }
            catch (IllegalAccessException e) {
                throw new MojoExecutionException("Unable to access a method on a Groovy class from classpath.", (Exception)e);
            }
            catch (InstantiationException e) {
                throw new MojoExecutionException("Error occurred while instantiating a Groovy class from classpath.", (Exception)e);
            }
            finally {
                if (!this.allowSystemExits) {
                    System.setSecurityManager(sm);
                }
            }
        } else {
            this.getLog().error((CharSequence)("Your Groovy version (" + this.classWrangler.getGroovyVersionString() + ") doesn't support running a console. The minimum version of Groovy required is " + this.minGroovyVersion + ". Skipping console startup."));
        }
    }

    protected Object setupConsole(Class<?> consoleClass, Class<?> bindingClass) throws InvocationTargetException, IllegalAccessException, InstantiationException {
        Object binding = ReflectionUtils.invokeConstructor(ReflectionUtils.findConstructor(bindingClass, new Class[0]), new Object[0]);
        this.initializeProperties();
        Method setVariable = ReflectionUtils.findMethod(bindingClass, "setVariable", String.class, Object.class);
        if (this.bindPropertiesToSeparateVariables) {
            for (Object k : this.properties.keySet()) {
                ReflectionUtils.invokeMethod(setVariable, binding, k, this.properties.get(k));
            }
        } else {
            ReflectionUtils.invokeMethod(setVariable, binding, "properties", this.properties);
        }
        return ReflectionUtils.invokeConstructor(ReflectionUtils.findConstructor(consoleClass, ClassLoader.class, bindingClass), Thread.currentThread().getContextClassLoader(), binding);
    }

    protected void bindAntBuilder(Class<?> consoleClass, Class<?> bindingClass, Object console) throws ClassNotFoundException, IllegalAccessException, InvocationTargetException, InstantiationException {
        if (this.properties.containsKey("ant")) {
            Class<?> groovyShellClass = this.classWrangler.getClass("groovy.lang.GroovyShell");
            Object shell = ReflectionUtils.getField(ReflectionUtils.findField(consoleClass, "shell", groovyShellClass), console);
            Object binding = ReflectionUtils.invokeMethod(ReflectionUtils.findMethod(groovyShellClass, "getContext", new Class[0]), shell, new Object[0]);
            Object antBuilder = ReflectionUtils.invokeConstructor(ReflectionUtils.findConstructor(this.classWrangler.getClass("groovy.util.AntBuilder"), new Class[0]), new Object[0]);
            if (this.bindPropertiesToSeparateVariables) {
                ReflectionUtils.invokeMethod(ReflectionUtils.findMethod(bindingClass, "setVariable", String.class, Object.class), binding, "ant", antBuilder);
            } else {
                this.properties.put("ant", antBuilder);
            }
        }
    }

    protected void waitForConsoleClose() throws MojoFailureException {
        Set<Thread> threadSet = Thread.getAllStackTraces().keySet();
        Thread[] threadArray = threadSet.toArray(new Thread[0]);
        Thread consoleThread = null;
        for (Thread thread : threadArray) {
            if (!"AWT-Shutdown".equals(thread.getName())) continue;
            consoleThread = thread;
            break;
        }
        if (consoleThread != null) {
            try {
                consoleThread.join();
            }
            catch (InterruptedException e) {
                throw new MojoFailureException("Mojo interrupted while waiting for Console thread to end.", (Throwable)e);
            }
        } else {
            throw new MojoFailureException("Unable to locate Console thread to wait on.");
        }
    }
}

