/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.gmavenplus.mojo;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.shared.model.fileset.FileSet;
import org.codehaus.gmavenplus.mojo.AbstractGenerateStubsMojo;

@Mojo(name="generateTestStubs", defaultPhase=LifecyclePhase.GENERATE_TEST_SOURCES, requiresDependencyResolution=ResolutionScope.TEST, threadSafe=true, configurator="include-project-test-dependencies")
public class GenerateTestStubsMojo
extends AbstractGenerateStubsMojo {
    @Parameter
    protected FileSet[] testSources;
    @Parameter(defaultValue="${project.build.directory}/generated-sources/groovy-stubs/test")
    protected File testStubsOutputDirectory;
    @Parameter(property="maven.test.skip", defaultValue="false")
    protected boolean skipTests;

    public void execute() throws MojoExecutionException {
        if (!this.skipTests) {
            this.minGroovyVersion = GROOVY_1_8_2;
            try {
                try {
                    this.getLog().debug((CharSequence)("Project test classpath:\n" + this.project.getTestClasspathElements()));
                }
                catch (DependencyResolutionRequiredException e) {
                    this.getLog().debug((CharSequence)"Unable to log project test classpath");
                }
                this.doStubGeneration(this.getTestFiles(this.testSources, false), this.project.getTestClasspathElements(), this.testStubsOutputDirectory);
                this.logGeneratedStubs(this.testStubsOutputDirectory);
                this.resetStubModifiedDates(this.getStubs(this.testStubsOutputDirectory));
                this.project.addTestCompileSourceRoot(this.testStubsOutputDirectory.getAbsolutePath());
            }
            catch (ClassNotFoundException e) {
                throw new MojoExecutionException("Unable to get a Groovy class from classpath (" + e.getMessage() + "). Do you have Groovy as a compile dependency in your project?", (Exception)e);
            }
            catch (InvocationTargetException e) {
                throw new MojoExecutionException("Error occurred while calling a method on a Groovy class from classpath.", (Exception)e);
            }
            catch (InstantiationException e) {
                throw new MojoExecutionException("Error occurred while instantiating a Groovy class from classpath.", (Exception)e);
            }
            catch (IllegalAccessException e) {
                throw new MojoExecutionException("Unable to access a method on a Groovy class from classpath.", (Exception)e);
            }
            catch (DependencyResolutionRequiredException e) {
                throw new MojoExecutionException("Test dependencies weren't resolved.", (Exception)((Object)e));
            }
            catch (MalformedURLException e) {
                throw new MojoExecutionException("Unable to add project test dependencies to classpath.", (Exception)e);
            }
        }
        this.getLog().info((CharSequence)"Generation of test stubs is skipped.");
    }
}

