/*
 * Decompiled with CFR 0.152.
 */
package groovy.lang;

import groovy.lang.ExpandoMetaClass;
import groovy.lang.GroovySystem;
import groovy.lang.MetaClass;
import groovy.lang.MetaClassRegistry;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.codehaus.groovy.runtime.metaclass.MemoryAwareConcurrentReadMap;

public class ExpandoMetaClassCreationHandle
extends MetaClassRegistry.MetaClassCreationHandle {
    private final Map modifiedExpandos = new HashMap();
    private final MemoryAwareConcurrentReadMap parentClassToChildMap = new MemoryAwareConcurrentReadMap();

    public MetaClass create(Class theClass, MetaClassRegistry registry) {
        if (theClass != ExpandoMetaClass.class) {
            ExpandoMetaClass emc = new ExpandoMetaClass(theClass);
            emc.setAllowChangesAfterInit(true);
            Set modifiedSuperExpandos = this.retrieveModifiedSuperExpandos(emc);
            emc.refreshInheritedMethods(modifiedSuperExpandos);
            emc.initialize();
            this.registerTrackedExpando(emc);
            return emc;
        }
        return super.create(theClass, registry);
    }

    private void registerTrackedExpando(ExpandoMetaClass emc) {
        LinkedList superClassList = emc.getSuperClasses();
        Class[] superClasses = superClassList.toArray(new Class[superClassList.size()]);
        for (int i = 0; i < superClasses.length; ++i) {
            Class c = superClasses[i];
            this.registerWithParentToChildMap(emc, c);
        }
        Class<?>[] interfaces = emc.getJavaClass().getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            this.registerWithParentToChildMap(emc, interfaces[i]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerWithParentToChildMap(ExpandoMetaClass emc, Class c) {
        ExpandoMetaClassCreationHandle expandoMetaClassCreationHandle = this;
        synchronized (expandoMetaClassCreationHandle) {
            HashSet<ExpandoMetaClass> children = (HashSet<ExpandoMetaClass>)this.parentClassToChildMap.get(c);
            if (children == null) {
                children = new HashSet<ExpandoMetaClass>();
                this.parentClassToChildMap.put(c, children);
            }
            children.add(emc);
        }
    }

    public void notifyOfMetaClassChange(ExpandoMetaClass changed) {
        Set subMetas = this.retrieveKnownSubclasses(changed);
        if (subMetas != null) {
            Iterator i = subMetas.iterator();
            while (i.hasNext()) {
                ExpandoMetaClass child = (ExpandoMetaClass)i.next();
                Set modifiedSuperExpandos = this.retrieveModifiedSuperExpandos(child);
                child.refreshInheritedMethods(modifiedSuperExpandos);
            }
        }
    }

    private Set retrieveModifiedSuperExpandos(ExpandoMetaClass child) {
        HashSet modifiedSupers = new HashSet();
        LinkedList superClasses = child.getSuperClasses();
        Iterator i = superClasses.iterator();
        while (i.hasNext()) {
            Class c = (Class)i.next();
            Class[] interfaces = c.getInterfaces();
            this.populateSupersFromInterfaces(modifiedSupers, interfaces);
            if (!this.modifiedExpandos.containsKey(c)) continue;
            modifiedSupers.add(this.modifiedExpandos.get(c));
        }
        Class[] interfaces = child.getJavaClass().getInterfaces();
        this.populateSupersFromInterfaces(modifiedSupers, interfaces);
        return modifiedSupers;
    }

    private void populateSupersFromInterfaces(Set modifiedSupers, Class[] interfaces) {
        for (int i = 0; i < interfaces.length; ++i) {
            Class anInterface = interfaces[i];
            if (!this.modifiedExpandos.containsKey(anInterface)) continue;
            modifiedSupers.add(this.modifiedExpandos.get(anInterface));
        }
    }

    private Set retrieveKnownSubclasses(ExpandoMetaClass changed) {
        return (Set)this.parentClassToChildMap.get(changed.getJavaClass());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerModifiedMetaClass(ExpandoMetaClass emc) {
        ExpandoMetaClassCreationHandle expandoMetaClassCreationHandle = this;
        synchronized (expandoMetaClassCreationHandle) {
            this.modifiedExpandos.put(emc.getJavaClass(), emc);
        }
    }

    public boolean hasModifiedMetaClass(ExpandoMetaClass emc) {
        return this.modifiedExpandos.containsKey(emc.getJavaClass());
    }

    public static void enable() {
        GroovySystem.getMetaClassRegistry().setMetaClassCreationHandle(new ExpandoMetaClassCreationHandle());
    }
}

