/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.control;

import java.util.Iterator;
import java.util.Map;
import org.codehaus.groovy.ast.ClassCodeExpressionTransformer;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.DynamicVariable;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.ModuleNode;
import org.codehaus.groovy.ast.Variable;
import org.codehaus.groovy.ast.expr.ClassExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.expr.PropertyExpression;
import org.codehaus.groovy.ast.expr.StaticMethodCallExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.control.CompilationUnit;
import org.codehaus.groovy.control.SourceUnit;

public class StaticImportVisitor
extends ClassCodeExpressionTransformer {
    private ClassNode currentClass;
    private CompilationUnit compilationUnit;

    public StaticImportVisitor(CompilationUnit cu) {
        this.compilationUnit = cu;
    }

    public void visitClass(ClassNode node) {
        this.currentClass = node;
        super.visitClass(node);
    }

    private Expression findStaticFieldImportFromModule(String name) {
        Map fields;
        String fieldName;
        ClassNode node;
        Expression expression;
        ModuleNode module = this.currentClass.getModule();
        if (module == null) {
            return null;
        }
        Map aliases = module.getStaticImportAliases();
        if (aliases.containsKey(name) && (expression = this.findStaticField(node = (ClassNode)aliases.get(name), fieldName = (String)(fields = module.getStaticImportFields()).get(name))) != null) {
            return expression;
        }
        Map importedClasses = module.getStaticImportClasses();
        Iterator it = importedClasses.keySet().iterator();
        while (it.hasNext()) {
            String className = (String)it.next();
            ClassNode node2 = (ClassNode)importedClasses.get(className);
            Expression expression2 = this.findStaticField(node2, name);
            if (expression2 == null) continue;
            return expression2;
        }
        return null;
    }

    private Expression findStaticField(ClassNode staticImportType, String fieldName) {
        if (staticImportType.isPrimaryClassNode() || staticImportType.isResolved()) {
            staticImportType.getFields();
            FieldNode field = staticImportType.getField(fieldName);
            if (field != null && field.isStatic()) {
                return new PropertyExpression((Expression)new ClassExpression(staticImportType), fieldName);
            }
        }
        return null;
    }

    private Expression findStaticMethodImportFromModule(Expression method, Expression args) {
        Map fields;
        String fieldName;
        ClassNode node;
        Expression expression;
        ConstantExpression ce;
        String name;
        ModuleNode module = this.currentClass.getModule();
        if (module == null || !(method instanceof ConstantExpression)) {
            return null;
        }
        Map aliases = module.getStaticImportAliases();
        if (aliases.containsKey(name = (String)(ce = (ConstantExpression)method).getValue()) && (expression = this.findStaticMethod(node = (ClassNode)aliases.get(name), fieldName = (String)(fields = module.getStaticImportFields()).get(name), args)) != null) {
            return expression;
        }
        Map importPackages = module.getStaticImportClasses();
        Iterator it = importPackages.keySet().iterator();
        while (it.hasNext()) {
            String className = (String)it.next();
            ClassNode starImportType = (ClassNode)importPackages.get(className);
            Expression expression2 = this.findStaticMethod(starImportType, name, args);
            if (expression2 == null) continue;
            return expression2;
        }
        return null;
    }

    private Expression findStaticMethod(ClassNode staticImportType, String methodName, Expression args) {
        if ((staticImportType.isPrimaryClassNode() || staticImportType.isResolved()) && staticImportType.hasPossibleStaticMethod(methodName, args)) {
            return new StaticMethodCallExpression(staticImportType, methodName, args);
        }
        return null;
    }

    public Expression transform(Expression exp) {
        if (exp == null) {
            return null;
        }
        if (exp instanceof VariableExpression) {
            return this.transformVariableExpression((VariableExpression)exp);
        }
        if (exp instanceof MethodCallExpression) {
            return this.transformMethodCallExpression((MethodCallExpression)exp);
        }
        return exp.transformExpression(this);
    }

    protected Expression transformVariableExpression(VariableExpression ve) {
        Expression result;
        Variable v = ve.getAccessedVariable();
        if (v instanceof DynamicVariable && (result = this.findStaticFieldImportFromModule(ve.getName())) != null) {
            return result;
        }
        return ve;
    }

    protected Expression transformMethodCallExpression(MethodCallExpression mce) {
        Expression args = this.transform(mce.getArguments());
        Expression method = this.transform(mce.getMethod());
        if (mce.isImplicitThis()) {
            Expression ret = this.findStaticMethodImportFromModule(method, args);
            if (ret != null) {
                return ret;
            }
            return new MethodCallExpression(mce.getObjectExpression(), method, args);
        }
        return mce;
    }

    protected SourceUnit getSourceUnit() {
        return null;
    }
}

