/*
 * Decompiled with CFR 0.152.
 */
package groovy.util;

import groovy.lang.Binding;
import groovy.lang.GroovyObjectSupport;
import groovy.lang.GroovyShell;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.codehaus.groovy.control.MultipleCompilationErrorsException;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.typehandling.GroovyCastException;

public class ProxyGenerator {
    public static Object instantiateAggregateFromBaseClass(Class clazz) {
        return ProxyGenerator.instantiateAggregateFromBaseClass(null, clazz);
    }

    public static Object instantiateAggregateFromBaseClass(Map map, Class clazz) {
        return ProxyGenerator.instantiateAggregateFromBaseClass(map, clazz, null);
    }

    public static Object instantiateAggregateFromBaseClass(Map map, Class clazz, Object[] constructorArgs) {
        return ProxyGenerator.instantiateAggregate(map, null, clazz, constructorArgs);
    }

    public static Object instantiateAggregateFromInterface(Class clazz) {
        return ProxyGenerator.instantiateAggregateFromInterface(null, clazz);
    }

    public static Object instantiateAggregateFromInterface(Map map, Class clazz) {
        ArrayList<Class> interfaces = new ArrayList<Class>();
        interfaces.add(clazz);
        return ProxyGenerator.instantiateAggregate(map, interfaces);
    }

    public static Object instantiateAggregate(List interfaces) {
        return ProxyGenerator.instantiateAggregate(null, interfaces);
    }

    public static Object instantiateAggregate(Map closureMap, List interfaces) {
        return ProxyGenerator.instantiateAggregate(closureMap, interfaces, null);
    }

    public static Object instantiateAggregate(Map closureMap, List interfaces, Class clazz) {
        return ProxyGenerator.instantiateAggregate(closureMap, interfaces, clazz, null);
    }

    public static Object instantiateAggregate(Map closureMap, List interfaces, Class clazz, Object[] constructorArgs) {
        int i;
        Class baseClass;
        Map map = new HashMap();
        if (closureMap != null) {
            map = closureMap;
        }
        List interfacesToImplement = new ArrayList();
        if (interfaces != null) {
            interfacesToImplement = interfaces;
        }
        Class clazz2 = baseClass = GroovyObjectSupport.class;
        if (clazz != null) {
            baseClass = clazz;
        }
        boolean hasArgs = constructorArgs != null && constructorArgs.length > 0;
        String name = ProxyGenerator.shortName(baseClass.getName()) + "_groovyProxy";
        StringBuffer buffer = new StringBuffer();
        buffer.append("class ").append(name);
        if (clazz != null) {
            buffer.append(" extends ").append(baseClass.getName());
        }
        for (int i2 = 0; i2 < interfacesToImplement.size(); ++i2) {
            Class thisInterface = (Class)interfacesToImplement.get(i2);
            if (i2 == 0) {
                buffer.append(" implements ");
            } else {
                buffer.append(", ");
            }
            buffer.append(thisInterface.getName());
        }
        buffer.append(" {\n").append("    private closureMap\n    ");
        buffer.append(name).append("(map");
        if (hasArgs) {
            buffer.append(", args");
        }
        buffer.append(") {\n");
        buffer.append("        super(");
        if (hasArgs) {
            buffer.append("*args");
        }
        buffer.append(")\n");
        buffer.append("        this.closureMap = map\n");
        buffer.append("    }\n");
        ArrayList<String> selectedMethods = new ArrayList<String>();
        List publicAndProtectedMethods = DefaultGroovyMethods.toList(baseClass.getMethods());
        publicAndProtectedMethods.addAll(ProxyGenerator.getInheritedMethods(baseClass));
        for (int i3 = 0; i3 < publicAndProtectedMethods.size(); ++i3) {
            Method method = (Method)publicAndProtectedMethods.get(i3);
            if (!map.containsKey(method.getName())) continue;
            selectedMethods.add(method.getName());
            ProxyGenerator.addOverridingMapCall(buffer, method);
        }
        ArrayList interfaceMethods = new ArrayList();
        for (i = 0; i < interfacesToImplement.size(); ++i) {
            Class thisInterface = (Class)interfacesToImplement.get(i);
            interfaceMethods.addAll(DefaultGroovyMethods.toList(thisInterface.getMethods()));
            interfaceMethods.addAll(ProxyGenerator.getInheritedMethods(thisInterface));
        }
        for (i = 0; i < interfaceMethods.size(); ++i) {
            Method method = (Method)interfaceMethods.get(i);
            if (ProxyGenerator.containsEquivalentMethod(publicAndProtectedMethods, method)) continue;
            selectedMethods.add(method.getName());
            ProxyGenerator.addMapOrDummyCall(map, buffer, method);
        }
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            String methodName = (String)iterator.next();
            if (selectedMethods.contains(methodName)) continue;
            ProxyGenerator.addNewMapCall(buffer, methodName);
        }
        buffer.append("}\n").append("new ").append(name);
        buffer.append("(map");
        if (hasArgs) {
            buffer.append(", constructorArgs");
        }
        buffer.append(")");
        Binding binding = new Binding();
        binding.setVariable("map", map);
        binding.setVariable("constructorArgs", constructorArgs);
        ClassLoader cl = baseClass.getClassLoader();
        if (clazz == null && interfacesToImplement.size() > 0) {
            Class c = (Class)interfacesToImplement.get(0);
            cl = c.getClassLoader();
        }
        GroovyShell shell = new GroovyShell(cl, binding);
        try {
            return shell.evaluate(buffer.toString());
        }
        catch (MultipleCompilationErrorsException err) {
            throw new GroovyCastException(map, baseClass);
        }
    }

    private static boolean containsEquivalentMethod(List publicAndProtectedMethods, Method candidate) {
        for (int i = 0; i < publicAndProtectedMethods.size(); ++i) {
            Method method = (Method)publicAndProtectedMethods.get(i);
            if (!candidate.getName().equals(method.getName()) || candidate.getParameterTypes().length != method.getParameterTypes().length || !candidate.getReturnType().equals(method.getReturnType())) continue;
            return true;
        }
        return false;
    }

    private static List getInheritedMethods(Class baseClass) {
        ArrayList<Method> protectedMethodList = new ArrayList<Method>();
        for (Class currentClass = baseClass; currentClass != null; currentClass = currentClass.getSuperclass()) {
            Method[] protectedMethods = currentClass.getDeclaredMethods();
            for (int i = 0; i < protectedMethods.length; ++i) {
                Method method = protectedMethods[i];
                if (!Modifier.isProtected(method.getModifiers())) continue;
                protectedMethodList.add(method);
            }
        }
        return protectedMethodList;
    }

    private static void addNewMapCall(StringBuffer buffer, String methodName) {
        buffer.append("    def ").append(methodName).append("(Object[] args) { \n").append("        this.@closureMap['").append(methodName).append("'] (*args)\n    }\n");
    }

    private static void addOverridingMapCall(StringBuffer buffer, Method method) {
        Class[] parameterTypes = ProxyGenerator.addMethodPrefix(buffer, method);
        ProxyGenerator.addMethodBody(buffer, method, parameterTypes);
        ProxyGenerator.addMethodSuffix(buffer);
    }

    private static void addMapOrDummyCall(Map map, StringBuffer buffer, Method method) {
        Class[] parameterTypes = ProxyGenerator.addMethodPrefix(buffer, method);
        if (map.containsKey(method.getName())) {
            ProxyGenerator.addMethodBody(buffer, method, parameterTypes);
        }
        ProxyGenerator.addMethodSuffix(buffer);
    }

    private static Class[] addMethodPrefix(StringBuffer buffer, Method method) {
        buffer.append("    ").append(ProxyGenerator.getSimpleName(method.getReturnType())).append(" ").append(method.getName()).append("(");
        Class[] parameterTypes = method.getParameterTypes();
        for (int parameterTypeIndex = 0; parameterTypeIndex < parameterTypes.length; ++parameterTypeIndex) {
            Class<?> parameter = parameterTypes[parameterTypeIndex];
            if (parameterTypeIndex != 0) {
                buffer.append(", ");
            }
            buffer.append(ProxyGenerator.getSimpleName(parameter)).append(" ").append("p").append(parameterTypeIndex);
        }
        buffer.append(") { ");
        return parameterTypes;
    }

    private static void addMethodBody(StringBuffer buffer, Method method, Class[] parameterTypes) {
        buffer.append("this.@closureMap['").append(method.getName()).append("'] (");
        for (int j = 0; j < parameterTypes.length; ++j) {
            if (j != 0) {
                buffer.append(", ");
            }
            buffer.append("p").append(j);
        }
        buffer.append(")");
    }

    private static void addMethodSuffix(StringBuffer buffer) {
        buffer.append(" }\n");
    }

    private static String getSimpleName(Class c) {
        if (c.isArray()) {
            int dimension = 0;
            Class<?> componentClass = c;
            while (componentClass.isArray()) {
                componentClass = componentClass.getComponentType();
                ++dimension;
            }
            return componentClass.getName().replaceAll("\\$", "\\.") + DefaultGroovyMethods.multiply("[]", (Number)new Integer(dimension));
        }
        return c.getName().replaceAll("\\$", "\\.");
    }

    public static String shortName(String name) {
        int index = name.lastIndexOf(46);
        if (index == -1) {
            return name;
        }
        return name.substring(index + 1, name.length());
    }
}

