/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.runtime.metaclass;

import groovy.lang.GroovyRuntimeException;
import groovy.lang.MetaMethod;
import java.lang.reflect.Modifier;
import org.codehaus.groovy.reflection.FastArray;

public class MethodSelectionException
extends GroovyRuntimeException {
    private String methodName;
    private FastArray methods;
    private Class[] arguments;

    public MethodSelectionException(String methodName, FastArray methods, Class[] arguments) {
        super(methodName);
        this.methodName = methodName;
        this.arguments = arguments;
        this.methods = methods;
    }

    public String getMessage() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("Could not find which method ").append(this.methodName);
        this.appendClassNames(buffer, this.arguments);
        buffer.append(" to invoke from this list:");
        this.appendMethods(buffer);
        return buffer.toString();
    }

    private void appendClassNames(StringBuffer argBuf, Class[] classes) {
        argBuf.append("(");
        for (int i = 0; i < classes.length; ++i) {
            Class clazz;
            if (i > 0) {
                argBuf.append(", ");
            }
            String name = (clazz = classes[i]) == null ? "null" : clazz.getName();
            argBuf.append(name);
        }
        argBuf.append(")");
    }

    private void appendMethods(StringBuffer buffer) {
        for (int i = 0; i < this.methods.size; ++i) {
            buffer.append("\n  ");
            MetaMethod method = (MetaMethod)this.methods.get(i);
            buffer.append(Modifier.toString(method.getModifiers()));
            buffer.append(" ").append(method.getReturnType().getName());
            buffer.append(" ").append(method.getDeclaringClass().getName());
            buffer.append("#");
            buffer.append(method.getName());
            this.appendClassNames(buffer, method.getNativeParameterTypes());
        }
    }
}

