/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.classgen;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.expr.AnnotationConstantExpression;
import org.codehaus.groovy.ast.expr.ClosureExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.ListExpression;
import org.codehaus.groovy.ast.expr.PropertyExpression;
import org.codehaus.groovy.control.ErrorCollector;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.control.messages.SyntaxErrorMessage;
import org.codehaus.groovy.syntax.SyntaxException;

public class AnnotationVisitor {
    private static final Class[] EMPTY_ARG_TYPES = new Class[0];
    private static final Object[] EMPTY_ARGS = new Object[0];
    private final Class annotationRootClass;
    private SourceUnit source;
    private ErrorCollector errorCollector;
    private AnnotationNode annotation;
    private Class annotationClass;
    private Map requiredAttrTypes = new HashMap();
    private Map defaultAttrTypes = new HashMap();
    static /* synthetic */ Class class$java$lang$reflect$Method;

    public AnnotationVisitor(SourceUnit source, ErrorCollector errorCollector) {
        this.source = source;
        this.errorCollector = errorCollector;
        this.annotationRootClass = this.loadAnnotationRootClass();
    }

    public AnnotationNode visit(AnnotationNode node) {
        if (!this.isValidAnnotationClass(node)) {
            node.setValid(false);
            return node;
        }
        this.annotation = node;
        if (!node.getClassNode().isResolved()) {
            this.addError("Current type was not yet resolved. Cannot introspect it.");
            node.setValid(false);
            return node;
        }
        this.annotationClass = node.getClassNode().getTypeClass();
        this.extractAnnotationMeta(this.annotationClass);
        if (this.errorCollector.hasErrors()) {
            this.annotation.setValid(false);
            return this.annotation;
        }
        Map attributes = this.annotation.getMembers();
        Iterator it = attributes.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            String attrName = (String)entry.getKey();
            Expression attrExpr = (Expression)entry.getValue();
            Class attrType = this.getAttributeType(attrName);
            if (attrType == null) {
                this.addError("Unknown attribute '" + attrName + "'", attrExpr);
                break;
            }
            this.visitExpression(attrName, attrExpr, attrType);
        }
        if (!this.requiredAttrTypes.isEmpty()) {
            this.addError("Required attributes " + this.requiredAttrTypes.keySet() + " not found", this.annotation);
        }
        this.annotation.setValid(!this.errorCollector.hasErrors());
        return this.annotation;
    }

    private boolean isValidAnnotationClass(AnnotationNode node) {
        return node.getClassNode().implementsInterface(ClassHelper.Annotation_Type);
    }

    protected void visitExpression(String attrName, Expression attrExp, Class attrType) {
        if (attrType.isArray()) {
            if (attrExp instanceof ListExpression) {
                ListExpression le = (ListExpression)attrExp;
                this.visitListExpression(attrName, (ListExpression)attrExp, attrType.getComponentType());
            } else if (attrExp instanceof ClosureExpression) {
                this.addError("Annotation list attributes must use Groovy notation [el1, el2]", attrExp);
            } else {
                ListExpression listExp = new ListExpression();
                listExp.addExpression(attrExp);
                if (this.annotation != null) {
                    this.annotation.setMember(attrName, listExp);
                }
                this.visitExpression(attrName, listExp, attrType);
            }
        }
        if (attrType.isPrimitive()) {
            this.visitConstantExpression(attrName, (ConstantExpression)attrExp, ClassHelper.getWrapper(ClassHelper.make(attrType)));
        } else if (String.class.equals(attrType)) {
            this.visitConstantExpression(attrName, (ConstantExpression)attrExp, ClassHelper.make(String.class));
        } else if (!Class.class.equals(attrType)) {
            if (this.isEnum(attrType)) {
                if (attrExp instanceof PropertyExpression) {
                    this.visitEnumExpression(attrName, (PropertyExpression)attrExp, ClassHelper.make(attrType));
                } else {
                    this.addError("Value not defined for annotation attribute " + attrName, attrExp);
                }
            } else if (this.isAnnotation(attrType)) {
                this.visitAnnotationExpression(attrName, (AnnotationConstantExpression)attrExp, attrType);
            }
        }
    }

    protected void visitAnnotationExpression(String attrName, AnnotationConstantExpression expression, Class attrType) {
        AnnotationNode annotationNode = (AnnotationNode)expression.getValue();
        AnnotationVisitor visitor = new AnnotationVisitor(this.source, this.errorCollector);
        visitor.visit(annotationNode);
    }

    protected void visitListExpression(String attrName, ListExpression listExpr, Class elementType) {
        List expressions = listExpr.getExpressions();
        for (int i = 0; i < expressions.size(); ++i) {
            this.visitExpression(attrName, (Expression)expressions.get(i), elementType);
        }
    }

    protected void visitConstantExpression(String attrName, ConstantExpression constExpr, ClassNode attrType) {
        if (!constExpr.getType().isDerivedFrom(attrType)) {
            this.addError("Attribute '" + attrName + "' should have type '" + attrType.getName() + "'; " + "but found type '" + constExpr.getType().getName() + "'", constExpr);
        }
    }

    protected void visitEnumExpression(String attrName, PropertyExpression propExpr, ClassNode attrType) {
        if (!propExpr.getObjectExpression().getType().isDerivedFrom(attrType)) {
            this.addError("Attribute '" + attrName + "' should have type '" + attrType.getName() + "' (Enum), but found " + propExpr.getObjectExpression().getType().getName(), propExpr);
        }
    }

    private boolean isAnnotation(Class clazz) {
        Boolean result = (Boolean)this.invoke(clazz.getClass(), "isAnnotation", EMPTY_ARG_TYPES, clazz, EMPTY_ARGS);
        return result;
    }

    private boolean isEnum(Class clazz) {
        Boolean result = (Boolean)this.invoke(clazz.getClass(), "isEnum", EMPTY_ARG_TYPES, clazz, EMPTY_ARGS);
        return result;
    }

    private void extractAnnotationMeta(Class annotationClass) {
        this.initializeAnnotationMeta(annotationClass);
        this.initializeAttributeTypes(annotationClass);
    }

    private void initializeAnnotationMeta(Class annotationClass) {
        Object[] annotations = (Object[])this.invoke(annotationClass.getClass(), "getAnnotations", EMPTY_ARG_TYPES, annotationClass, EMPTY_ARGS);
        if (annotations == null) {
            this.addError("Cannot retrieve annotation meta information. Please make sure you are running on a JVM >= 1.5");
            return;
        }
        for (int i = 0; i < annotations.length; ++i) {
            Class annotationType = (Class)this.invoke(this.annotationRootClass, "annotationType", EMPTY_ARG_TYPES, annotations[i], EMPTY_ARGS);
            if (annotationType == null) continue;
            if ("java.lang.annotation.Retention".equals(annotationType.getName())) {
                this.initializeRetention(annotationClass, annotationType, annotations[i]);
                continue;
            }
            if (!"java.lang.annotation.Target".equals(annotationType.getName())) continue;
            this.initializeTarget(annotationClass, annotationType, annotations[i]);
        }
    }

    private void initializeAttributeTypes(Class annotationClass) {
        Method[] methods = annotationClass.getDeclaredMethods();
        for (int i = 0; i < methods.length; ++i) {
            Object defaultValue = this.invoke(class$java$lang$reflect$Method == null ? AnnotationVisitor.class$("java.lang.reflect.Method") : class$java$lang$reflect$Method, "getDefaultValue", EMPTY_ARG_TYPES, methods[i], EMPTY_ARGS);
            if (defaultValue != null) {
                this.defaultAttrTypes.put(methods[i].getName(), methods[i].getReturnType());
                continue;
            }
            this.requiredAttrTypes.put(methods[i].getName(), methods[i].getReturnType());
        }
    }

    private void initializeRetention(Class annotationClass, Class retentionClass, Object retentionAnnotation) {
        Object retentionPolicyEnum = this.invoke(retentionClass, "value", EMPTY_ARG_TYPES, retentionAnnotation, EMPTY_ARGS);
        if (retentionPolicyEnum == null) {
            this.addError("Cannot read @RetentionPolicy on the @" + annotationClass.getName() + "Please make sure you are running on a JVM >= 1.5");
            return;
        }
        if ("RUNTIME".equals(retentionPolicyEnum.toString())) {
            this.annotation.setRuntimeRetention(true);
        } else if ("SOURCE".equals(retentionPolicyEnum.toString())) {
            this.annotation.setSourceRetention(true);
        }
    }

    private void initializeTarget(Class annotationClass, Class targetClass, Object targetAnnotation) {
        Object[] elementTypeEnum = (Object[])this.invoke(targetClass, "value", EMPTY_ARG_TYPES, targetAnnotation, EMPTY_ARGS);
        if (elementTypeEnum == null) {
            this.addError("Cannot read @Target on the @" + annotationClass.getName() + "Please make sure you are running on a JVM >= 1.5");
            return;
        }
        int bitmap = 0;
        for (int i = 0; i < elementTypeEnum.length; ++i) {
            String targetName = elementTypeEnum[i].toString();
            if ("TYPE".equals(targetName)) {
                bitmap |= 1;
                continue;
            }
            if ("CONSTRUCTOR".equals(targetName)) {
                bitmap |= 2;
                continue;
            }
            if ("METHOD".equals(targetName)) {
                bitmap |= 4;
                continue;
            }
            if ("FIELD".equals(targetName)) {
                bitmap |= 8;
                continue;
            }
            if ("PARAMETER".equals(targetName)) {
                bitmap |= 0x10;
                continue;
            }
            if ("LOCAL_VARIABLE".equals(targetName)) {
                bitmap |= 0x20;
                continue;
            }
            if (!"ANNOTATION".equals(targetName)) continue;
            bitmap |= 0x40;
        }
        this.annotation.setAllowedTargets(bitmap);
    }

    protected void addError(String msg) {
        this.errorCollector.addErrorAndContinue(new SyntaxErrorMessage(new SyntaxException(msg + " in @" + this.annotationClass.getName() + '\n', this.annotation.getLineNumber(), this.annotation.getColumnNumber()), this.source));
    }

    protected void addError(String msg, ASTNode expr) {
        this.errorCollector.addErrorAndContinue(new SyntaxErrorMessage(new SyntaxException(msg + " in @" + this.annotationClass.getName() + '\n', expr.getLineNumber(), expr.getColumnNumber()), this.source));
    }

    private Class getAttributeType(String attr) {
        if (this.requiredAttrTypes.containsKey(attr)) {
            return (Class)this.requiredAttrTypes.remove(attr);
        }
        return (Class)this.defaultAttrTypes.remove(attr);
    }

    private Object invoke(Class clazz, String methodName, Class[] argTypes, Object target, Object[] args) {
        try {
            Method m = clazz.getMethod(methodName, argTypes);
            return m.invoke(target, args);
        }
        catch (Throwable cause) {
            return null;
        }
    }

    private Class loadAnnotationRootClass() {
        try {
            return Class.forName("java.lang.annotation.Annotation");
        }
        catch (Throwable throwable) {
            return null;
        }
    }
}

